/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.downloader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.util.HashUtil;

public class ModDownloader {
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
    private static final int MAX_RETRIES = 3;
    private static final long INITIAL_BACKOFF_MS = 1000L;
    private boolean resumeSupport = true;

    public void setResumeSupport(boolean enabled) {
        this.resumeSupport = enabled;
    }

    public boolean downloadTo(String url, Path destination, Consumer<Double> progressCallback) {
        return this.downloadTo(url, destination, progressCallback, this.resumeSupport);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean downloadTo(String url, Path destination, Consumer<Double> progressCallback, boolean useResume) {
        long backoff = 1000L;
        Path temp = destination.resolveSibling(String.valueOf(destination.getFileName()) + ".part");
        for (int attempt = 1; attempt <= 3; ++attempt) {
            block37: {
                long existingBytes = 0L;
                if (useResume && Files.exists(temp, new LinkOption[0])) {
                    try {
                        existingBytes = Files.size(temp);
                        if (existingBytes > 0L) {
                            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Resuming download from {} bytes", (Object)existingBytes);
                        }
                    }
                    catch (IOException e) {
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Could not read partial file size: {}", (Object)e.getMessage());
                        existingBytes = 0L;
                    }
                }
                Request.Builder reqBuilder = new Request.Builder().url(url).get().header("User-Agent", "downloadbypass/1.0 (Minecraft 1.20.1)");
                if (existingBytes > 0L) {
                    reqBuilder.header("Range", "bytes=" + existingBytes + "-");
                }
                Request request = reqBuilder.build();
                Call call = this.client.newCall(request);
                try (Response response = call.execute();){
                    int code = response.code();
                    if (code != 200 && code != 206 || response.body() == null) {
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Download failed (attempt {}/{}): {} {}", (Object)attempt, (Object)3, (Object)code, (Object)response.message());
                        if (code != 416 && (existingBytes <= 0L || code == 206)) break block37;
                        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Server doesn't support resume, restarting download");
                        try {
                            Files.deleteIfExists(temp);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        existingBytes = 0L;
                        continue;
                    }
                    long contentLength = response.body().contentLength();
                    long total = existingBytes + contentLength;
                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                    boolean append = code == 206 && existingBytes > 0L;
                    try (InputStream in = response.body().byteStream();
                         BufferedSink sink2 = append ? Okio.buffer(Okio.appendingSink(temp.toFile())) : Okio.buffer(Okio.sink(temp, new OpenOption[0]));){
                        int read;
                        byte[] buf = new byte[8192];
                        long readTotal = existingBytes;
                        while ((read = in.read(buf)) != -1) {
                            sink2.write(buf, 0, read);
                            readTotal += (long)read;
                            if (progressCallback == null || total <= 0L) continue;
                            double frac = Math.max(0.0, Math.min(1.0, (double)readTotal / (double)total));
                            progressCallback.accept(frac);
                        }
                        sink2.flush();
                    }
                    Files.deleteIfExists(destination);
                    Files.move(temp, destination, new CopyOption[0]);
                    Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Download completed: {}", (Object)destination.getFileName());
                    boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Download IO error (attempt {}/{}): {}", (Object)attempt, (Object)3, (Object)e.getMessage());
                    if (useResume) break block37;
                    try {
                        Files.deleteIfExists(temp);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (attempt >= 3) continue;
            try {
                Thread.sleep(backoff);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            backoff = Math.min(backoff * 2L, 8000L);
        }
        try {
            Files.deleteIfExists(temp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Exhausted retries for {}", (Object)destination.getFileName());
        return false;
    }

    public boolean verify(Path file, Long expectedSize, String expectedMd5, String expectedSha256) {
        try {
            long size;
            if (expectedSize != null && expectedSize > 0L && (size = Files.size(file)) != expectedSize) {
                Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Size mismatch for {}. Expected {}, got {}", (Object)file.getFileName(), (Object)expectedSize, (Object)size);
                return false;
            }
            if (expectedSha256 != null && !expectedSha256.isBlank()) {
                if (!HashUtil.matchesSha256(file, expectedSha256)) {
                    Downloadbypass.LOGGER.error("[EXTERNAL-MODS] SHA-256 mismatch for {}", (Object)file.getFileName());
                    return false;
                }
            } else if (expectedMd5 != null && !expectedMd5.isBlank() && !HashUtil.matchesMd5(file, expectedMd5)) {
                Downloadbypass.LOGGER.error("[EXTERNAL-MODS] MD5 mismatch for {}", (Object)file.getFileName());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Verification IO error: {}", (Object)e.getMessage());
            return false;
        }
    }
}

