/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.downloader;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.ModDependency;
import org.texboobcat.downloadbypass.downloader.ModFile;

public class MavenAPI {
    private OkHttpClient client;
    private static final int MAX_RETRIES = 3;
    private static final long INITIAL_BACKOFF_MS = 500L;

    private OkHttpClient client() {
        if (this.client == null) {
            this.client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).followRedirects(true).build();
        }
        return this.client;
    }

    public ModFile getArtifact(String repositoryUrl, String groupId, String artifactId, String version, String classifier, String extension) {
        if (repositoryUrl == null || ((String)repositoryUrl).isBlank()) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Maven repository URL is required");
            return null;
        }
        if (groupId == null || artifactId == null || version == null) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Maven coordinates (groupId, artifactId, version) are required");
            return null;
        }
        if (!((String)repositoryUrl).endsWith("/")) {
            repositoryUrl = (String)repositoryUrl + "/";
        }
        String groupPath = groupId.replace('.', '/');
        String fileName = artifactId + "-" + version;
        if (classifier != null && !classifier.isBlank()) {
            fileName = fileName + "-" + classifier;
        }
        fileName = fileName + "." + (extension != null && !extension.isBlank() ? extension : "jar");
        String url = (String)repositoryUrl + groupPath + "/" + artifactId + "/" + version + "/" + fileName;
        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Attempting Maven download: {}", (Object)url);
        return this.probeArtifact(url, fileName);
    }

    public ModFile resolveModFile(ModDependency dep) {
        if (dep == null) {
            return null;
        }
        String repoUrl = dep.getMavenRepository();
        String groupId = dep.getMavenGroupId();
        String artifactId = dep.getMavenArtifactId();
        String version = dep.getMavenVersion();
        String classifier = dep.getMavenClassifier();
        String extension = dep.getMavenExtension();
        if (repoUrl == null || groupId == null || artifactId == null || version == null) {
            return null;
        }
        return this.getArtifact(repoUrl, groupId, artifactId, version, classifier, extension);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModFile probeArtifact(String url, String fileName) {
        Request request = new Request.Builder().url(url).head().header("User-Agent", "downloadbypass/1.0 (Minecraft Mod Downloader)").build();
        long backoff = 500L;
        int attempt = 1;
        while (attempt <= 3) {
            block17: {
                try (Response response = this.client().newCall(request).execute();){
                    if (response.isSuccessful()) {
                        long size = -1L;
                        String contentLength = response.header("Content-Length");
                        if (contentLength != null) {
                            try {
                                size = Long.parseLong(contentLength);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Maven artifact found: {} (size: {} bytes)", (Object)fileName, (Object)size);
                        ModFile modFile = new ModFile(fileName, url, size);
                        return modFile;
                    }
                    int code = response.code();
                    boolean retryable = code == 429 || code == 503;
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Maven artifact probe failed (attempt {}/{}): {} {}", (Object)attempt, (Object)3, (Object)code, (Object)response.message());
                    if (!retryable || attempt == 3) {
                        ModFile modFile = null;
                        return modFile;
                    }
                }
                catch (IOException e) {
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Maven probe IO error (attempt {}/{}): {}", (Object)attempt, (Object)3, (Object)e.getMessage());
                    if (attempt != 3) break block17;
                    return null;
                }
            }
            try {
                Thread.sleep(backoff);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            backoff = Math.min(backoff * 2L, 4000L);
            ++attempt;
        }
        return null;
    }

    public static class CommonRepositories {
        public static final String MAVEN_CENTRAL = "https://repo1.maven.org/maven2/";
        public static final String CURSE_MAVEN = "https://www.cursemaven.com/";
        public static final String MINECRAFT_FORGE = "https://maven.minecraftforge.net/";
        public static final String FABRIC_MC = "https://maven.fabricmc.net/";
        public static final String SPONGE = "https://repo.spongepowered.org/maven/";
        public static final String JITPACK = "https://jitpack.io/";
    }
}

