/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.downloader;

import java.net.URLDecoder;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.DownloadSource;
import org.texboobcat.downloadbypass.config.ModDependency;
import org.texboobcat.downloadbypass.downloader.CurseForgeAPI;
import org.texboobcat.downloadbypass.downloader.GitHubAPI;
import org.texboobcat.downloadbypass.downloader.GitLabAPI;
import org.texboobcat.downloadbypass.downloader.MavenAPI;
import org.texboobcat.downloadbypass.downloader.ModFile;
import org.texboobcat.downloadbypass.downloader.ModrinthAPI;

public class ModFileResolver {
    private final CurseForgeAPI curseForgeAPI = new CurseForgeAPI();
    private final GitHubAPI githubAPI = new GitHubAPI();
    private final GitLabAPI gitlabAPI = new GitLabAPI();
    private final ModrinthAPI modrinthAPI = new ModrinthAPI();
    private final MavenAPI mavenAPI = new MavenAPI();

    public ModFile resolve(ModDependency dep) {
        if (dep == null) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Cannot resolve null dependency");
            return null;
        }
        DownloadSource source2 = dep.detectSource();
        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Resolving {} from source: {}", (Object)dep.getName(), (Object)source2);
        try {
            switch (source2) {
                case CURSEFORGE: {
                    return this.resolveCurseForge(dep);
                }
                case GITHUB: {
                    return this.resolveGitHub(dep);
                }
                case GITLAB: {
                    return this.resolveGitLab(dep);
                }
                case MODRINTH: {
                    return this.resolveModrinth(dep);
                }
                case MAVEN: {
                    return this.resolveMaven(dep);
                }
                case DIRECT_URL: {
                    return this.resolveDirectUrl(dep);
                }
            }
            return this.resolveAuto(dep);
        }
        catch (Exception e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Error resolving {}: {}", (Object)dep.getName(), (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private ModFile resolveCurseForge(ModDependency dep) {
        if (dep.getCurseforgeId() == null || dep.getFileId() == null) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] CurseForge source requires curseforge_id and file_id for {}", (Object)dep.getName());
            return null;
        }
        ModFile result = this.curseForgeAPI.resolveModFile(dep);
        if (result != null) {
            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Resolved {} from CurseForge: {}", (Object)dep.getName(), (Object)result.getDownloadUrl());
        }
        return result;
    }

    private ModFile resolveGitHub(ModDependency dep) {
        String owner = dep.getGithubOwner();
        String repo = dep.getGithubRepo();
        if (owner == null || owner.isBlank() || repo == null || repo.isBlank()) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] GitHub source requires github_owner and github_repo for {}", (Object)dep.getName());
            return null;
        }
        ModFile result = this.githubAPI.resolveModFile(dep);
        if (result != null) {
            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Resolved {} from GitHub: {}", (Object)dep.getName(), (Object)result.getDownloadUrl());
        }
        return result;
    }

    private ModFile resolveGitLab(ModDependency dep) {
        String projectPath = dep.getGitlabProject();
        if (projectPath == null || projectPath.isBlank()) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] GitLab source requires gitlab_project for {}", (Object)dep.getName());
            return null;
        }
        ModFile result = this.gitlabAPI.resolveModFile(dep);
        if (result != null) {
            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Resolved {} from GitLab: {}", (Object)dep.getName(), (Object)result.getDownloadUrl());
        }
        return result;
    }

    private ModFile resolveModrinth(ModDependency dep) {
        String projectId = dep.getModrinthProjectId();
        if (projectId == null || projectId.isBlank()) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Modrinth source requires modrinth_project_id for {}", (Object)dep.getName());
            return null;
        }
        ModFile result = this.modrinthAPI.resolveModFile(dep);
        if (result != null) {
            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Resolved {} from Modrinth: {}", (Object)dep.getName(), (Object)result.getDownloadUrl());
        }
        return result;
    }

    private ModFile resolveMaven(ModDependency dep) {
        String repository = dep.getMavenRepository();
        String groupId = dep.getMavenGroupId();
        String artifactId = dep.getMavenArtifactId();
        String version = dep.getMavenVersion();
        if (repository == null || groupId == null || artifactId == null || version == null) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Maven source requires maven_repository, maven_group_id, maven_artifact_id, and maven_version for {}", (Object)dep.getName());
            return null;
        }
        ModFile result = this.mavenAPI.resolveModFile(dep);
        if (result != null) {
            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Resolved {} from Maven: {}", (Object)dep.getName(), (Object)result.getDownloadUrl());
        }
        return result;
    }

    private ModFile resolveDirectUrl(ModDependency dep) {
        String url = dep.getDownloadUrl();
        if (url == null || url.isBlank()) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Direct URL source requires download_url for {}", (Object)dep.getName());
            return null;
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Invalid download URL for {}: {}", (Object)dep.getName(), (Object)url);
            return null;
        }
        String fileName = this.extractFileNameFromUrl(url);
        if (fileName == null || fileName.isBlank()) {
            fileName = dep.getSlug() != null ? dep.getSlug() + ".jar" : "mod.jar";
        }
        ModFile result = new ModFile(fileName, url, -1L);
        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Resolved {} from direct URL: {}", (Object)dep.getName(), (Object)url);
        return result;
    }

    private ModFile resolveAuto(ModDependency dep) {
        ModFile result;
        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Auto-resolving {} - trying all available sources", (Object)dep.getName());
        if (dep.getDownloadUrl() != null && !dep.getDownloadUrl().isBlank() && (result = this.resolveDirectUrl(dep)) != null) {
            return result;
        }
        if (dep.getMavenRepository() != null && dep.getMavenGroupId() != null && dep.getMavenArtifactId() != null && dep.getMavenVersion() != null && (result = this.resolveMaven(dep)) != null) {
            return result;
        }
        if (dep.getGitlabProject() != null && !dep.getGitlabProject().isBlank() && (result = this.resolveGitLab(dep)) != null) {
            return result;
        }
        if (dep.getGithubOwner() != null && dep.getGithubRepo() != null && (result = this.resolveGitHub(dep)) != null) {
            return result;
        }
        if (dep.getModrinthProjectId() != null && !dep.getModrinthProjectId().isBlank() && (result = this.resolveModrinth(dep)) != null) {
            return result;
        }
        if (dep.getCurseforgeId() != null && dep.getFileId() != null && (result = this.resolveCurseForge(dep)) != null) {
            return result;
        }
        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Could not resolve {} from any source", (Object)dep.getName());
        return null;
    }

    private String extractFileNameFromUrl(String url) {
        block7: {
            if (url == null || url.isBlank()) {
                return null;
            }
            try {
                int lastSlash;
                int fragmentIndex;
                int queryIndex = url.indexOf(63);
                if (queryIndex > 0) {
                    url = url.substring(0, queryIndex);
                }
                if ((fragmentIndex = url.indexOf(35)) > 0) {
                    url = url.substring(0, fragmentIndex);
                }
                if ((lastSlash = url.lastIndexOf(47)) < 0 || lastSlash >= url.length() - 1) break block7;
                String fileName = url.substring(lastSlash + 1);
                try {
                    fileName = URLDecoder.decode(fileName, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return fileName;
            }
            catch (Exception e) {
                Downloadbypass.LOGGER.debug("[EXTERNAL-MODS] Failed to extract filename from URL: {}", (Object)url);
            }
        }
        return null;
    }

    public CurseForgeAPI getCurseForgeAPI() {
        return this.curseForgeAPI;
    }

    public GitHubAPI getGitHubAPI() {
        return this.githubAPI;
    }

    public GitLabAPI getGitLabAPI() {
        return this.gitlabAPI;
    }

    public ModrinthAPI getModrinthAPI() {
        return this.modrinthAPI;
    }

    public MavenAPI getMavenAPI() {
        return this.mavenAPI;
    }
}

