/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.downloader;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.downloader.ModDownloader;

public class ParallelDownloadManager {
    private static final int DEFAULT_MAX_CONCURRENT = 3;
    private final ModDownloader downloader;
    private final ExecutorService executor;
    private final int maxConcurrent;

    public ParallelDownloadManager() {
        this(3);
    }

    public ParallelDownloadManager(int maxConcurrent) {
        this.maxConcurrent = maxConcurrent;
        this.downloader = new ModDownloader();
        this.executor = Executors.newFixedThreadPool(maxConcurrent, r -> {
            Thread t = new Thread(r, "mod-downloader");
            t.setDaemon(true);
            return t;
        });
    }

    public List<DownloadResult> downloadAll(List<DownloadTask> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return new ArrayList<DownloadResult>();
        }
        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Starting parallel downloads: {} files, max {} concurrent", (Object)tasks.size(), (Object)this.maxConcurrent);
        ArrayList<Future> futures = new ArrayList<Future>();
        for (DownloadTask downloadTask : tasks) {
            Future future = this.executor.submit(() -> {
                try {
                    Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Starting download: {}", (Object)task.fileName);
                    boolean success = this.downloader.downloadTo(task.url, task.destination, task.progressCallback);
                    return new DownloadResult(task.fileName, task.url, success, null);
                }
                catch (Exception e) {
                    Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Download exception for {}: {}", (Object)task.fileName, (Object)e.getMessage());
                    return new DownloadResult(task.fileName, task.url, false, e);
                }
            });
            futures.add(future);
        }
        ArrayList<DownloadResult> results = new ArrayList<DownloadResult>();
        for (Future future : futures) {
            try {
                DownloadResult result = (DownloadResult)future.get();
                results.add(result);
            }
            catch (InterruptedException | ExecutionException e) {
                Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Failed to get download result: {}", (Object)e.getMessage());
                results.add(new DownloadResult("unknown", "unknown", false, e));
            }
        }
        int n = (int)results.stream().filter(r -> r.success).count();
        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Parallel downloads completed: {}/{} successful", (Object)n, (Object)tasks.size());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadResult> downloadAll(List<DownloadTask> tasks, long timeoutMinutes) {
        if (tasks == null || tasks.isEmpty()) {
            return new ArrayList<DownloadResult>();
        }
        ExecutorService timeoutExecutor = Executors.newSingleThreadExecutor();
        try {
            Future<List> future = timeoutExecutor.submit(() -> this.downloadAll(tasks));
            List list = future.get(timeoutMinutes, TimeUnit.MINUTES);
            return list;
        }
        catch (TimeoutException e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Parallel download timeout after {} minutes", (Object)timeoutMinutes);
            ArrayList<DownloadResult> arrayList = new ArrayList<DownloadResult>();
            return arrayList;
        }
        catch (Exception e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Parallel download error: {}", (Object)e.getMessage());
            ArrayList<DownloadResult> arrayList = new ArrayList<DownloadResult>();
            return arrayList;
        }
        finally {
            timeoutExecutor.shutdownNow();
        }
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }

    public static class DownloadTask {
        public final String fileName;
        public final String url;
        public final Path destination;
        public final Consumer<Double> progressCallback;

        public DownloadTask(String fileName, String url, Path destination) {
            this(fileName, url, destination, null);
        }

        public DownloadTask(String fileName, String url, Path destination, Consumer<Double> progressCallback) {
            this.fileName = fileName;
            this.url = url;
            this.destination = destination;
            this.progressCallback = progressCallback;
        }
    }

    public static class DownloadResult {
        public final String fileName;
        public final String url;
        public final boolean success;
        public final Exception error;

        public DownloadResult(String fileName, String url, boolean success, Exception error) {
            this.fileName = fileName;
            this.url = url;
            this.success = success;
            this.error = error;
        }

        public String toString() {
            return String.format("DownloadResult{file='%s', success=%s%s}", this.fileName, this.success, this.error != null ? ", error=" + this.error.getMessage() : "");
        }
    }
}

