/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.ui;

import java.awt.Desktop;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.downloadbypass.Downloadbypass;

public class SecurityAlertsScreen
extends class_437 {
    private final List<AlertEntry> entries;
    private final BiConsumer<String, String> ackCallback;
    private final Runnable onCloseAll;

    public SecurityAlertsScreen(List<AlertEntry> entries, BiConsumer<String, String> ackCallback, Runnable onCloseAll) {
        super((class_2561)class_2561.method_43470((String)"Security Alerts"));
        this.entries = new ArrayList<AlertEntry>((Collection)Objects.requireNonNull(entries));
        this.ackCallback = Objects.requireNonNull(ackCallback);
        this.onCloseAll = Objects.requireNonNull(onCloseAll);
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int y = 40;
        int idx = 0;
        for (AlertEntry e : this.entries) {
            int rowY = y + idx * 70;
            if (e.vtReportUrl != null && !e.vtReportUrl.isBlank()) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open VT Report"), b -> {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            Desktop.getDesktop().browse(new URI(e.vtReportUrl));
                        }
                    }
                    catch (Exception ex) {
                        Downloadbypass.LOGGER.warn("[SECURITY] Failed to open VT URL: {}", (Object)ex.toString());
                    }
                }).method_46433(centerX - 230, rowY + 20).method_46437(120, 20).method_46431());
            }
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Quarantine"), b -> {
                try {
                    if (e.filePath != null && Files.exists(e.filePath, new LinkOption[0])) {
                        Path qdir = e.filePath.getParent().resolve(".quarantine");
                        Files.createDirectories(qdir, new FileAttribute[0]);
                        Path dest = qdir.resolve(e.filePath.getFileName().toString());
                        int suffix = 1;
                        while (Files.exists(dest, new LinkOption[0])) {
                            dest = qdir.resolve(e.filePath.getFileName().toString() + "." + suffix);
                            ++suffix;
                        }
                        Files.move(e.filePath, dest, new CopyOption[0]);
                    }
                }
                catch (Exception ex) {
                    Downloadbypass.LOGGER.warn("[SECURITY] Quarantine failed for {}: {}", (Object)e.filePath, (Object)ex.getMessage());
                }
                try {
                    this.ackCallback.accept(e.alertId, "quarantined");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).method_46433(centerX - 100, rowY + 20).method_46437(100, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), b -> {
                try {
                    if (e.filePath != null && Files.exists(e.filePath, new LinkOption[0])) {
                        Files.delete(e.filePath);
                    }
                }
                catch (Exception ex) {
                    Downloadbypass.LOGGER.warn("[SECURITY] Delete failed for {}: {}", (Object)e.filePath, (Object)ex.getMessage());
                }
                try {
                    this.ackCallback.accept(e.alertId, "deleted");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).method_46433(centerX + 10, rowY + 20).method_46437(80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Ignore"), b -> {
                try {
                    this.ackCallback.accept(e.alertId, "ignored");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).method_46433(centerX + 100, rowY + 20).method_46437(80, 20).method_46431());
            ++idx;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.onCloseAll.run()).method_46433(centerX - 40, this.field_22790 - 40).method_46437(80, 20).method_46431());
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        int centerX = this.field_22789 / 2;
        g.method_27534(this.field_22793, this.method_25440(), centerX, 10, 0xFFFFFF);
        int y = 40;
        int idx = 0;
        for (AlertEntry e : this.entries) {
            int rowY = y + idx * 70;
            String head = (String)(e.severity != null ? "[" + e.severity.toUpperCase() + "] " : "") + SecurityAlertsScreen.shortSha(e.sha256);
            g.method_25300(this.field_22793, head, centerX, rowY, 0xFF5555);
            g.method_25300(this.field_22793, e.reason != null ? e.reason : "Malicious file detected.", centerX, rowY + 10, 0xAAAAAA);
            ++idx;
        }
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    private static String shortSha(String sha) {
        if (sha == null) {
            return "unknown";
        }
        return sha.length() > 12 ? sha.substring(0, 12) + "\u2026" : sha;
    }

    public static class AlertEntry {
        public final String alertId;
        public final String sha256;
        public final String reason;
        public final String severity;
        public final String vtReportUrl;
        public final Path filePath;

        public AlertEntry(String alertId, String sha256, String reason, String severity, String vtReportUrl, Path filePath) {
            this.alertId = alertId;
            this.sha256 = sha256;
            this.reason = reason;
            this.severity = severity;
            this.vtReportUrl = vtReportUrl;
            this.filePath = filePath;
        }
    }
}

