/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.ui;

import java.awt.Desktop;
import java.net.URI;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.ModDependency;

public class StartupPrompt
extends class_437 {
    private final ModDependency mod;
    private final boolean required;
    private final Consumer<Boolean> resultCallback;
    private class_4185 yesButton;
    private class_4185 noButton;
    private class_4185 openButton;
    private double progress = 0.0;
    private boolean downloading = false;
    private String statusLine = null;

    public StartupPrompt(ModDependency mod, Consumer<Boolean> resultCallback) {
        super((class_2561)class_2561.method_43470((String)"Missing External Mod"));
        this.mod = mod;
        this.required = mod != null && mod.isRequired();
        this.resultCallback = resultCallback;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.yesButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Yes, Download"), btn -> this.onYes()).method_46433(centerX - 155, centerY + 40).method_46437(150, 20).method_46431();
        this.noButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.required ? "No, Exit Game" : "No, Skip")), btn -> this.onNo()).method_46433(centerX + 5, centerY + 40).method_46437(150, 20).method_46431();
        this.openButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open Page"), btn -> this.onOpenPage()).method_46433(centerX - 75, centerY + 65).method_46437(150, 20).method_46431();
        this.method_37063((class_364)this.yesButton);
        this.method_37063((class_364)this.noButton);
        this.method_37063((class_364)this.openButton);
    }

    private void onYes() {
        if (this.downloading) {
            return;
        }
        this.downloading = true;
        this.yesButton.field_22763 = false;
        this.noButton.field_22763 = false;
        if (this.resultCallback != null) {
            this.resultCallback.accept(Boolean.TRUE);
        }
    }

    private void onNo() {
        if (this.resultCallback != null) {
            this.resultCallback.accept(Boolean.FALSE);
        }
        if (this.required) {
            class_310.method_1551().method_1592();
        } else {
            class_310.method_1551().method_1507(null);
        }
    }

    private void onOpenPage() {
        String url = this.buildCurseUrl();
        if (url == null) {
            return;
        }
        try {
            class_310.method_1551().field_1774.method_1455(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (Exception e) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to open browser: {}", (Object)e.getMessage());
        }
    }

    private String buildCurseUrl() {
        if (this.mod == null) {
            return null;
        }
        String slug = this.mod.getSlug();
        Integer fileId = this.mod.getFileId();
        if (slug != null && fileId != null) {
            return "https://www.curseforge.com/minecraft/mc-mods/" + slug + "/files/" + fileId;
        }
        if (slug != null) {
            return "https://www.curseforge.com/minecraft/mc-mods/" + slug;
        }
        return null;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setDownloading(boolean downloading) {
        this.downloading = downloading;
    }

    public void setStatus(String status) {
        this.statusLine = status;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        int centerX = this.field_22789 / 2;
        int y = this.field_22790 / 2 - 40;
        String title = this.required ? "Missing Required Mod" : "Missing Optional Mod";
        graphics.method_25300(this.field_22793, title, centerX, y, 0xFFFFFF);
        y += 15;
        if (this.mod != null) {
            graphics.method_25300(this.field_22793, this.mod.getName() + (String)(this.mod.getVersion() != null ? " v" + this.mod.getVersion() : ""), centerX, y, 0xAAAAAA);
            String reason = this.mod.getReason() != null ? this.mod.getReason() : "Unavailable on Modrinth.";
            graphics.method_25300(this.field_22793, "Reason: " + reason, centerX, y += 12, 0xAAAAAA);
            y += 12;
            if (this.mod.getSizeBytes() != null && this.mod.getSizeBytes() > 0L) {
                double mb = (double)this.mod.getSizeBytes().longValue() / 1048576.0;
                graphics.method_25300(this.field_22793, String.format("Size: %.1f MB", mb), centerX, y, 0xAAAAAA);
                y += 12;
            }
            if (this.statusLine != null && !this.statusLine.isBlank()) {
                graphics.method_25300(this.field_22793, this.statusLine, centerX, y, 0x55FF55);
                y += 12;
            }
        }
        graphics.method_25300(this.field_22793, "Would you like to auto-install this mod?", centerX, y += 8, 0xFFFFFF);
        y += 18;
        if (this.downloading) {
            int barWidth = 200;
            int barX = centerX - barWidth / 2;
            int barY = y + 10;
            int filled = (int)((double)barWidth * Math.max(0.0, Math.min(1.0, this.progress)));
            graphics.method_25294(barX, barY, barX + barWidth, barY + 8, -11184811);
            graphics.method_25294(barX, barY, barX + filled, barY + 8, -14505438);
            String pct = String.format("Downloading... %d%%", (int)Math.round(this.progress * 100.0));
            graphics.method_25300(this.field_22793, pct, centerX, barY - 10, 0xFFFFFF);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }
}

