/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import java.util.UUID;
import org.texboobcat.downloadbypass.Downloadbypass;

public final class DeviceIdentity {
    private DeviceIdentity() {
    }

    public static String computeHashedHWID() {
        try {
            ArrayList<String> macs = new ArrayList<String>();
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces != null && ifaces.hasMoreElements()) {
                NetworkInterface ni = ifaces.nextElement();
                try {
                    byte[] mac;
                    if (ni == null || ni.isLoopback() || ni.isVirtual() || !ni.isUp() || (mac = ni.getHardwareAddress()) == null || mac.length <= 0) continue;
                    macs.add(DeviceIdentity.bytesToHex(mac));
                }
                catch (Exception mac) {}
            }
            Collections.sort(macs);
            String host = DeviceIdentity.safeHostName();
            String material = "downloadbypass|" + host + "|" + String.join((CharSequence)",", macs);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] dig = md.digest(material.getBytes(StandardCharsets.UTF_8));
            return DeviceIdentity.bytesToHex(dig);
        }
        catch (Exception e) {
            Downloadbypass.LOGGER.warn("[SECURITY] Failed to compute HWID hash: {}", (Object)e.toString());
            return UUID.randomUUID().toString().replace("-", "");
        }
    }

    private static String safeHostName() {
        try {
            return Optional.ofNullable(InetAddress.getLocalHost().getHostName()).orElse("unknown");
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(Character.forDigit(b >> 4 & 0xF, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
        }
        return sb.toString();
    }

    public static String getOrCreateDeviceId(Path configDir) {
        try {
            Path dir = configDir.resolve("downloadbypass");
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve("device.json");
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    String content = Files.readString(file, StandardCharsets.UTF_8).trim();
                    String id = DeviceIdentity.parseJsonField(content, "device_id");
                    if (id != null && !id.isBlank()) {
                        return id;
                    }
                }
                catch (Exception content) {
                    // empty catch block
                }
            }
            String hwid = DeviceIdentity.computeHashedHWID();
            String json = "{\n  \"device_id\": \"" + hwid + "\"\n}";
            Files.writeString(file, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            return hwid;
        }
        catch (IOException e) {
            Downloadbypass.LOGGER.warn("[SECURITY] Failed to persist device id: {}", (Object)e.getMessage());
            return DeviceIdentity.computeHashedHWID();
        }
    }

    private static String parseJsonField(String json, String field) {
        String key = "\"" + field + "\"";
        int i = json.indexOf(key);
        if (i < 0) {
            return null;
        }
        int c = json.indexOf(58, i + key.length());
        if (c < 0) {
            return null;
        }
        int q1 = json.indexOf(34, c + 1);
        if (q1 < 0) {
            return null;
        }
        int q2 = json.indexOf(34, q1 + 1);
        if (q2 < 0) {
            return null;
        }
        return json.substring(q1 + 1, q2);
    }
}

