/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.texboobcat.downloadbypass.Downloadbypass;

public final class InstalledManifest {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String MANIFEST_PATH = "config/external-mods-installed.json";

    private InstalledManifest() {
    }

    public static synchronized void recordInstall(String modName, String fileName, long sizeBytes, String md5, String sha256, String sourceUrl, long installedAtMillis) throws IOException {
        ManifestData data = InstalledManifest.read();
        if (data.installed == null) {
            data.installed = new ArrayList<InstalledEntry>();
        }
        Iterator<InstalledEntry> it = data.installed.iterator();
        while (it.hasNext()) {
            if (!Objects.equals(it.next().fileName, fileName)) continue;
            it.remove();
            break;
        }
        InstalledEntry e = new InstalledEntry();
        e.modName = modName;
        e.fileName = fileName;
        e.sizeBytes = sizeBytes;
        e.md5 = md5;
        e.sha256 = sha256;
        e.sourceUrl = sourceUrl;
        e.installedAt = installedAtMillis;
        data.installed.add(e);
        InstalledManifest.write(data);
    }

    public static synchronized void removeEntryByFile(String fileName) throws IOException {
        ManifestData data = InstalledManifest.read();
        if (data.installed == null) {
            return;
        }
        data.installed.removeIf(e -> Objects.equals(e.fileName, fileName));
        InstalledManifest.write(data);
    }

    public static synchronized List<InstalledEntry> list() throws IOException {
        ManifestData d = InstalledManifest.read();
        return d.installed != null ? new ArrayList<InstalledEntry>(d.installed) : List.of();
    }

    public static synchronized void clearAll() throws IOException {
        ManifestData data = new ManifestData();
        data.installed = new ArrayList<InstalledEntry>();
        InstalledManifest.write(data);
    }

    public static synchronized int removeAllInstalledMods(Path modsDir) throws IOException {
        ManifestData d = InstalledManifest.read();
        if (d.installed == null || d.installed.isEmpty()) {
            return 0;
        }
        int removed = 0;
        for (InstalledEntry e : new ArrayList<InstalledEntry>(d.installed)) {
            try {
                Path p;
                if (modsDir == null || !Files.exists(p = modsDir.resolve(e.fileName), new LinkOption[0])) continue;
                Files.delete(p);
                ++removed;
            }
            catch (Exception ex) {
                Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to delete {}: {}", (Object)e.fileName, (Object)ex.getMessage());
            }
        }
        InstalledManifest.clearAll();
        return removed;
    }

    private static ManifestData read() throws IOException {
        ManifestData manifestData;
        block9: {
            Path p = Paths.get(MANIFEST_PATH, new String[0]);
            if (!Files.exists(p, new LinkOption[0])) {
                return new ManifestData();
            }
            BufferedReader r = Files.newBufferedReader(p, StandardCharsets.UTF_8);
            try {
                ManifestData d = (ManifestData)GSON.fromJson((Reader)r, ManifestData.class);
                ManifestData manifestData2 = manifestData = d != null ? d : new ManifestData();
                if (r == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            ((Reader)r).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to read manifest: {}", (Object)e.getMessage());
                    return new ManifestData();
                }
            }
            ((Reader)r).close();
        }
        return manifestData;
    }

    private static void write(ManifestData data) throws IOException {
        Path p = Paths.get(MANIFEST_PATH, new String[0]);
        Files.createDirectories(p.getParent(), new FileAttribute[0]);
        try (BufferedWriter w = Files.newBufferedWriter(p, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((Object)data, (Appendable)w);
        }
    }

    public static class ManifestData {
        @SerializedName(value="installed")
        public List<InstalledEntry> installed;
    }

    public static class InstalledEntry {
        @SerializedName(value="mod_name")
        public String modName;
        @SerializedName(value="file_name")
        public String fileName;
        @SerializedName(value="size_bytes")
        public long sizeBytes;
        @SerializedName(value="md5")
        public String md5;
        @SerializedName(value="sha256")
        public String sha256;
        @SerializedName(value="source_url")
        public String sourceUrl;
        @SerializedName(value="installed_at")
        public long installedAt;
    }
}

