/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.config;

import com.google.gson.annotations.SerializedName;
import org.texboobcat.downloadbypass.config.DownloadSource;

public class ModDependency {
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="slug")
    private String slug;
    @SerializedName(value="curseforge_id")
    private Integer curseforgeId;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="required")
    private Boolean required;
    @SerializedName(value="reason")
    private String reason;
    @SerializedName(value="file_id")
    private Integer fileId;
    @SerializedName(value="md5_hash")
    private String md5Hash;
    @SerializedName(value="sha256_hash")
    private String sha256Hash;
    @SerializedName(value="size_bytes")
    private Long sizeBytes;
    @SerializedName(value="source")
    private String source;
    @SerializedName(value="download_url")
    private String downloadUrl;
    @SerializedName(value="github_owner")
    private String githubOwner;
    @SerializedName(value="github_repo")
    private String githubRepo;
    @SerializedName(value="github_tag")
    private String githubTag;
    @SerializedName(value="github_asset_id")
    private Long githubAssetId;
    @SerializedName(value="github_asset_pattern")
    private String githubAssetPattern;
    @SerializedName(value="modrinth_project_id")
    private String modrinthProjectId;
    @SerializedName(value="modrinth_version_id")
    private String modrinthVersionId;
    @SerializedName(value="modrinth_loader")
    private String modrinthLoader;
    @SerializedName(value="maven_repository")
    private String mavenRepository;
    @SerializedName(value="maven_group_id")
    private String mavenGroupId;
    @SerializedName(value="maven_artifact_id")
    private String mavenArtifactId;
    @SerializedName(value="maven_version")
    private String mavenVersion;
    @SerializedName(value="maven_classifier")
    private String mavenClassifier;
    @SerializedName(value="maven_extension")
    private String mavenExtension;
    @SerializedName(value="gitlab_host")
    private String gitlabHost;
    @SerializedName(value="gitlab_project")
    private String gitlabProject;
    @SerializedName(value="gitlab_tag")
    private String gitlabTag;
    @SerializedName(value="gitlab_asset_pattern")
    private String gitlabAssetPattern;

    public String getName() {
        return this.name;
    }

    public String getSlug() {
        return this.slug;
    }

    public Integer getCurseforgeId() {
        return this.curseforgeId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRequired() {
        return this.required != null && this.required != false;
    }

    public String getReason() {
        return this.reason;
    }

    public Integer getFileId() {
        return this.fileId;
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    public String getSha256Hash() {
        return this.sha256Hash;
    }

    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public DownloadSource getSource() {
        if (this.source == null || this.source.isBlank()) {
            return DownloadSource.AUTO;
        }
        try {
            return DownloadSource.valueOf(this.source.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return DownloadSource.AUTO;
        }
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getGithubOwner() {
        return this.githubOwner;
    }

    public String getGithubRepo() {
        return this.githubRepo;
    }

    public String getGithubTag() {
        return this.githubTag;
    }

    public Long getGithubAssetId() {
        return this.githubAssetId;
    }

    public String getGithubAssetPattern() {
        return this.githubAssetPattern;
    }

    public String getModrinthProjectId() {
        return this.modrinthProjectId;
    }

    public String getModrinthVersionId() {
        return this.modrinthVersionId;
    }

    public String getModrinthLoader() {
        return this.modrinthLoader;
    }

    public String getMavenRepository() {
        return this.mavenRepository;
    }

    public String getMavenGroupId() {
        return this.mavenGroupId;
    }

    public String getMavenArtifactId() {
        return this.mavenArtifactId;
    }

    public String getMavenVersion() {
        return this.mavenVersion;
    }

    public String getMavenClassifier() {
        return this.mavenClassifier;
    }

    public String getMavenExtension() {
        return this.mavenExtension;
    }

    public String getGitlabHost() {
        return this.gitlabHost;
    }

    public String getGitlabProject() {
        return this.gitlabProject;
    }

    public String getGitlabTag() {
        return this.gitlabTag;
    }

    public String getGitlabAssetPattern() {
        return this.gitlabAssetPattern;
    }

    public DownloadSource detectSource() {
        DownloadSource explicitSource = this.getSource();
        if (explicitSource != DownloadSource.AUTO) {
            return explicitSource;
        }
        if (this.downloadUrl != null && !this.downloadUrl.isBlank()) {
            return DownloadSource.DIRECT_URL;
        }
        if (this.mavenRepository != null && this.mavenGroupId != null && this.mavenArtifactId != null && this.mavenVersion != null) {
            return DownloadSource.MAVEN;
        }
        if (this.gitlabProject != null && !this.gitlabProject.isBlank()) {
            return DownloadSource.GITLAB;
        }
        if (this.githubOwner != null && !this.githubOwner.isBlank() && this.githubRepo != null && !this.githubRepo.isBlank()) {
            return DownloadSource.GITHUB;
        }
        if (this.modrinthProjectId != null && !this.modrinthProjectId.isBlank()) {
            return DownloadSource.MODRINTH;
        }
        if (this.curseforgeId != null && this.fileId != null) {
            return DownloadSource.CURSEFORGE;
        }
        return DownloadSource.AUTO;
    }
}

