/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.downloader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.ModDependency;
import org.texboobcat.downloadbypass.downloader.ModFile;

public class GitLabAPI {
    private static final String DEFAULT_API_BASE = "https://gitlab.com/api/v4";
    private OkHttpClient client;
    private static final int MAX_RETRIES = 3;
    private static final long INITIAL_BACKOFF_MS = 500L;

    private OkHttpClient client() {
        if (this.client == null) {
            this.client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).build();
        }
        return this.client;
    }

    public ModFile getLatestRelease(String gitlabHost, String projectPath, String assetPattern) {
        String encodedPath;
        String apiBase = this.buildApiBase(gitlabHost);
        String url = apiBase + "/projects/" + (encodedPath = this.urlEncode(projectPath)) + "/releases";
        JsonElement result = this.fetchJson(url);
        if (result == null || !result.isJsonArray()) {
            return null;
        }
        JsonArray releases = result.getAsJsonArray();
        if (releases.size() == 0) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] No GitLab releases found for project: {}", (Object)projectPath);
            return null;
        }
        JsonObject latestRelease = releases.get(0).getAsJsonObject();
        return this.extractAssetFromRelease(latestRelease, assetPattern);
    }

    public ModFile getReleaseByTag(String gitlabHost, String projectPath, String tag, String assetPattern) {
        String encodedTag;
        String encodedPath;
        String apiBase = this.buildApiBase(gitlabHost);
        String url = apiBase + "/projects/" + (encodedPath = this.urlEncode(projectPath)) + "/releases/" + (encodedTag = this.urlEncode(tag));
        JsonElement result = this.fetchJson(url);
        if (result == null || !result.isJsonObject()) {
            return null;
        }
        return this.extractAssetFromRelease(result.getAsJsonObject(), assetPattern);
    }

    public ModFile resolveModFile(ModDependency dep) {
        if (dep == null) {
            return null;
        }
        String host = dep.getGitlabHost();
        String projectPath = dep.getGitlabProject();
        if (host == null || host.isBlank()) {
            host = "gitlab.com";
        }
        if (projectPath == null || projectPath.isBlank()) {
            return null;
        }
        String tag = dep.getGitlabTag();
        String assetPattern = dep.getGitlabAssetPattern();
        if (tag != null && !tag.isBlank()) {
            return this.getReleaseByTag(host, projectPath, tag, assetPattern);
        }
        return this.getLatestRelease(host, projectPath, assetPattern);
    }

    private ModFile extractAssetFromRelease(JsonObject release, String assetPattern) {
        if (!release.has("assets")) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] GitLab release has no assets");
            return null;
        }
        JsonObject assets = release.getAsJsonObject("assets");
        if (!assets.has("links")) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] GitLab release assets has no links");
            return null;
        }
        JsonArray links = assets.getAsJsonArray("links");
        if (links.size() == 0) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] GitLab release assets links array is empty");
            return null;
        }
        JsonObject matchedLink = null;
        if (assetPattern != null && !assetPattern.isBlank()) {
            for (JsonElement elem : links) {
                String name;
                JsonObject link = elem.getAsJsonObject();
                if (!link.has("name") || link.get("name").isJsonNull() || !(name = link.get("name").getAsString()).matches(assetPattern)) continue;
                matchedLink = link;
                break;
            }
        } else {
            matchedLink = links.get(0).getAsJsonObject();
        }
        if (matchedLink == null) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] No GitLab asset matched pattern: {}", (Object)assetPattern);
            return null;
        }
        return this.parseLink(matchedLink);
    }

    private ModFile parseLink(JsonObject link) {
        String url;
        String name = link.has("name") && !link.get("name").isJsonNull() ? link.get("name").getAsString() : "asset.jar";
        String string = url = link.has("url") && !link.get("url").isJsonNull() ? link.get("url").getAsString() : null;
        if (url == null || url.isBlank()) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] GitLab link missing URL");
            return null;
        }
        return new ModFile(name, url, -1L);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JsonElement fetchJson(String url) {
        Request.Builder reqBuilder = new Request.Builder().url(url).get().header("Accept", "application/json").header("User-Agent", "downloadbypass/1.0 (Minecraft Mod Downloader)");
        String token = System.getenv("GITLAB_TOKEN");
        if (token != null && !token.isBlank()) {
            reqBuilder.header("PRIVATE-TOKEN", token);
        }
        Request request = reqBuilder.build();
        long backoff = 500L;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            block19: {
                try (Response response = this.client().newCall(request).execute();){
                    if (!response.isSuccessful() || response.body() == null) {
                        int code = response.code();
                        boolean retryable = code == 429 || code == 503;
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] GitLab API error (attempt {}/{}): {} {}", (Object)attempt, (Object)3, (Object)code, (Object)response.message());
                        if (!retryable || attempt == 3) {
                            JsonElement jsonElement = null;
                            return jsonElement;
                        }
                        break block19;
                    }
                    String body = response.body().string();
                    try {
                        JsonElement retryable = JsonParser.parseString((String)body);
                        return retryable;
                    }
                    catch (JsonSyntaxException e) {
                        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Invalid JSON response from GitLab API: {}", (Object)e.getMessage());
                        JsonElement jsonElement = null;
                        if (response != null) {
                            response.close();
                        }
                        return jsonElement;
                    }
                }
                catch (IOException e) {
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] GitLab API IO error (attempt {}/{}): {}", (Object)attempt, (Object)3, (Object)e.getMessage());
                    if (attempt != 3) break block19;
                    return null;
                }
            }
            try {
                Thread.sleep(backoff);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            backoff = Math.min(backoff * 2L, 4000L);
        }
        return null;
    }

    private String buildApiBase(String host) {
        if (host == null || host.isBlank()) {
            return DEFAULT_API_BASE;
        }
        host = host.replaceFirst("^https?://", "");
        host = host.replaceFirst("/$", "");
        return "https://" + host + "/api/v4";
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            return value;
        }
    }
}

