/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.security;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class NotificationClient {
    private static final Gson GSON = new Gson();
    private static final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
    private static final String SUPABASE_ANON = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6Im5sbHVrcXV3Y3N4bHloZXp5aXp4Iiwicm9sZSI6ImFub24iLCJpYXQiOjE3NjE0OTI3NDUsImV4cCI6MjA3NzA2ODc0NX0.UxVJd8ZMCZdVZYBAygrAzTSYY1UhmE9sEjyQEq2p1pU";
    private final OkHttpClient http = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(30L)).readTimeout(Duration.ofSeconds(60L)).writeTimeout(Duration.ofSeconds(60L)).build();
    private final String baseEndpoint;

    public NotificationClient() {
        this.baseEndpoint = "https://nllukquwcsxlyhezyizx.supabase.co/functions/v1";
    }

    private Request.Builder baseHeaders(Request.Builder rb) {
        return rb.header("User-Agent", "downloadbypass/1.0 (notify)").header("Accept", "application/json").header("Authorization", "Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6Im5sbHVrcXV3Y3N4bHloZXp5aXp4Iiwicm9sZSI6ImFub24iLCJpYXQiOjE3NjE0OTI3NDUsImV4cCI6MjA3NzA2ODc0NX0.UxVJd8ZMCZdVZYBAygrAzTSYY1UhmE9sEjyQEq2p1pU").header("apikey", SUPABASE_ANON);
    }

    public String registerDevice(String deviceHash) throws IOException {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("device_hash", deviceHash);
        String json = GSON.toJson(payload);
        Request req = this.baseHeaders(new Request.Builder().url(this.baseEndpoint + "/register-device").post(RequestBody.create(json, JSON))).build();
        try (Response resp = this.http.newCall(req).execute();){
            if (!resp.isSuccessful()) {
                throw new IOException("register-device failed: " + resp.code());
            }
            String body = resp.body() != null ? resp.body().string() : "{}";
            Map m = (Map)GSON.fromJson(body, Map.class);
            Object id = m.get("device_id");
            String string = id != null ? String.valueOf(id) : null;
            return string;
        }
    }

    public List<Alert> reportInventory(String deviceId, List<Item> items) throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("device_id", deviceId);
        payload.put("items", items);
        String json = GSON.toJson(payload);
        Request req = this.baseHeaders(new Request.Builder().url(this.baseEndpoint + "/report-inventory").post(RequestBody.create(json, JSON))).build();
        try (Response resp = this.http.newCall(req).execute();){
            if (!resp.isSuccessful()) {
                throw new IOException("report-inventory failed: " + resp.code());
            }
            String body = resp.body() != null ? resp.body().string() : "{}";
            InventoryResponse r = (InventoryResponse)GSON.fromJson(body, InventoryResponse.class);
            List<Alert> list = r != null && r.alerts != null ? r.alerts : Collections.emptyList();
            return list;
        }
    }

    public List<Alert> fetchAlerts(String deviceId) throws IOException {
        Request req = this.baseHeaders(new Request.Builder().url(this.baseEndpoint + "/fetch-alerts?device_id=" + deviceId).get()).build();
        try (Response resp = this.http.newCall(req).execute();){
            if (!resp.isSuccessful()) {
                throw new IOException("fetch-alerts failed: " + resp.code());
            }
            String body = resp.body() != null ? resp.body().string() : "{}";
            InventoryResponse r = (InventoryResponse)GSON.fromJson(body, InventoryResponse.class);
            List<Alert> list = r != null && r.alerts != null ? r.alerts : Collections.emptyList();
            return list;
        }
    }

    public boolean ackAlert(String deviceId, String alertId, String action) throws IOException {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("device_id", deviceId);
        payload.put("alert_id", alertId);
        if (action != null) {
            payload.put("action", action);
        }
        String json = GSON.toJson(payload);
        Request req = this.baseHeaders(new Request.Builder().url(this.baseEndpoint + "/ack-alert").post(RequestBody.create(json, JSON))).build();
        try (Response resp = this.http.newCall(req).execute();){
            boolean bl = resp.isSuccessful();
            return bl;
        }
    }

    private static class InventoryResponse {
        @SerializedName(value="alerts")
        List<Alert> alerts;

        private InventoryResponse() {
        }
    }

    public static class Alert {
        @SerializedName(value="alert_id")
        public String alertId;
        @SerializedName(value="sha256")
        public String sha256;
        @SerializedName(value="reason")
        public String reason;
        @SerializedName(value="severity")
        public String severity;
        @SerializedName(value="vt_positives")
        public Integer vtPositives;
        @SerializedName(value="vt_total")
        public Integer vtTotal;
        @SerializedName(value="vt_report_url")
        public String vtReportUrl;
    }

    public static class Item {
        @SerializedName(value="sha256")
        public String sha256;
        @SerializedName(value="file_name")
        public String fileName;

        public Item(String s, String f) {
            this.sha256 = s;
            this.fileName = f;
        }
    }
}

