/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.security;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.DownloadSource;
import org.texboobcat.downloadbypass.config.ModDependency;
import org.texboobcat.downloadbypass.downloader.ModFile;

public class SecureDownloadClient {
    private static final Gson GSON = new Gson();
    private static final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
    private static final String SUPABASE_ANON = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6Im5sbHVrcXV3Y3N4bHloZXp5aXp4Iiwicm9sZSI6ImFub24iLCJpYXQiOjE3NjE0OTI3NDUsImV4cCI6MjA3NzA2ODc0NX0.UxVJd8ZMCZdVZYBAygrAzTSYY1UhmE9sEjyQEq2p1pU";
    private final OkHttpClient http = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(30L)).readTimeout(Duration.ofSeconds(60L)).writeTimeout(Duration.ofSeconds(60L)).build();
    private final String baseEndpoint;

    public SecureDownloadClient() {
        this.baseEndpoint = "https://nllukquwcsxlyhezyizx.supabase.co/functions/v1";
    }

    public boolean isEnabled() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result requestSignedUrl(ModDependency dep, ModFile mf, long maxWaitMs, boolean required) {
        if (!this.isEnabled()) {
            return Result.disabled();
        }
        try {
            String sourceType = this.mapSourceType(dep.detectSource());
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put("url", mf.getDownloadUrl());
            payload.put("source_type", sourceType);
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            if (dep.getName() != null) {
                metadata.put("name", dep.getName());
            }
            if (dep.getVersion() != null) {
                metadata.put("version", dep.getVersion());
            }
            if (dep.getSha256Hash() != null && !dep.getSha256Hash().isBlank()) {
                metadata.put("expected_sha256", dep.getSha256Hash());
            }
            if (dep.getSizeBytes() != null && dep.getSizeBytes() > 0L) {
                metadata.put("expected_size", dep.getSizeBytes());
            }
            payload.put("metadata", metadata);
            String json = GSON.toJson(payload);
            Request.Builder rb = new Request.Builder().url(this.baseEndpoint + "/request-download").post(RequestBody.create(json, JSON)).header("User-Agent", "downloadbypass/1.0 (secure-proxy)").header("Accept", "application/json").header("Authorization", "Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6Im5sbHVrcXV3Y3N4bHloZXp5aXp4Iiwicm9sZSI6ImFub24iLCJpYXQiOjE3NjE0OTI3NDUsImV4cCI6MjA3NzA2ODc0NX0.UxVJd8ZMCZdVZYBAygrAzTSYY1UhmE9sEjyQEq2p1pU").header("apikey", SUPABASE_ANON);
            Request request = rb.build();
            try (Response resp = this.http.newCall(request).execute();){
                if (!resp.isSuccessful()) {
                    Downloadbypass.LOGGER.error("[SECURITY] request-download failed: {} {}", (Object)resp.code(), (Object)resp.message());
                    Result result = Result.error("request failed: " + resp.code());
                    return result;
                }
                String body = resp.body() != null ? resp.body().string() : "{}";
                SecureResponse r = (SecureResponse)GSON.fromJson(body, SecureResponse.class);
                if (r == null || r.status == null) {
                    Result result = Result.error("invalid response");
                    return result;
                }
                switch (r.status) {
                    case "ready": {
                        Result result = Result.ready(r.download_url, r.sha256, r.size, r.decision, r.message, r.vt_positives, r.vt_total, r.vt_tolerance, r.vt_report_url);
                        return result;
                    }
                    case "blocked": {
                        Result result = Result.blocked(r.reason != null ? r.reason : "blocked", r.decision, r.message, r.vt_positives, r.vt_total, r.vt_tolerance, r.vt_report_url);
                        return result;
                    }
                    case "pending": {
                        Result result = this.pollStatus(r.job_id, maxWaitMs, required);
                        return result;
                    }
                }
                Result result = Result.error("unknown status: " + r.status);
                return result;
            }
        }
        catch (Exception e) {
            Downloadbypass.LOGGER.error("[SECURITY] requestSignedUrl error: {}", (Object)e.getMessage());
            return Result.error(e.getMessage());
        }
    }

    private Result pollStatus(String jobId, long maxWaitMs, boolean required) throws IOException {
        long start = System.currentTimeMillis();
        long backoff = 1000L;
        while (true) {
            Request.Builder rb = new Request.Builder().url(this.baseEndpoint + "/download-status?job_id=" + URLEncoder.encode(jobId, StandardCharsets.UTF_8)).get().header("User-Agent", "downloadbypass/1.0 (secure-proxy)").header("Accept", "application/json").header("Authorization", "Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6Im5sbHVrcXV3Y3N4bHloZXp5aXp4Iiwicm9sZSI6ImFub24iLCJpYXQiOjE3NjE0OTI3NDUsImV4cCI6MjA3NzA2ODc0NX0.UxVJd8ZMCZdVZYBAygrAzTSYY1UhmE9sEjyQEq2p1pU").header("apikey", SUPABASE_ANON);
            Request request = rb.build();
            try (Response resp = this.http.newCall(request).execute();){
                if (!resp.isSuccessful()) {
                    Downloadbypass.LOGGER.warn("[SECURITY] status failed: {} {}", (Object)resp.code(), (Object)resp.message());
                } else {
                    String body = resp.body() != null ? resp.body().string() : "{}";
                    SecureResponse r = (SecureResponse)GSON.fromJson(body, SecureResponse.class);
                    if (r != null && r.status != null) {
                        if ("ready".equals(r.status)) {
                            Result result = Result.ready(r.download_url, r.sha256, r.size, r.decision, r.message, r.vt_positives, r.vt_total, r.vt_tolerance, r.vt_report_url);
                            return result;
                        }
                        if ("blocked".equals(r.status)) {
                            Result result = Result.blocked(r.reason != null ? r.reason : "blocked", r.decision, r.message, r.vt_positives, r.vt_total, r.vt_tolerance, r.vt_report_url);
                            return result;
                        }
                    }
                }
            }
            if (System.currentTimeMillis() - start > maxWaitMs) {
                return required ? Result.error("scan timeout") : Result.pendingTimeout();
            }
            try {
                Thread.sleep(backoff);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            backoff = Math.min(backoff * 2L, 8000L);
        }
    }

    private String mapSourceType(DownloadSource ds) {
        switch (ds) {
            case CURSEFORGE: {
                return "curseforge";
            }
            case MODRINTH: {
                return "modrinth";
            }
            case GITHUB: {
                return "github";
            }
            case GITLAB: {
                return "gitlab";
            }
            case MAVEN: {
                return "maven";
            }
            case DIRECT_URL: {
                return "direct";
            }
        }
        return "direct";
    }

    public static class Result {
        public final boolean enabled;
        public final boolean ok;
        public final boolean blocked;
        public final boolean timedOut;
        public final String signedUrl;
        public final String error;
        public final String sha256;
        public final Long size;
        public final String decision;
        public final String message;
        public final Integer vtPositives;
        public final Integer vtTotal;
        public final Integer vtTolerance;
        public final String vtReportUrl;

        private Result(boolean enabled, boolean ok, boolean blocked, boolean timedOut, String signedUrl, String error, String sha256, Long size, String decision, String message, Integer vtPositives, Integer vtTotal, Integer vtTolerance, String vtReportUrl) {
            this.enabled = enabled;
            this.ok = ok;
            this.blocked = blocked;
            this.timedOut = timedOut;
            this.signedUrl = signedUrl;
            this.error = error;
            this.sha256 = sha256;
            this.size = size;
            this.decision = decision;
            this.message = message;
            this.vtPositives = vtPositives;
            this.vtTotal = vtTotal;
            this.vtTolerance = vtTolerance;
            this.vtReportUrl = vtReportUrl;
        }

        public static Result disabled() {
            return new Result(false, false, false, false, null, null, null, null, null, null, null, null, null, null);
        }

        public static Result ready(String url, String sha256, Long size, String decision, String message, Integer vtPositives, Integer vtTotal, Integer vtTolerance, String vtReportUrl) {
            return new Result(true, true, false, false, url, null, sha256, size, decision, message, vtPositives, vtTotal, vtTolerance, vtReportUrl);
        }

        public static Result blocked(String reason, String decision, String message, Integer vtPositives, Integer vtTotal, Integer vtTolerance, String vtReportUrl) {
            return new Result(true, false, true, false, null, reason, null, null, decision, message, vtPositives, vtTotal, vtTolerance, vtReportUrl);
        }

        public static Result pendingTimeout() {
            return new Result(true, false, false, true, null, "pending timeout", null, null, null, null, null, null, null, null);
        }

        public static Result error(String err) {
            return new Result(true, false, false, false, null, err, null, null, null, null, null, null, null, null);
        }
    }

    private static class SecureResponse {
        @SerializedName(value="status")
        String status;
        @SerializedName(value="download_url")
        String download_url;
        @SerializedName(value="sha256")
        String sha256;
        @SerializedName(value="size")
        Long size;
        @SerializedName(value="job_id")
        String job_id;
        @SerializedName(value="reason")
        String reason;
        @SerializedName(value="decision")
        String decision;
        @SerializedName(value="message")
        String message;
        @SerializedName(value="vt_positives")
        Integer vt_positives;
        @SerializedName(value="vt_total")
        Integer vt_total;
        @SerializedName(value="vt_tolerance")
        Integer vt_tolerance;
        @SerializedName(value="vt_report_url")
        String vt_report_url;

        private SecureResponse() {
        }
    }
}

