/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.ui;

import java.awt.Desktop;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.downloadbypass.Downloadbypass;

public class SecurityAlertsScreen
extends Screen {
    private final List<AlertEntry> entries;
    private final BiConsumer<String, String> ackCallback;
    private final Runnable onCloseAll;

    public SecurityAlertsScreen(List<AlertEntry> entries, BiConsumer<String, String> ackCallback, Runnable onCloseAll) {
        super((Component)Component.m_237113_((String)"Security Alerts"));
        this.entries = new ArrayList<AlertEntry>((Collection)Objects.requireNonNull(entries));
        this.ackCallback = Objects.requireNonNull(ackCallback);
        this.onCloseAll = Objects.requireNonNull(onCloseAll);
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int y = 40;
        int idx = 0;
        for (AlertEntry e : this.entries) {
            int rowY = y + idx * 70;
            if (e.vtReportUrl != null && !e.vtReportUrl.isBlank()) {
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Open VT Report"), b -> {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            Desktop.getDesktop().browse(new URI(e.vtReportUrl));
                        }
                    }
                    catch (Exception ex) {
                        Downloadbypass.LOGGER.warn("[SECURITY] Failed to open VT URL: {}", (Object)ex.toString());
                    }
                }).m_252794_(centerX - 230, rowY + 20).m_253046_(120, 20).m_253136_());
            }
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Quarantine"), b -> {
                try {
                    if (e.filePath != null && Files.exists(e.filePath, new LinkOption[0])) {
                        Path qdir = e.filePath.getParent().resolve(".quarantine");
                        Files.createDirectories(qdir, new FileAttribute[0]);
                        Path dest = qdir.resolve(e.filePath.getFileName().toString());
                        int suffix = 1;
                        while (Files.exists(dest, new LinkOption[0])) {
                            dest = qdir.resolve(e.filePath.getFileName().toString() + "." + suffix);
                            ++suffix;
                        }
                        Files.move(e.filePath, dest, new CopyOption[0]);
                    }
                }
                catch (Exception ex) {
                    Downloadbypass.LOGGER.warn("[SECURITY] Quarantine failed for {}: {}", (Object)e.filePath, (Object)ex.getMessage());
                }
                try {
                    this.ackCallback.accept(e.alertId, "quarantined");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).m_252794_(centerX - 100, rowY + 20).m_253046_(100, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Delete"), b -> {
                try {
                    if (e.filePath != null && Files.exists(e.filePath, new LinkOption[0])) {
                        Files.delete(e.filePath);
                    }
                }
                catch (Exception ex) {
                    Downloadbypass.LOGGER.warn("[SECURITY] Delete failed for {}: {}", (Object)e.filePath, (Object)ex.getMessage());
                }
                try {
                    this.ackCallback.accept(e.alertId, "deleted");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).m_252794_(centerX + 10, rowY + 20).m_253046_(80, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Ignore"), b -> {
                try {
                    this.ackCallback.accept(e.alertId, "ignored");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).m_252794_(centerX + 100, rowY + 20).m_253046_(80, 20).m_253136_());
            ++idx;
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.onCloseAll.run()).m_252794_(centerX - 40, this.f_96544_ - 40).m_253046_(80, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        int centerX = this.f_96543_ / 2;
        g.m_280653_(this.f_96547_, this.m_96636_(), centerX, 10, 0xFFFFFF);
        int y = 40;
        int idx = 0;
        for (AlertEntry e : this.entries) {
            int rowY = y + idx * 70;
            String head = (String)(e.severity != null ? "[" + e.severity.toUpperCase() + "] " : "") + SecurityAlertsScreen.shortSha(e.sha256);
            g.m_280137_(this.f_96547_, head, centerX, rowY, 0xFF5555);
            g.m_280137_(this.f_96547_, e.reason != null ? e.reason : "Malicious file detected.", centerX, rowY + 10, 0xAAAAAA);
            ++idx;
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private static String shortSha(String sha) {
        if (sha == null) {
            return "unknown";
        }
        return sha.length() > 12 ? sha.substring(0, 12) + "\u2026" : sha;
    }

    public static class AlertEntry {
        public final String alertId;
        public final String sha256;
        public final String reason;
        public final String severity;
        public final String vtReportUrl;
        public final Path filePath;

        public AlertEntry(String alertId, String sha256, String reason, String severity, String vtReportUrl, Path filePath) {
            this.alertId = alertId;
            this.sha256 = sha256;
            this.reason = reason;
            this.severity = severity;
            this.vtReportUrl = vtReportUrl;
            this.filePath = filePath;
        }
    }
}

