/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.ui;

import java.awt.Desktop;
import java.net.URI;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.ModDependency;

public class StartupPrompt
extends Screen {
    private final ModDependency mod;
    private final boolean required;
    private final Consumer<Boolean> resultCallback;
    private Button yesButton;
    private Button noButton;
    private Button openButton;
    private double progress = 0.0;
    private boolean downloading = false;
    private String statusLine = null;

    public StartupPrompt(ModDependency mod, Consumer<Boolean> resultCallback) {
        super((Component)Component.m_237113_((String)"Missing External Mod"));
        this.mod = mod;
        this.required = mod != null && mod.isRequired();
        this.resultCallback = resultCallback;
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.yesButton = Button.m_253074_((Component)Component.m_237113_((String)"Yes, Download"), btn -> this.onYes()).m_252794_(centerX - 155, centerY + 40).m_253046_(150, 20).m_253136_();
        this.noButton = Button.m_253074_((Component)Component.m_237113_((String)(this.required ? "No, Exit Game" : "No, Skip")), btn -> this.onNo()).m_252794_(centerX + 5, centerY + 40).m_253046_(150, 20).m_253136_();
        this.openButton = Button.m_253074_((Component)Component.m_237113_((String)"Open Page"), btn -> this.onOpenPage()).m_252794_(centerX - 75, centerY + 65).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.yesButton);
        this.m_142416_((GuiEventListener)this.noButton);
        this.m_142416_((GuiEventListener)this.openButton);
    }

    private void onYes() {
        if (this.downloading) {
            return;
        }
        this.downloading = true;
        this.yesButton.f_93623_ = false;
        this.noButton.f_93623_ = false;
        if (this.resultCallback != null) {
            this.resultCallback.accept(Boolean.TRUE);
        }
    }

    private void onNo() {
        if (this.resultCallback != null) {
            this.resultCallback.accept(Boolean.FALSE);
        }
        if (this.required) {
            Minecraft.m_91087_().m_91395_();
        } else {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    private void onOpenPage() {
        String url = this.buildCurseUrl();
        if (url == null) {
            return;
        }
        try {
            Minecraft.m_91087_().f_91068_.m_90911_(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (Exception e) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to open browser: {}", (Object)e.getMessage());
        }
    }

    private String buildCurseUrl() {
        if (this.mod == null) {
            return null;
        }
        String slug = this.mod.getSlug();
        Integer fileId = this.mod.getFileId();
        if (slug != null && fileId != null) {
            return "https://www.curseforge.com/minecraft/mc-mods/" + slug + "/files/" + fileId;
        }
        if (slug != null) {
            return "https://www.curseforge.com/minecraft/mc-mods/" + slug;
        }
        return null;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setDownloading(boolean downloading) {
        this.downloading = downloading;
    }

    public void setStatus(String status) {
        this.statusLine = status;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int y = this.f_96544_ / 2 - 40;
        String title = this.required ? "Missing Required Mod" : "Missing Optional Mod";
        graphics.m_280137_(this.f_96547_, title, centerX, y, 0xFFFFFF);
        y += 15;
        if (this.mod != null) {
            graphics.m_280137_(this.f_96547_, this.mod.getName() + (String)(this.mod.getVersion() != null ? " v" + this.mod.getVersion() : ""), centerX, y, 0xAAAAAA);
            String reason = this.mod.getReason() != null ? this.mod.getReason() : "Unavailable on Modrinth.";
            graphics.m_280137_(this.f_96547_, "Reason: " + reason, centerX, y += 12, 0xAAAAAA);
            y += 12;
            if (this.mod.getSizeBytes() != null && this.mod.getSizeBytes() > 0L) {
                double mb = (double)this.mod.getSizeBytes().longValue() / 1048576.0;
                graphics.m_280137_(this.f_96547_, String.format("Size: %.1f MB", mb), centerX, y, 0xAAAAAA);
                y += 12;
            }
            if (this.statusLine != null && !this.statusLine.isBlank()) {
                graphics.m_280137_(this.f_96547_, this.statusLine, centerX, y, 0x55FF55);
                y += 12;
            }
        }
        graphics.m_280137_(this.f_96547_, "Would you like to auto-install this mod?", centerX, y += 8, 0xFFFFFF);
        y += 18;
        if (this.downloading) {
            int barWidth = 200;
            int barX = centerX - barWidth / 2;
            int barY = y + 10;
            int filled = (int)((double)barWidth * Math.max(0.0, Math.min(1.0, this.progress)));
            graphics.m_280509_(barX, barY, barX + barWidth, barY + 8, -11184811);
            graphics.m_280509_(barX, barY, barX + filled, barY + 8, -14505438);
            String pct = String.format("Downloading... %d%%", (int)Math.round(this.progress * 100.0));
            graphics.m_280137_(this.f_96547_, pct, centerX, barY - 10, 0xFFFFFF);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }
}

