/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.texboobcat.downloadbypass.Downloadbypass;

public final class HashUtil {
    private HashUtil() {
    }

    public static String md5(Path file) throws IOException {
        return HashUtil.digest(file, "MD5");
    }

    public static String sha256(Path file) throws IOException {
        return HashUtil.digest(file, "SHA-256");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String digest(Path file, String algo) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            String string;
            try (DigestInputStream dis = new DigestInputStream(in, MessageDigest.getInstance(algo));){
                byte[] buffer = new byte[8192];
                while (dis.read(buffer) != -1) {
                }
                byte[] digest = dis.getMessageDigest().digest();
                string = HashUtil.toHex(digest);
            }
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Hash algorithm not available: {}", (Object)algo);
            throw new IOException("Hash algorithm not available: " + algo, e);
        }
    }

    public static boolean matchesMd5(Path file, String expected) {
        if (expected == null || expected.isBlank()) {
            return true;
        }
        try {
            String md5 = HashUtil.md5(file);
            return md5.equalsIgnoreCase(expected.trim());
        }
        catch (IOException e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Failed to compute MD5: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean matchesSha256(Path file, String expected) {
        if (expected == null || expected.isBlank()) {
            return true;
        }
        try {
            String sha = HashUtil.sha256(file);
            return sha.equalsIgnoreCase(expected.trim());
        }
        catch (IOException e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Failed to compute SHA-256: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(Character.forDigit(b >> 4 & 0xF, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
        }
        return sb.toString();
    }
}

