/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.ConfigRoot;
import org.texboobcat.downloadbypass.config.ModDependency;

public final class ModDependencyConfig {
    private static final String CONFIG_RELATIVE = "config/external-mods.json";
    private static final String SUPPORTED_SCHEMA = "1.0";
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    private ModDependencyConfig() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ModDependency> loadDependencies() {
        Path configPath = Paths.get(CONFIG_RELATIVE, new String[0]);
        if (!Files.exists(configPath, new LinkOption[0])) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Config not found at {}. Continuing without external mods.", (Object)configPath.toAbsolutePath());
            return Collections.emptyList();
        }
        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Loading configuration from {}", (Object)configPath.toAbsolutePath());
        try (BufferedReader reader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);){
            ConfigRoot root = (ConfigRoot)GSON.fromJson((Reader)reader, ConfigRoot.class);
            if (root == null) {
                Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Config is empty or invalid JSON. Skipping external mods.");
                List<ModDependency> list = Collections.emptyList();
                return list;
            }
            String schema = root.getSchemaVersion();
            if (!SUPPORTED_SCHEMA.equals(schema)) {
                Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Unsupported schema_version: '{}'. Expected '{}'. Skipping external mods.", (Object)schema, (Object)SUPPORTED_SCHEMA);
                List<ModDependency> list = Collections.emptyList();
                return list;
            }
            List<ModDependency> mods = root.getMods();
            if (mods == null || mods.isEmpty()) {
                Downloadbypass.LOGGER.info("[EXTERNAL-MODS] No external dependencies declared.");
                List<ModDependency> list = Collections.emptyList();
                return list;
            }
            long missingNames = mods.stream().filter(m -> m == null || ModDependencyConfig.isBlank(m.getName())).count();
            if (missingNames > 0L) {
                Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] {} entries missing 'name'. These entries will still be processed but UI may be degraded.", (Object)missingNames);
            }
            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Found {} external dependencies", (Object)mods.size());
            List<ModDependency> list = mods;
            return list;
        }
        catch (JsonParseException e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Failed to parse JSON config: {}", (Object)e.getMessage());
            return Collections.emptyList();
        }
        catch (IOException e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] IO error reading config: {}", (Object)e.getMessage());
            return Collections.emptyList();
        }
        catch (Exception e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Unexpected error loading config", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }
}

