/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.downloader;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.ModDependency;
import org.texboobcat.downloadbypass.downloader.ModFile;

public class CurseForgeAPI {
    private static final String API_BASE = "https://api.curseforge.com/v1";
    private static final String[] CURSE_MAVEN_BASES = new String[]{"https://www.cursemaven.com", "https://cursemaven.com", "https://www.cursemaven.com/api/maven"};
    private OkHttpClient client;
    private static final int MAX_RETRIES = 3;
    private static final long INITIAL_BACKOFF_MS = 500L;

    private OkHttpClient client() {
        if (this.client == null) {
            this.client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        }
        return this.client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModFile getModFile(int projectId, int fileId) {
        String url = "https://api.curseforge.com/v1/mods/" + projectId + "/files/" + fileId;
        Request.Builder reqBuilder = new Request.Builder().url(url).get().header("Accept", "application/json").header("User-Agent", "downloadbypass/1.0 (Minecraft 1.20.1)");
        String apiKey = System.getenv("CURSEFORGE_API_KEY");
        if (apiKey != null && !apiKey.isBlank()) {
            reqBuilder.header("x-api-key", apiKey);
        }
        Request request = reqBuilder.build();
        long backoff = 500L;
        int attempt = 1;
        while (attempt <= 3) {
            block22: {
                try (Response response = this.client().newCall(request).execute();){
                    long length;
                    JsonObject root;
                    if (!response.isSuccessful() || response.body() == null) {
                        int code = response.code();
                        boolean retryable = code == 429 || code == 503;
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] CurseForge API error (attempt {}/{}): {} {}", (Object)attempt, (Object)3, (Object)code, (Object)response.message());
                        if (!retryable || attempt == 3) {
                            ModFile modFile = null;
                            return modFile;
                        }
                        break block22;
                    }
                    String body = response.body().string();
                    try {
                        root = JsonParser.parseString((String)body).getAsJsonObject();
                    }
                    catch (JsonSyntaxException e) {
                        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Invalid JSON response from CurseForge API: {}", (Object)e.getMessage());
                        ModFile modFile = null;
                        if (response == null) return modFile;
                        response.close();
                        return modFile;
                    }
                    JsonObject data = root.getAsJsonObject("data");
                    if (data == null) {
                        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] CurseForge API response missing data");
                        ModFile modFile = null;
                        return modFile;
                    }
                    String fileName = data.has("fileName") && !data.get("fileName").isJsonNull() ? data.get("fileName").getAsString() : "mod-" + fileId + ".jar";
                    String downloadUrl = data.has("downloadUrl") && !data.get("downloadUrl").isJsonNull() ? data.get("downloadUrl").getAsString() : null;
                    long l = length = data.has("fileLength") && !data.get("fileLength").isJsonNull() ? data.get("fileLength").getAsLong() : -1L;
                    if (downloadUrl == null || downloadUrl.isBlank()) {
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] CurseForge API did not provide downloadUrl for file {}. Manual download may be required.", (Object)fileId);
                        ModFile modFile = null;
                        return modFile;
                    }
                    ModFile modFile = new ModFile(fileName, downloadUrl, length);
                    return modFile;
                }
                catch (IOException e) {
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] API IO error (attempt {}/{}): {}", (Object)attempt, (Object)3, (Object)e.getMessage());
                    if (attempt != 3) break block22;
                    return null;
                }
            }
            try {
                Thread.sleep(backoff);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            backoff = Math.min(backoff * 2L, 4000L);
            ++attempt;
        }
        return null;
    }

    public ModFile resolveModFile(ModDependency dep) {
        boolean hasKey;
        if (dep == null) {
            return null;
        }
        Integer projectId = dep.getCurseforgeId();
        Integer fileId = dep.getFileId();
        String slug = dep.getSlug();
        if (projectId == null || fileId == null) {
            return null;
        }
        String apiKey = System.getenv("CURSEFORGE_API_KEY");
        boolean bl = hasKey = apiKey != null && !apiKey.isBlank();
        if (!hasKey) {
            ModFile maven = this.tryCurseMaven(slug, projectId, fileId);
            if (maven != null) {
                return maven;
            }
            ModFile api = this.getModFile(projectId, fileId);
            if (api != null) {
                return api;
            }
        } else {
            ModFile api = this.getModFile(projectId, fileId);
            if (api != null) {
                return api;
            }
            ModFile maven = this.tryCurseMaven(slug, projectId, fileId);
            if (maven != null) {
                return maven;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModFile tryCurseMaven(String slug, int projectId, int fileId) {
        if (slug == null) return null;
        if (slug.isBlank()) {
            return null;
        }
        String artifactId = slug + "-" + projectId;
        String fileName = artifactId + "-" + fileId + ".jar";
        String path = "/" + this.groupToPath("curse.maven") + "/" + artifactId + "/" + fileId + "/" + fileName;
        String[] stringArray = CURSE_MAVEN_BASES;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Curse Maven not available for project {} file {}. The mod may have disabled 3rd party sharing.", (Object)projectId, (Object)fileId);
                return null;
            }
            String base = stringArray[n2];
            String url = base + path;
            try (Response resp = this.client().newCall(new Request.Builder().url(url).head().header("User-Agent", "downloadbypass/1.0 (Minecraft 1.20.1)").build()).execute();){
                if (resp.isSuccessful()) {
                    long len = -1L;
                    String cl = resp.header("Content-Length");
                    if (cl != null) {
                        try {
                            len = Long.parseLong(cl);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Using Curse Maven artifact: {} from {}", (Object)fileName, (Object)base);
                    ModFile modFile = new ModFile(fileName, url, len);
                    return modFile;
                }
                Downloadbypass.LOGGER.debug("[EXTERNAL-MODS] Curse Maven probe failed at {} (HTTP {})", (Object)base, (Object)resp.code());
            }
            catch (IOException e) {
                Downloadbypass.LOGGER.debug("[EXTERNAL-MODS] Failed to reach Curse Maven base {}: {}", (Object)base, (Object)e.getMessage());
            }
            ++n2;
        }
    }

    private String groupToPath(String groupId) {
        return groupId.replace('.', '/');
    }
}

