/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.downloader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.ModDependency;
import org.texboobcat.downloadbypass.downloader.ModFile;

public class ModrinthAPI {
    private static final String API_BASE = "https://api.modrinth.com/v2";
    private OkHttpClient client;
    private static final int MAX_RETRIES = 3;
    private static final long INITIAL_BACKOFF_MS = 500L;

    private OkHttpClient client() {
        if (this.client == null) {
            this.client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).followRedirects(true).build();
        }
        return this.client;
    }

    public JsonObject getProject(String projectIdOrSlug) {
        if (projectIdOrSlug == null || projectIdOrSlug.isBlank()) {
            return null;
        }
        String url = "https://api.modrinth.com/v2/project/" + projectIdOrSlug;
        JsonElement result = this.fetchJson(url);
        return result != null && result.isJsonObject() ? result.getAsJsonObject() : null;
    }

    public ModFile getVersion(String versionId) {
        if (versionId == null || versionId.isBlank()) {
            return null;
        }
        String url = "https://api.modrinth.com/v2/version/" + versionId;
        JsonElement result = this.fetchJson(url);
        if (result == null || !result.isJsonObject()) {
            return null;
        }
        JsonObject version = result.getAsJsonObject();
        if (version == null || !version.has("files")) {
            return null;
        }
        JsonArray files = version.getAsJsonArray("files");
        if (files.size() == 0) {
            return null;
        }
        JsonObject primaryFile = null;
        for (JsonElement elem : files) {
            JsonObject file = elem.getAsJsonObject();
            if (!file.has("primary") || !file.get("primary").getAsBoolean()) continue;
            primaryFile = file;
            break;
        }
        if (primaryFile == null) {
            primaryFile = files.get(0).getAsJsonObject();
        }
        return this.parseFileObject(primaryFile);
    }

    public List<JsonObject> getProjectVersions(String projectIdOrSlug, String gameVersion, String loader) {
        JsonElement result;
        if (projectIdOrSlug == null || projectIdOrSlug.isBlank()) {
            return new ArrayList<JsonObject>();
        }
        StringBuilder urlBuilder = new StringBuilder("https://api.modrinth.com/v2/project/" + projectIdOrSlug + "/version");
        ArrayList<CallSite> params = new ArrayList<CallSite>();
        if (gameVersion != null && !gameVersion.isBlank()) {
            params.add((CallSite)((Object)("game_versions=[\"" + gameVersion + "\"]")));
        }
        if (loader != null && !loader.isBlank()) {
            params.add((CallSite)((Object)("loaders=[\"" + loader.toLowerCase() + "\"]")));
        }
        if (!params.isEmpty()) {
            urlBuilder.append("?");
            urlBuilder.append(String.join((CharSequence)"&", params));
        }
        if ((result = this.fetchJson(urlBuilder.toString())) == null || !result.isJsonArray()) {
            return new ArrayList<JsonObject>();
        }
        ArrayList<JsonObject> versions = new ArrayList<JsonObject>();
        for (JsonElement elem : result.getAsJsonArray()) {
            if (!elem.isJsonObject()) continue;
            versions.add(elem.getAsJsonObject());
        }
        return versions;
    }

    public ModFile getLatestVersion(String projectIdOrSlug, String gameVersion, String loader) {
        List<JsonObject> versions = this.getProjectVersions(projectIdOrSlug, gameVersion, loader);
        if (versions.isEmpty()) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] No Modrinth versions found for project: {}", (Object)projectIdOrSlug);
            return null;
        }
        JsonObject latestVersion = versions.get(0);
        if (!latestVersion.has("files")) {
            return null;
        }
        JsonArray files = latestVersion.getAsJsonArray("files");
        if (files.size() == 0) {
            return null;
        }
        JsonObject primaryFile = null;
        for (JsonElement elem : files) {
            JsonObject file = elem.getAsJsonObject();
            if (!file.has("primary") || !file.get("primary").getAsBoolean()) continue;
            primaryFile = file;
            break;
        }
        if (primaryFile == null) {
            primaryFile = files.get(0).getAsJsonObject();
        }
        return this.parseFileObject(primaryFile);
    }

    public ModFile resolveModFile(ModDependency dep) {
        if (dep == null) {
            return null;
        }
        String projectId = dep.getModrinthProjectId();
        if (projectId == null || projectId.isBlank()) {
            return null;
        }
        String versionId = dep.getModrinthVersionId();
        if (versionId != null && !versionId.isBlank()) {
            return this.getVersion(versionId);
        }
        String gameVersion = dep.getVersion();
        String loader = dep.getModrinthLoader();
        return this.getLatestVersion(projectId, gameVersion, loader);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JsonElement fetchJson(String url) {
        Request.Builder reqBuilder = new Request.Builder().url(url).get().header("Accept", "application/json").header("User-Agent", "downloadbypass/1.0 (Minecraft Mod Downloader) (contact@example.com)");
        Request request = reqBuilder.build();
        long backoff = 500L;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            block18: {
                try (Response response = this.client().newCall(request).execute();){
                    if (!response.isSuccessful() || response.body() == null) {
                        int code = response.code();
                        boolean retryable = code == 429 || code == 503;
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Modrinth API error (attempt {}/{}): {} {}", (Object)attempt, (Object)3, (Object)code, (Object)response.message());
                        if (!retryable || attempt == 3) {
                            JsonElement jsonElement = null;
                            return jsonElement;
                        }
                        break block18;
                    }
                    String body = response.body().string();
                    try {
                        JsonElement retryable = JsonParser.parseString((String)body);
                        return retryable;
                    }
                    catch (JsonSyntaxException e) {
                        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Invalid JSON response from Modrinth API: {}", (Object)e.getMessage());
                        JsonElement jsonElement = null;
                        if (response != null) {
                            response.close();
                        }
                        return jsonElement;
                    }
                }
                catch (IOException e) {
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Modrinth API IO error (attempt {}/{}): {}", (Object)attempt, (Object)3, (Object)e.getMessage());
                    if (attempt != 3) break block18;
                    return null;
                }
            }
            try {
                Thread.sleep(backoff);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            backoff = Math.min(backoff * 2L, 4000L);
        }
        return null;
    }

    private ModFile parseFileObject(JsonObject file) {
        long size;
        if (file == null) {
            return null;
        }
        String fileName = file.has("filename") && !file.get("filename").isJsonNull() ? file.get("filename").getAsString() : "mod.jar";
        String downloadUrl = file.has("url") && !file.get("url").isJsonNull() ? file.get("url").getAsString() : null;
        long l = size = file.has("size") && !file.get("size").isJsonNull() ? file.get("size").getAsLong() : -1L;
        if (downloadUrl == null || downloadUrl.isBlank()) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Modrinth file missing download URL");
            return null;
        }
        return new ModFile(fileName, downloadUrl, size);
    }
}

