/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass;

import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.ModDependency;
import org.texboobcat.downloadbypass.config.ModDependencyConfig;
import org.texboobcat.downloadbypass.downloader.CurseForgeAPI;
import org.texboobcat.downloadbypass.downloader.ModDownloader;
import org.texboobcat.downloadbypass.downloader.ModFile;
import org.texboobcat.downloadbypass.ui.StartupPrompt;
import org.texboobcat.downloadbypass.util.HashUtil;
import org.texboobcat.downloadbypass.util.InstalledManifest;

public final class ModInstallerCore {
    private ModInstallerCore() {
    }

    public static void checkAndPromptForMods() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        List<ModDependency> deps = ModDependencyConfig.loadDependencies();
        if (deps.isEmpty()) {
            return;
        }
        Path modsDir = mc.f_91069_.toPath().resolve("mods");
        ArrayList<ModDependency> missing = new ArrayList<ModDependency>();
        CurseForgeAPI api = new CurseForgeAPI();
        String mcVersion = SharedConstants.m_183709_().m_132493_();
        for (ModDependency dep : deps) {
            if (dep == null) continue;
            boolean installed = false;
            try {
                ModFile mf;
                Stream<Path> stream;
                if (!Files.exists(modsDir, new LinkOption[0])) {
                    Files.createDirectories(modsDir, new FileAttribute[0]);
                }
                if (dep.getVersion() != null && !dep.getVersion().isBlank() && !dep.getVersion().contains(mcVersion)) {
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Version mismatch for {}: config '{}', current MC '{}'.", (Object)dep.getName(), (Object)dep.getVersion(), (Object)mcVersion);
                }
                if (dep.getSha256Hash() != null && !dep.getSha256Hash().isBlank()) {
                    stream = Files.list(modsDir);
                    try {
                        installed = stream.filter(p -> p.getFileName().toString().endsWith(".jar")).anyMatch(p -> HashUtil.matchesSha256(p, dep.getSha256Hash()));
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                if (dep.getMd5Hash() != null && !dep.getMd5Hash().isBlank()) {
                    stream = Files.list(modsDir);
                    try {
                        installed = stream.filter(p -> p.getFileName().toString().endsWith(".jar")).anyMatch(p -> HashUtil.matchesMd5(p, dep.getMd5Hash()));
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                if (!installed && dep.getFileId() != null && dep.getCurseforgeId() != null && (mf = api.resolveModFile(dep)) != null) {
                    Path candidate = modsDir.resolve(mf.getFileName());
                    installed = Files.exists(candidate, new LinkOption[0]);
                }
            }
            catch (Exception e) {
                Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Error while checking installed mod {}: {}", (Object)dep.getName(), (Object)e.getMessage());
            }
            if (installed) continue;
            missing.add(dep);
        }
        if (missing.isEmpty()) {
            return;
        }
        ModInstallerCore.processNext(mc, modsDir, missing, 0, false);
    }

    private static void processNext(Minecraft mc, Path modsDir, List<ModDependency> list, int index, boolean installedAny) {
        if (index >= list.size()) {
            if (installedAny) {
                mc.execute(() -> mc.m_91152_((Screen)new SimpleMessageScreen("External Mods Installed", "New mods were installed. Please restart the game.", () -> mc.m_91152_((Screen)null), "Remove Auto-Installed", () -> {
                    try {
                        int removed = InstalledManifest.removeAllInstalledMods(modsDir);
                        mc.m_91152_((Screen)new SimpleMessageScreen("Removal Complete", removed + " files removed. Restart recommended.", () -> mc.m_91152_((Screen)null)));
                    }
                    catch (Exception e) {
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to remove installed mods: {}", (Object)e.getMessage());
                    }
                })));
            }
            return;
        }
        ModDependency dep = list.get(index);
        AtomicReference<StartupPrompt> promptRef = new AtomicReference<StartupPrompt>();
        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Preparing prompt for {}", (Object)dep.getName());
        StartupPrompt prompt = new StartupPrompt(dep, accepted -> {
            if (Boolean.TRUE.equals(accepted)) {
                StartupPrompt p = (StartupPrompt)((Object)((Object)promptRef.get()));
                if (p != null) {
                    p.setDownloading(true);
                }
                CurseForgeAPI api = new CurseForgeAPI();
                ModDownloader dl = new ModDownloader();
                new Thread(() -> {
                    block21: {
                        boolean ok = false;
                        try {
                            Long expectedSize;
                            ModFile mf = null;
                            if (dep.getCurseforgeId() != null && dep.getFileId() != null) {
                                mf = api.resolveModFile(dep);
                            }
                            if (mf == null) {
                                Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Unable to resolve download URL for {}", (Object)dep.getName());
                                break block21;
                            }
                            Path target = modsDir.resolve(mf.getFileName());
                            try {
                                if (!Files.isWritable(modsDir)) {
                                    throw new AccessDeniedException(modsDir.toString());
                                }
                            }
                            catch (Exception e) {
                                boolean required = dep.isRequired();
                                String msg = "Cannot write to mods directory: " + String.valueOf(modsDir) + ". Check permissions.";
                                Downloadbypass.LOGGER.error("[EXTERNAL-MODS] {}", (Object)msg);
                                Minecraft mci = mc;
                                mc.execute(() -> mc.m_91152_((Screen)new SimpleMessageScreen("Permission Error", msg, () -> {
                                    mc.m_91152_(null);
                                    if (required) {
                                        mci.m_91395_();
                                    } else {
                                        ModInstallerCore.processNext(mci, modsDir, list, index + 1, installedAny);
                                    }
                                })));
                                boolean finalOk = ok;
                                mc.execute(() -> {
                                    mc.m_91152_(null);
                                    if (finalOk) {
                                        ModInstallerCore.processNext(mc, modsDir, list, index + 1, true);
                                    } else if (dep.isRequired()) {
                                        mc.m_91395_();
                                    } else {
                                        ModInstallerCore.processNext(mc, modsDir, list, index + 1, installedAny);
                                    }
                                });
                                return;
                            }
                            Long l = dep.getSizeBytes() != null ? dep.getSizeBytes() : (expectedSize = mf.getFileLength() > 0L ? Long.valueOf(mf.getFileLength()) : null);
                            if (expectedSize != null) {
                                try {
                                    long free = Files.getFileStore(modsDir).getUsableSpace();
                                    long needed = expectedSize + 0xA00000L;
                                    if (free < needed) {
                                        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Insufficient disk space. Needed ~{} bytes, free {} bytes", (Object)needed, (Object)free);
                                        boolean required = dep.isRequired();
                                        Minecraft mci = mc;
                                        mc.execute(() -> mc.m_91152_((Screen)new SimpleMessageScreen("Insufficient Disk Space", "Not enough space to install '" + dep.getName() + "'. Free up disk space and retry.", () -> {
                                            mc.m_91152_(null);
                                            if (required) {
                                                mc.m_91395_();
                                            } else {
                                                ModInstallerCore.processNext(mci, modsDir, list, index + 1, installedAny);
                                            }
                                        })));
                                        return;
                                    }
                                }
                                catch (Exception e) {
                                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to check disk space: {}", (Object)e.getMessage());
                                }
                            }
                            if (ok = dl.downloadTo(mf.getDownloadUrl(), target, frac -> {
                                StartupPrompt p3 = (StartupPrompt)((Object)((Object)((Object)((Object)promptRef.get()))));
                                if (p3 != null) {
                                    p3.setProgress((double)frac);
                                }
                            })) {
                                ok = dl.verify(target, dep.getSizeBytes(), dep.getMd5Hash(), dep.getSha256Hash());
                                if (!ok) {
                                    try {
                                        Files.deleteIfExists(target);
                                    }
                                    catch (Exception e) {}
                                } else {
                                    try {
                                        InstalledManifest.recordInstall(dep.getName(), mf.getFileName(), Files.size(target), dep.getMd5Hash(), dep.getSha256Hash(), mf.getDownloadUrl(), System.currentTimeMillis());
                                    }
                                    catch (Exception e) {
                                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to update install manifest: {}", (Object)e.getMessage());
                                    }
                                }
                            }
                        }
                        finally {
                            boolean finalOk = ok;
                            mc.execute(() -> {
                                mc.m_91152_(null);
                                if (finalOk) {
                                    ModInstallerCore.processNext(mc, modsDir, list, index + 1, true);
                                } else if (dep.isRequired()) {
                                    mc.m_91395_();
                                } else {
                                    ModInstallerCore.processNext(mc, modsDir, list, index + 1, installedAny);
                                }
                            });
                        }
                    }
                }, "external-mod-downloader").start();
            } else if (dep.isRequired()) {
                mc.m_91395_();
            } else {
                mc.execute(() -> mc.m_91152_(null));
                ModInstallerCore.processNext(mc, modsDir, list, index + 1, installedAny);
            }
        });
        promptRef.set(prompt);
        mc.execute(() -> {
            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Showing prompt for {}", (Object)dep.getName());
            mc.m_91152_((Screen)prompt);
        });
    }

    private static class SimpleMessageScreen
    extends Screen {
        private final String line1;
        private final Runnable onClose;
        private final String secondaryLabel;
        private final Runnable onSecondary;

        protected SimpleMessageScreen(String title, String line1, Runnable onClose) {
            this(title, line1, onClose, null, null);
        }

        protected SimpleMessageScreen(String title, String line1, Runnable onClose, String secondaryLabel, Runnable onSecondary) {
            super((Component)Component.m_237113_((String)title));
            this.line1 = line1;
            this.onClose = onClose;
            this.secondaryLabel = secondaryLabel;
            this.onSecondary = onSecondary;
        }

        protected void m_7856_() {
            int centerX = this.f_96543_ / 2;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"OK"), b -> this.onClose.run()).m_252794_(centerX - 50, this.f_96544_ / 2 + 30).m_253046_(100, 20).m_253136_());
            if (this.secondaryLabel != null && this.onSecondary != null) {
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)this.secondaryLabel), b -> this.onSecondary.run()).m_252794_(centerX - 75, this.f_96544_ / 2 + 55).m_253046_(150, 20).m_253136_());
            }
        }

        public void m_88315_(GuiGraphics g, int mx, int my, float pt) {
            this.m_280273_(g);
            int centerX = this.f_96543_ / 2;
            int y = this.f_96544_ / 2 - 20;
            g.m_280653_(this.f_96547_, this.m_96636_(), centerX, y - 20, 0xFFFFFF);
            g.m_280137_(this.f_96547_, this.line1, centerX, y, 0xAAAAAA);
            super.m_88315_(g, mx, my, pt);
        }
    }
}

