/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.downloader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.util.HashUtil;

public class ModDownloader {
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
    private static final int MAX_RETRIES = 3;
    private static final long INITIAL_BACKOFF_MS = 1000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean downloadTo(String url, Path destination, Consumer<Double> progressCallback) {
        long backoff = 1000L;
        Path temp = destination.resolveSibling(String.valueOf(destination.getFileName()) + ".part");
        int attempt = 1;
        while (true) {
            if (attempt > 3) {
                Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Exhausted retries for {}", (Object)destination.getFileName());
                return false;
            }
            Request request = new Request.Builder().url(url).get().header("User-Agent", "downloadbypass/1.0 (Minecraft 1.20.1)").build();
            Call call = this.client.newCall(request);
            try (Response response = call.execute();){
                if (response.isSuccessful() && response.body() != null) {
                    long total = response.body().contentLength();
                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                    try (InputStream in = response.body().byteStream();
                         BufferedSink sink2 = Okio.buffer(Okio.sink(temp, new OpenOption[0]));){
                        int read;
                        byte[] buf = new byte[8192];
                        long readTotal = 0L;
                        while ((read = in.read(buf)) != -1) {
                            sink2.write(buf, 0, read);
                            readTotal += (long)read;
                            if (progressCallback == null || total <= 0L) continue;
                            double frac = Math.max(0.0, Math.min(1.0, (double)readTotal / (double)total));
                            progressCallback.accept(frac);
                        }
                        sink2.flush();
                    }
                    Files.deleteIfExists(destination);
                    Files.move(temp, destination, new CopyOption[0]);
                    boolean bl = true;
                    return bl;
                }
                Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Download failed (attempt {}/{}): {} {}", (Object)attempt, (Object)3, (Object)response.code(), (Object)response.message());
            }
            catch (IOException e) {
                Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Download IO error (attempt {}/{}): {}", (Object)attempt, (Object)3, (Object)e.getMessage());
            }
            try {
                Files.deleteIfExists(temp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (attempt < 3) {
                try {
                    Thread.sleep(backoff);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                backoff = Math.min(backoff * 2L, 8000L);
            }
            ++attempt;
        }
    }

    public boolean verify(Path file, Long expectedSize, String expectedMd5, String expectedSha256) {
        try {
            long size;
            if (expectedSize != null && expectedSize > 0L && (size = Files.size(file)) != expectedSize) {
                Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Size mismatch for {}. Expected {}, got {}", (Object)file.getFileName(), (Object)expectedSize, (Object)size);
                return false;
            }
            if (expectedSha256 != null && !expectedSha256.isBlank()) {
                if (!HashUtil.matchesSha256(file, expectedSha256)) {
                    Downloadbypass.LOGGER.error("[EXTERNAL-MODS] SHA-256 mismatch for {}", (Object)file.getFileName());
                    return false;
                }
            } else if (expectedMd5 != null && !expectedMd5.isBlank() && !HashUtil.matchesMd5(file, expectedMd5)) {
                Downloadbypass.LOGGER.error("[EXTERNAL-MODS] MD5 mismatch for {}", (Object)file.getFileName());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Verification IO error: {}", (Object)e.getMessage());
            return false;
        }
    }
}

