/*
 * Decompiled with CFR 0.152.
 */
package net.ekical.sotuff.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.ekical.sotuff.client.FreezeTickControl;
import net.ekical.sotuff.client.MathUtils;
import net.ekical.sotuff.client.OverlayRenderer;
import net.ekical.sotuff.config.SoTuffConfig;
import net.ekical.sotuff.utils.GeneratedSounds;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_433;
import net.minecraft.class_5819;

public final class MonochromeRenderer {
    private static final class_310 MC = class_310.method_1551();
    private static final int GRAY_R = 76;
    private static final int GRAY_G = 150;
    private static final int GRAY_B = 29;
    private static class_1043 frozenTex;
    private static class_2960 frozenId;
    private static int texW;
    private static int texH;
    private static final long DEBOUNCE_MS = 200L;
    private static long lastEnqueueAt;
    private static boolean pending;
    private static long pendingReadyAt;
    private static int pendingDurationMs;
    private static int pendingSkullIndex;
    private static float pendingPitch;
    private static String pendingSoundId;
    private static int activeSkullIndex;
    private static class_1113 currentSound;
    private static float currentPitch;
    private static class_2960 currentSoundId;

    private MonochromeRenderer() {
    }

    public static void start(int durationMs, int skullIndex) {
        MonochromeRenderer.start(durationMs, skullIndex, MonochromeRenderer.calculatePitch(), null);
    }

    public static void start(int durationMs, int skullIndex, float pitch, String soundId) {
        long now = System.currentTimeMillis();
        if (now - lastEnqueueAt < 50L) {
            return;
        }
        lastEnqueueAt = now;
        pending = true;
        pendingReadyAt = now + 200L;
        pendingDurationMs = durationMs;
        pendingSkullIndex = skullIndex;
        pendingPitch = pitch;
        pendingSoundId = soundId;
    }

    public static void tick() {
        if (FreezeTickControl.isActive()) {
            MonochromeRenderer.enforceNoPause();
        }
        long now = System.currentTimeMillis();
        if (pending && now >= pendingReadyAt) {
            pending = false;
            activeSkullIndex = pendingSkullIndex;
            currentPitch = pendingPitch;
            int adjustedDurationMs = (int)((float)pendingDurationMs / currentPitch);
            FreezeTickControl.activate(adjustedDurationMs);
            OverlayRenderer.setSyncedSkullIndex(activeSkullIndex);
            OverlayRenderer.forceRestartShake();
            MonochromeRenderer.clearFrozenTexture();
            MonochromeRenderer.captureAndUploadGrayscale();
            class_3414 evt = pendingSoundId != null && !pendingSoundId.isEmpty() ? class_3414.method_47908((class_2960)class_2960.method_60654((String)pendingSoundId)) : GeneratedSounds.getRandom();
            if (evt != null) {
                MonochromeRenderer.stopCurrentSound();
                MonochromeRenderer.playEffectSound(evt, currentPitch);
            }
        }
        if (!FreezeTickControl.isActive()) {
            MonochromeRenderer.stopCurrentSound();
            MonochromeRenderer.clearFrozenTexture();
        }
    }

    private static void enforceNoPause() {
        if (MC.method_1493() || MonochromeRenderer.MC.field_1755 instanceof class_433) {
            MC.method_1507(null);
        }
    }

    private static void stopCurrentSound() {
        if (currentSound != null) {
            try {
                MC.method_1483().method_4870(currentSound);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            currentSound = null;
        }
    }

    public static void updatePitch(float newPitch) {
        currentPitch = newPitch;
        if (currentSoundId != null && FreezeTickControl.isActive()) {
            MonochromeRenderer.stopCurrentSound();
            MonochromeRenderer.playEffectSound(class_3414.method_47908((class_2960)currentSoundId), currentPitch);
        }
    }

    private static void playEffectSound(class_3414 evt, float pitch) {
        currentSoundId = evt.comp_3319();
        currentSound = new class_1109(currentSoundId, class_3419.field_15250, 1.0f, pitch, class_5819.method_43047(), false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true);
        MC.method_1483().method_4873(currentSound);
    }

    public static void renderHud(class_332 ctx) {
        if (!FreezeTickControl.isActive()) {
            return;
        }
        if (MonochromeRenderer.MC.field_1755 == null && frozenId != null) {
            int w = ctx.method_51421();
            int h = ctx.method_51443();
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.disableBlend();
            ctx.method_51448().method_22903();
            ctx.method_25290(class_1921::method_62277, frozenId, 0, 0, 0.0f, 0.0f, w, h, w, h);
            ctx.method_51448().method_22909();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
        }
        OverlayRenderer.setSyncedSkullIndex(activeSkullIndex);
        if (SoTuffConfig.get().cinematicBars) {
            OverlayRenderer.renderCinematicBars(ctx);
        }
        OverlayRenderer.render(ctx);
    }

    private static void captureAndUploadGrayscale() {
        try {
            class_1011 img = MonochromeRenderer.grabFramebufferImage();
            if (img == null) {
                return;
            }
            MonochromeRenderer.toGrayscale(img);
            MonochromeRenderer.clearFrozenTexture();
            frozenTex = new class_1043(img);
            frozenId = class_2960.method_60655((String)"so-tuff", (String)("frozen_" + System.nanoTime()));
            MC.method_1531().method_4616(frozenId, (class_1044)frozenTex);
            texW = img.method_4307();
            texH = img.method_4323();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class_1011 grabFramebufferImage() {
        class_276 fb = MC.method_1522();
        return fb != null ? class_318.method_1663((class_276)fb) : null;
    }

    private static void toGrayscale(class_1011 img) {
        int w = img.method_4307();
        int h = img.method_4323();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = img.method_61940(x, y);
                int r = argb >>> 16 & 0xFF;
                int g = argb >>> 8 & 0xFF;
                int b = argb & 0xFF;
                int gray = r * 76 + g * 150 + b * 29 >>> 8;
                img.method_61941(x, y, 0xFF000000 | gray << 16 | gray << 8 | gray);
            }
        }
    }

    private static void clearFrozenTexture() {
        if (frozenTex != null) {
            try {
                frozenTex.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            frozenTex = null;
        }
        frozenId = null;
        texH = 0;
        texW = 0;
    }

    private static float calculatePitch() {
        SoTuffConfig cfg = SoTuffConfig.get();
        float lo = MathUtils.clampFloat(cfg.soundPitchMin, 0.5f, 2.0f);
        float hi = MathUtils.clampFloat(cfg.soundPitchMax, 0.5f, 2.0f);
        if (hi < lo) {
            float temp = lo;
            lo = hi;
            hi = temp;
        }
        if (cfg.varySoundSpeed && hi > lo) {
            return lo + (float)Math.random() * (hi - lo);
        }
        return MathUtils.clampFloat(cfg.soundPitchDefault, 0.5f, 2.0f);
    }

    static {
        lastEnqueueAt = 0L;
        pending = false;
        pendingReadyAt = 0L;
        pendingDurationMs = 0;
        pendingSkullIndex = -1;
        pendingPitch = 1.0f;
        pendingSoundId = null;
        activeSkullIndex = -1;
        currentSound = null;
        currentPitch = 1.0f;
        currentSoundId = null;
    }
}

