/*
 * Decompiled with CFR 0.152.
 */
package net.ekical.sotuff.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.ekical.sotuff.config.SoTuffConfig;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public final class OverlayRenderer {
    private static final class_310 MC = class_310.method_1551();
    private static final List<class_2960> SKULLS = new ArrayList<class_2960>();
    private static final Random RNG = new Random();
    private static int forcedIndex = -1;
    private static class_2960 lastPick = null;
    private static long lastPickFrame = -1L;
    private static final double SHAKE_DURATION_S = 1.0;
    private static final double SHAKE_FREQ_HZ = 15.0;
    private static final double SHAKE_AMP_X_PX = 60.0;
    private static final double SHAKE_AMP_Y_PX = 6.0;
    private static volatile boolean shaking = false;
    private static volatile long shakeStartNanos = -1L;

    private OverlayRenderer() {
    }

    public static void triggerShake() {
        if (!SoTuffConfig.get().shakeEnabled) {
            return;
        }
        if (!shaking) {
            shaking = true;
            shakeStartNanos = System.nanoTime();
        }
    }

    public static void forceRestartShake() {
        if (!SoTuffConfig.get().shakeEnabled) {
            return;
        }
        shaking = true;
        shakeStartNanos = System.nanoTime();
    }

    public static synchronized void reloadUserImages() {
        SKULLS.clear();
        forcedIndex = -1;
        lastPick = null;
        lastPickFrame = -1L;
        OverlayRenderer.loadSkullResources();
    }

    public static void renderCinematicBars(class_332 ctx) {
        int w = ctx.method_51421();
        int h = ctx.method_51443();
        int vw = (int)Math.round((double)h * 9.0 / 16.0);
        int BLACK = -16777216;
        if (vw <= w) {
            int leftPad = (w - vw) / 2;
            int rightPad = w - (leftPad + vw);
            if (leftPad > 0) {
                ctx.method_25294(0, 0, leftPad, h, -16777216);
            }
            if (rightPad > 0) {
                ctx.method_25294(w - rightPad, 0, w, h, -16777216);
            }
        } else {
            int vhFitted = (int)Math.round((double)w * 16.0 / 9.0);
            int topPad = (h - vhFitted) / 2;
            int bottomPad = h - (topPad + vhFitted);
            if (topPad > 0) {
                ctx.method_25294(0, 0, w, topPad, -16777216);
            }
            if (bottomPad > 0) {
                ctx.method_25294(0, h - bottomPad, w, h, -16777216);
            }
        }
    }

    public static void render(class_332 ctx) {
        OverlayRenderer.ensureSkullsLoaded();
        if (SKULLS.isEmpty()) {
            return;
        }
        class_2960 textureId = OverlayRenderer.pickCurrent();
        int fullW = ctx.method_51421();
        int fullH = ctx.method_51443();
        int texW = 512;
        int texH = 512;
        double scale = Math.min((double)fullW / (double)texW, (double)fullH / (double)texH) * 0.3;
        int centerX = fullW >> 1;
        int centerY = fullH >> 1;
        double yShift = (double)fullH * 0.25;
        double shakeX = 0.0;
        double shakeY = 0.0;
        if (SoTuffConfig.get().shakeEnabled && shaking) {
            double elapsed = (double)(System.nanoTime() - shakeStartNanos) / 1.0E9;
            if (elapsed < 1.0) {
                double t = elapsed / 1.0;
                double decay = 1.0 - t;
                decay *= decay;
                double phase = elapsed * 15.0 * 2.0 * Math.PI;
                shakeX = Math.sin(phase) * 60.0 * decay;
                shakeY = Math.sin(phase + 1.5707963267948966) * 6.0 * decay;
            } else {
                shaking = false;
            }
        }
        double offsetX = (double)centerX - (double)texW * scale / 2.0 + shakeX;
        double offsetY = (double)centerY - (double)texH * scale / 2.0 + yShift + shakeY;
        ctx.method_51448().method_22903();
        ctx.method_51448().method_22904(offsetX, offsetY, 0.0);
        ctx.method_51448().method_22905((float)scale, (float)scale, 1.0f);
        ctx.method_25290(class_1921::method_62277, textureId, 0, 0, 0.0f, 0.0f, texW, texH, texW, texH);
        ctx.method_51448().method_22909();
    }

    public static void setSyncedSkullIndex(int idx) {
        OverlayRenderer.ensureSkullsLoaded();
        if (SKULLS.isEmpty()) {
            forcedIndex = -1;
            return;
        }
        forcedIndex = Math.floorMod(idx, SKULLS.size());
        lastPick = null;
        lastPickFrame = -1L;
    }

    private static class_2960 pickCurrent() {
        long frame;
        if (forcedIndex >= 0 && forcedIndex < SKULLS.size()) {
            return SKULLS.get(forcedIndex);
        }
        long l = frame = OverlayRenderer.MC.field_1687 != null ? OverlayRenderer.MC.field_1687.method_8510() : 0L;
        if (lastPick != null && frame == lastPickFrame) {
            return lastPick;
        }
        lastPick = SKULLS.get(RNG.nextInt(SKULLS.size()));
        lastPickFrame = frame;
        return lastPick;
    }

    private static void ensureSkullsLoaded() {
        if (SKULLS.isEmpty()) {
            OverlayRenderer.loadSkullResources();
        }
    }

    private static void loadSkullResources() {
        try {
            Map imgs = MC.method_1478().method_14488("textures/skulls", id -> "so-tuff".equals(id.method_12836()) && id.method_12832().endsWith(".png"));
            ArrayList ids = new ArrayList(imgs.keySet());
            ids.sort(Comparator.comparing(class_2960::toString));
            SKULLS.addAll(ids);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

