/*
 * Decompiled with CFR 0.152.
 */
package net.ekical.sotuff.client;

import net.ekical.sotuff.client.AutoScheduler;
import net.ekical.sotuff.client.FreezeTickControl;
import net.ekical.sotuff.client.MonochromeRenderer;
import net.ekical.sotuff.client.OverlayRenderer;
import net.ekical.sotuff.client.SoTuffKeybinds;
import net.ekical.sotuff.client.UserMedia;
import net.ekical.sotuff.config.SoTuffConfig;
import net.ekical.sotuff.network.NetworkHandler;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1269;
import net.minecraft.class_310;

public final class SoTuffClient
implements ClientModInitializer {
    private static volatile long dueManualTriggerAtMs = 0L;
    private static int dueManualDurationMs = 4000;

    private static void enqueueManualTrigger(int durationMs, long delayMs) {
        long now = System.currentTimeMillis();
        dueManualDurationMs = durationMs;
        dueManualTriggerAtMs = now + Math.max(0L, delayMs);
    }

    public void onInitializeClient() {
        NetworkHandler.registerClientReceivers();
        SoTuffKeybinds.init();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            String dir = SoTuffConfig.get().customMediaDir;
            if (dir != null && !dir.isBlank()) {
                client.execute(() -> {
                    UserMedia.setRootAndRefresh(dir);
                    OverlayRenderer.reloadUserImages();
                });
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> NetworkHandler.sendClientPrefsFromConfig());
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hit) -> {
            if (world.field_9236 && player == class_310.method_1551().field_1724 && SoTuffConfig.get().triggerAfterEachAction) {
                SoTuffClient.enqueueManualTrigger(4000, 75L);
            }
            return class_1269.field_5811;
        });
        HudRenderCallback.EVENT.register((ctx, tickDelta) -> {
            if (FreezeTickControl.isActive()) {
                MonochromeRenderer.renderHud(ctx);
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            MonochromeRenderer.tick();
            long now = System.currentTimeMillis();
            if (dueManualTriggerAtMs > 0L && now >= dueManualTriggerAtMs) {
                dueManualTriggerAtMs = 0L;
                NetworkHandler.sendFreezeTrigger(dueManualDurationMs);
            }
            if (client.method_1493() || client.field_1687 == null || client.field_1724 == null) {
                return;
            }
            if (!SoTuffConfig.get().triggerAfterEachAction) {
                AutoScheduler.tick();
            }
        });
    }
}

