/*
 * Decompiled with CFR 0.152.
 */
package net.ekical.sotuff.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import net.ekical.sotuff.client.AutoScheduler;
import net.ekical.sotuff.client.MathUtils;
import net.ekical.sotuff.client.OverlayRenderer;
import net.ekical.sotuff.client.UserMedia;
import net.ekical.sotuff.config.SoTuffConfig;
import net.ekical.sotuff.config.SoTuffRuntime;
import net.ekical.sotuff.network.NetworkHandler;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public final class SoTuffOptionsScreen
extends class_437 {
    private final class_437 parent;
    private class_4185 afterEachActionBtn;
    private class_4185 useCustomBtn;
    private FrequencySlider freqSlider;
    private IntSecondsSlider minSlider;
    private IntSecondsSlider maxSlider;
    private class_4185 varySoundBtn;
    private PitchSlider pitchMinSlider;
    private PitchSlider pitchMaxSlider;
    private class_4185 shakeBtn;
    private class_4185 barsBtn;
    private class_342 mediaPathField;
    private class_4185 refreshBtn;
    private class_4185 doneBtn;
    private static final int ROW_H = 20;
    private static final int GAP = 12;
    private final List<class_339> scrollWidgets = new ArrayList<class_339>();
    private final Map<class_339, Integer> baseY = new HashMap<class_339, Integer>();
    private double scrollY = 0.0;
    private int contentTop;
    private int contentBottom;
    private int contentHeight;
    private boolean draggingScrollbar = false;
    private int dragStartMouseY = 0;
    private double dragStartScrollY = 0.0;
    private String lastFreqHint = null;
    private double lastFreqValue = -1.0;
    private Boolean lastServerControlled = null;

    public SoTuffOptionsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"So Tuff Options (sigma)"));
        this.parent = parent;
    }

    protected void method_25426() {
        SoTuffConfig cfg = SoTuffConfig.get();
        int x = this.field_22789 / 2 - 100;
        this.contentTop = 36;
        int donePad = 8;
        int doneH = 20;
        int doneY = this.field_22790 - doneH - donePad;
        this.contentBottom = doneY - 8;
        int y = this.contentTop;
        this.afterEachActionBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)SoTuffOptionsScreen.toggleLabel("Trigger after each action", cfg.triggerAfterEachAction)), b -> {
            cfg.triggerAfterEachAction = !cfg.triggerAfterEachAction;
            b.method_25355((class_2561)class_2561.method_43470((String)SoTuffOptionsScreen.toggleLabel("Trigger after each action", cfg.triggerAfterEachAction)));
            SoTuffConfig.save();
            AutoScheduler.resetNow();
            NetworkHandler.sendClientPrefsFromConfig();
            this.updateEnabledStates();
        }).method_46434(x, y, 200, 20).method_46431();
        this.afterEachActionBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Play the effect after every action you do.\nIf you beat the game with this enabled, I respect the grind.")));
        this.addScrollable((class_339)this.afterEachActionBtn, y);
        this.useCustomBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)SoTuffOptionsScreen.toggleLabel("Use custom time window", cfg.useCustomWindow)), b -> {
            cfg.useCustomWindow = !cfg.useCustomWindow;
            b.method_25355((class_2561)class_2561.method_43470((String)SoTuffOptionsScreen.toggleLabel("Use custom time window", cfg.useCustomWindow)));
            SoTuffConfig.save();
            AutoScheduler.resetNow();
            this.updateEnabledStates();
        }).method_46434(x, y += 36, 200, 20).method_46431();
        this.useCustomBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Choose your own min/max seconds for random triggers.")));
        this.addScrollable((class_339)this.useCustomBtn, y);
        y += 32;
        double f = cfg.frequency01;
        if (Double.isNaN(f) || f < 0.0 || f > 1.0) {
            f = 0.5;
        }
        this.freqSlider = new FrequencySlider(x, y, 200, 20, f, v -> {
            cfg.frequency01 = MathUtils.clamp01(v);
            SoTuffConfig.save();
            NetworkHandler.sendClientPrefsFromConfig();
        });
        this.freqSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"How often the effect fires when playing normally.")));
        this.addScrollable((class_339)this.freqSlider, y);
        y += 36;
        int minSec = MathUtils.clampInt(cfg.customMinSec, 5, 900);
        int maxSec = MathUtils.clampInt(cfg.customMaxSec, 5, 900);
        if (minSec > maxSec) {
            int t = minSec;
            minSec = maxSec;
            maxSec = t;
        }
        this.minSlider = new IntSecondsSlider(x, y, 200, 20, "Minimum delay", minSec, 5, 900, v -> {
            SoTuffConfig c = SoTuffConfig.get();
            c.customMinSec = MathUtils.clampInt(v, 5, Math.min(900, c.customMaxSec));
            SoTuffConfig.save();
        });
        this.minSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"lower seconds used when custom window is ON.")));
        this.addScrollable((class_339)this.minSlider, y);
        this.maxSlider = new IntSecondsSlider(x, y += 32, 200, 20, "Maximum delay", maxSec, 5, 900, v -> {
            SoTuffConfig c = SoTuffConfig.get();
            c.customMaxSec = MathUtils.clampInt(v, Math.max(5, c.customMinSec), 900);
            SoTuffConfig.save();
        });
        this.maxSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"higher seconds used when custom window is ON.")));
        this.addScrollable((class_339)this.maxSlider, y);
        this.varySoundBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)SoTuffOptionsScreen.toggleLabel("Randomize sound speed", cfg.varySoundSpeed)), b -> {
            cfg.varySoundSpeed = !cfg.varySoundSpeed;
            b.method_25355((class_2561)class_2561.method_43470((String)SoTuffOptionsScreen.toggleLabel("Randomize sound speed", cfg.varySoundSpeed)));
            SoTuffConfig.save();
            NetworkHandler.sendClientPrefsFromConfig();
            this.updateEnabledStates();
        }).method_46434(x, y += 36, 200, 20).method_46431();
        this.addScrollable((class_339)this.varySoundBtn, y);
        this.pitchMinSlider = new PitchSlider(x, y += 32, 200, 20, "Min pitch", cfg.soundPitchMin, val -> {
            cfg.soundPitchMin = MathUtils.clampFloat((float)val, 0.5f, 2.0f);
            SoTuffOptionsScreen.fixPitchOrder();
            SoTuffConfig.save();
            NetworkHandler.sendClientPrefsFromConfig();
        });
        this.addScrollable((class_339)this.pitchMinSlider, y);
        this.pitchMaxSlider = new PitchSlider(x, y += 32, 200, 20, "Max pitch", cfg.soundPitchMax, val -> {
            cfg.soundPitchMax = MathUtils.clampFloat((float)val, 0.5f, 2.0f);
            SoTuffOptionsScreen.fixPitchOrder();
            SoTuffConfig.save();
            NetworkHandler.sendClientPrefsFromConfig();
        });
        this.addScrollable((class_339)this.pitchMaxSlider, y);
        this.shakeBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)SoTuffOptionsScreen.toggleLabel("Shake effect", cfg.shakeEnabled)), b -> {
            cfg.shakeEnabled = !cfg.shakeEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)SoTuffOptionsScreen.toggleLabel("Shake effect", cfg.shakeEnabled)));
            SoTuffConfig.save();
        }).method_46434(x, y += 38, 200, 20).method_46431();
        this.shakeBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Enable/disable the overlay shake animation.")));
        this.addScrollable((class_339)this.shakeBtn, y);
        this.barsBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)SoTuffOptionsScreen.toggleLabel("Cinematic bars (9:16)", cfg.cinematicBars)), b -> {
            cfg.cinematicBars = !cfg.cinematicBars;
            b.method_25355((class_2561)class_2561.method_43470((String)SoTuffOptionsScreen.toggleLabel("Cinematic bars (9:16)", cfg.cinematicBars)));
            SoTuffConfig.save();
            NetworkHandler.sendClientPrefsFromConfig();
        }).method_46434(x, y += 38, 200, 20).method_46431();
        this.barsBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Enable W youtube shorts resolution")));
        this.addScrollable((class_339)this.barsBtn, y);
        int fieldW = 200;
        int btnW = 80;
        int pad = 6;
        this.mediaPathField = new class_342(this.field_22793, x, y += 40, fieldW, 20, (class_2561)class_2561.method_43473());
        this.mediaPathField.method_1880(512);
        this.mediaPathField.method_47404((class_2561)class_2561.method_43470((String)"Custom Media (root)"));
        this.mediaPathField.method_1852(SoTuffConfig.get().customMediaDir == null ? "" : SoTuffConfig.get().customMediaDir);
        this.mediaPathField.method_1863(val -> {
            SoTuffConfig c = SoTuffConfig.get();
            c.customMediaDir = val.trim();
            SoTuffConfig.save();
        });
        this.method_25429((class_364)this.mediaPathField);
        this.addScrollable((class_339)this.mediaPathField, y);
        this.refreshBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Refresh"), b -> {
            String p = SoTuffConfig.get().customMediaDir;
            UserMedia.setRootAndRefresh(p);
            OverlayRenderer.reloadUserImages();
        }).method_46434(x + fieldW + pad, y, btnW, 20).method_46431();
        this.addScrollable((class_339)this.refreshBtn, y);
        this.contentHeight = (y += 42) + 20 - this.contentTop;
        this.doneBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), b -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, doneY, 200, doneH).method_46431();
        this.method_37063((class_364)this.doneBtn);
        this.updateEnabledStates();
        this.applyScroll();
    }

    private void addScrollable(class_339 w, int baseYVal) {
        this.scrollWidgets.add(w);
        this.baseY.put(w, baseYVal);
        this.method_37063((class_364)w);
    }

    private void updateEnabledStates() {
        boolean enableCustom;
        SoTuffConfig cfg = SoTuffConfig.get();
        boolean perAction = cfg.triggerAfterEachAction;
        boolean custom = cfg.useCustomWindow;
        boolean pitchEnabled = cfg.varySoundSpeed;
        boolean serverControlled = this.isServerControlled();
        if (this.useCustomBtn != null) {
            this.useCustomBtn.field_22763 = !perAction;
        }
        boolean enableFreq = !perAction && !custom;
        boolean bl = enableCustom = !perAction && custom;
        if (this.freqSlider != null) {
            this.freqSlider.field_22763 = enableFreq;
        }
        if (this.minSlider != null) {
            this.minSlider.field_22763 = enableCustom;
        }
        if (this.maxSlider != null) {
            this.maxSlider.field_22763 = enableCustom;
        }
        if (this.varySoundBtn != null) {
            this.varySoundBtn.field_22763 = !serverControlled;
            this.varySoundBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)(serverControlled ? "Randomize pitch (Controlled by server)" : "Randomize pitch for the effect sound (slower/faster)."))));
        }
        if (this.pitchMinSlider != null) {
            this.pitchMinSlider.field_22763 = pitchEnabled && !serverControlled;
            this.pitchMinSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)(serverControlled ? "Minimum pitch (Controlled by server)" : "Minimum pitch (0.50\u20132.00). 1.00 = normal speed."))));
        }
        if (this.pitchMaxSlider != null) {
            this.pitchMaxSlider.field_22763 = pitchEnabled && !serverControlled;
            this.pitchMaxSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)(serverControlled ? "Maximum pitch (Controlled by server)" : "Maximum pitch (0.50\u20132.00). 1.00 = normal speed."))));
        }
    }

    private static void fixPitchOrder() {
        SoTuffConfig c = SoTuffConfig.get();
        float max = c.soundPitchMax;
        float min = c.soundPitchMin;
        if (max < min) {
            c.soundPitchMin = max;
            c.soundPitchMax = min;
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        double f;
        this.method_25420(ctx, mouseX, mouseY, delta);
        ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        if (this.freqSlider != null && Math.abs((f = this.freqSlider.getValue()) - this.lastFreqValue) > 0.001) {
            this.lastFreqValue = f;
            double t = MathUtils.easeInOutCubic(f);
            double minS = MathUtils.lerp(120.0, 5.0, t);
            double maxS = MathUtils.lerp(600.0, 20.0, t);
            this.lastFreqHint = String.format("Chance window: %.0f\u2013%.0fs  (higher = more often, lower = rarer)", minS, maxS);
            this.freqSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)this.lastFreqHint)));
        }
        boolean sc = this.isServerControlled();
        if (this.lastServerControlled == null || this.lastServerControlled != sc) {
            this.lastServerControlled = sc;
            this.updateEnabledStates();
        }
        ctx.method_44379(0, this.contentTop, this.field_22789, this.contentBottom);
        if (this.mediaPathField != null) {
            int lx = this.mediaPathField.method_46426();
            int ly = this.mediaPathField.method_46427() - 10;
            ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Custom Media:"), lx, ly, 0xA0A0A0);
        }
        for (class_339 w : this.scrollWidgets) {
            w.method_25394(ctx, mouseX, mouseY, delta);
        }
        ctx.method_44380();
        if (this.doneBtn != null) {
            this.doneBtn.method_25394(ctx, mouseX, mouseY, delta);
        }
        this.drawScrollbar(ctx);
    }

    private void drawScrollbar(class_332 ctx) {
        int viewportH = Math.max(1, this.contentBottom - this.contentTop);
        int maxScroll = Math.max(0, this.contentHeight - viewportH);
        if (maxScroll <= 0) {
            return;
        }
        int trackW = 6;
        int trackPad = 6;
        int trackX1 = this.field_22789 - trackW - trackPad;
        int trackX2 = this.field_22789 - trackPad;
        int trackY1 = this.contentTop;
        int trackY2 = this.contentBottom;
        int thumbH = Math.max(24, (int)((long)viewportH * (long)viewportH / (long)this.contentHeight));
        int thumbMaxTravel = viewportH - thumbH;
        int thumbY = trackY1 + (maxScroll == 0 ? 0 : (int)Math.round(this.scrollY / (double)maxScroll * (double)thumbMaxTravel));
        int trackCol = 0x40FFFFFF;
        ctx.method_25294(trackX1, trackY1, trackX2, trackY2, trackCol);
        int thumbCol = this.draggingScrollbar ? -855638017 : -1996488705;
        ctx.method_25294(trackX1, trackY1 + thumbY, trackX2, trackY1 + thumbY + thumbH, thumbCol);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isOverScrollbar(mouseX, mouseY)) {
            this.draggingScrollbar = true;
            this.dragStartMouseY = (int)mouseY;
            this.dragStartScrollY = this.scrollY;
            return true;
        }
        if (this.doneBtn != null && this.doneBtn.method_25405(mouseX, mouseY)) {
            return this.doneBtn.method_25402(mouseX, mouseY, button);
        }
        if (mouseY < (double)this.contentTop || mouseY > (double)this.contentBottom) {
            return false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.draggingScrollbar) {
            int viewportH = Math.max(1, this.contentBottom - this.contentTop);
            int maxScroll = Math.max(0, this.contentHeight - viewportH);
            if (maxScroll > 0) {
                int thumbH = Math.max(24, (int)((long)viewportH * (long)viewportH / (long)this.contentHeight));
                int thumbMaxTravel = viewportH - thumbH;
                if (thumbMaxTravel < 1) {
                    thumbMaxTravel = 1;
                }
                double deltaPx = mouseY - (double)this.dragStartMouseY;
                double deltaScroll = deltaPx / (double)thumbMaxTravel * (double)maxScroll;
                this.scrollY = MathUtils.clampDouble(this.dragStartScrollY + deltaScroll, 0.0, maxScroll);
                this.applyScroll();
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private boolean isOverScrollbar(double mouseX, double mouseY) {
        int trackW = 6;
        int trackPad = 6;
        int x1 = this.field_22789 - trackW - trackPad;
        int x2 = this.field_22789 - trackPad;
        return mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)this.contentTop && mouseY <= (double)this.contentBottom && this.contentHeight > this.contentBottom - this.contentTop;
    }

    public boolean method_25401(double mouseX, double mouseY, double horiz, double vert) {
        int viewportH = Math.max(1, this.contentBottom - this.contentTop);
        int maxScroll = Math.max(0, this.contentHeight - viewportH);
        if (maxScroll <= 0) {
            return super.method_25401(mouseX, mouseY, horiz, vert);
        }
        this.scrollY = MathUtils.clampDouble(this.scrollY - vert * 12.0, 0.0, maxScroll);
        this.applyScroll();
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        int viewportH = Math.max(1, this.contentBottom - this.contentTop);
        int maxScroll = Math.max(0, this.contentHeight - viewportH);
        switch (keyCode) {
            case 265: {
                this.scrollY = MathUtils.clampDouble(this.scrollY - 12.0, 0.0, maxScroll);
                break;
            }
            case 264: {
                this.scrollY = MathUtils.clampDouble(this.scrollY + 12.0, 0.0, maxScroll);
                break;
            }
            case 266: {
                this.scrollY = MathUtils.clampDouble(this.scrollY - (double)viewportH * 0.9, 0.0, maxScroll);
                break;
            }
            case 267: {
                this.scrollY = MathUtils.clampDouble(this.scrollY + (double)viewportH * 0.9, 0.0, maxScroll);
                break;
            }
            case 268: {
                this.scrollY = 0.0;
                break;
            }
            case 269: {
                this.scrollY = maxScroll;
                break;
            }
            default: {
                return super.method_25404(keyCode, scanCode, modifiers);
            }
        }
        this.applyScroll();
        return true;
    }

    private void applyScroll() {
        int viewportH = Math.max(1, this.contentBottom - this.contentTop);
        int maxScroll = Math.max(0, this.contentHeight - viewportH);
        this.scrollY = MathUtils.clampDouble(this.scrollY, 0.0, maxScroll);
        int dy = (int)(this.scrollY + 0.5);
        for (class_339 w : this.scrollWidgets) {
            Integer by = this.baseY.get(w);
            if (by == null) continue;
            w.method_46419(by - dy);
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private static String toggleLabel(String base, boolean on) {
        return on ? base + ": ON" : base + ": OFF";
    }

    private boolean isServerControlled() {
        if (!SoTuffRuntime.isServerControlled()) {
            return false;
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            if (this.field_22787.method_1496()) {
                return false;
            }
            if (this.field_22787.field_1724.method_64475(2)) {
                return false;
            }
        }
        return true;
    }

    private static final class FrequencySlider
    extends class_357 {
        private final DoubleConsumer onChange;

        FrequencySlider(int x, int y, int w, int h, double initial01, DoubleConsumer onChange) {
            super(x, y, w, h, (class_2561)class_2561.method_43473(), MathUtils.clamp01(initial01));
            this.onChange = onChange;
            this.method_25346();
        }

        protected void method_25346() {
            int pct = (int)Math.round(this.field_22753 * 100.0);
            this.method_25355((class_2561)class_2561.method_43470((String)("Frequency: " + pct + "%")));
        }

        protected void method_25344() {
            this.onChange.accept(this.field_22753);
        }

        double getValue() {
            return this.field_22753;
        }
    }

    private static final class IntSecondsSlider
    extends class_357 {
        private final IntConsumer onChange;
        private final String label;
        private final int minSec;
        private final int maxSec;

        IntSecondsSlider(int x, int y, int w, int h, String label, int initialSec, int minSec, int maxSec, IntConsumer onChange) {
            super(x, y, w, h, (class_2561)class_2561.method_43473(), IntSecondsSlider.norm(initialSec, minSec, maxSec));
            this.label = label;
            this.onChange = onChange;
            this.minSec = minSec;
            this.maxSec = maxSec;
            this.method_25346();
        }

        private static double norm(int val, int lo, int hi) {
            val = Math.max(lo, Math.min(hi, val));
            return (double)(val - lo) / (double)(hi - lo);
        }

        private int denorm(double v) {
            return (int)Math.round((double)this.minSec + v * (double)(this.maxSec - this.minSec));
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)(this.label + ": " + this.denorm(this.field_22753) + "s")));
        }

        protected void method_25344() {
            this.onChange.accept(this.denorm(this.field_22753));
        }
    }

    private static final class PitchSlider
    extends class_357 {
        private final DoubleConsumer onChange;
        private final String label;

        PitchSlider(int x, int y, int w, int h, String label, float initialPitch, DoubleConsumer onChange) {
            super(x, y, w, h, (class_2561)class_2561.method_43473(), PitchSlider.norm(initialPitch));
            this.label = label;
            this.onChange = onChange;
            this.method_25346();
        }

        private static double norm(float pitch) {
            float p = pitch;
            if (p < 0.5f) {
                p = 0.5f;
            }
            if (p > 2.0f) {
                p = 2.0f;
            }
            return (p - 0.5f) / 1.5f;
        }

        private static float denorm(double v) {
            return (float)(0.5 + v * 1.5);
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)(this.label + ": " + String.format("\u00d7%.2f", Float.valueOf(PitchSlider.denorm(this.field_22753))))));
        }

        protected void method_25344() {
            this.onChange.accept(PitchSlider.denorm(this.field_22753));
        }
    }
}

