/*
 * Decompiled with CFR 0.152.
 */
package net.ekical.sotuff.client;

import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ekical.sotuff.client.OverlayRenderer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public final class UserMedia {
    private static final String NAMESPACE = "so-tuff";
    private static final String PACK_FOLDER_NAME = "SoTuff-UserMedia";
    private static final List<class_2960> USER_SKULLS = new ArrayList<class_2960>();
    private static final Map<class_2960, class_1043> USER_TEX = new HashMap<class_2960, class_1043>();
    private static Path currentRoot = null;

    private UserMedia() {
    }

    private static class_310 mc() {
        return class_310.method_1551();
    }

    public static synchronized void setRootAndRefresh(String rootDir) {
        if (rootDir == null || rootDir.isBlank()) {
            UserMedia.unloadAll();
            currentRoot = null;
            return;
        }
        currentRoot = Paths.get(rootDir, new String[0]).toAbsolutePath().normalize();
        UserMedia.refresh();
    }

    public static synchronized void refresh() {
        UserMedia.unloadAll();
        if (currentRoot == null) {
            return;
        }
        try {
            Path imagesDir = currentRoot.resolve("images");
            List<Path> imageFiles = Files.isDirectory(imagesDir, new LinkOption[0]) ? Files.walk(imagesDir, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> {
                String n = p.getFileName().toString().toLowerCase(Locale.ROOT);
                return n.endsWith(".png") || n.endsWith(".jpg") || n.endsWith(".jpeg");
            }).sorted().collect(Collectors.toList()) : List.of();
            Path soundsDir = currentRoot.resolve("sounds");
            Path soundsJson = currentRoot.resolve("sounds.json");
            Path rpRoot = UserMedia.getUserPackRoot();
            UserMedia.buildUserPack(rpRoot, soundsDir, soundsJson, imageFiles);
            System.out.println("[SoTuff] UserMedia: pack updated at " + String.valueOf(rpRoot));
            UserMedia.mc().execute(() -> {
                System.out.println("[SoTuff] UserMedia: scheduling resource reload");
                UserMedia.mc().method_1521().thenRun(() -> {
                    System.out.println("[SoTuff] UserMedia: reload completed -> rescan skull textures");
                    UserMedia.mc().execute(OverlayRenderer::reloadUserImages);
                });
            });
        }
        catch (Exception e) {
            System.out.println("[SoTuff] UserMedia.refresh error: " + String.valueOf(e));
        }
    }

    public static synchronized List<class_2960> getUserSkulls() {
        return Collections.unmodifiableList(USER_SKULLS);
    }

    public static synchronized void unloadAll() {
        ArrayList<class_1043> toClose = new ArrayList<class_1043>(USER_TEX.values());
        USER_TEX.clear();
        USER_SKULLS.clear();
        UserMedia.mc().execute(() -> {
            for (class_1043 tex : toClose) {
                try {
                    tex.close();
                }
                catch (Throwable throwable) {}
            }
        });
    }

    private static Path getUserPackRoot() throws Exception {
        Path rp = UserMedia.mc().field_1697.toPath().resolve("resourcepacks").resolve(PACK_FOLDER_NAME);
        Files.createDirectories(rp, new FileAttribute[0]);
        return rp;
    }

    private static void buildUserPack(Path rpRoot, Path soundsDir, Path soundsJson, List<Path> imageFiles) throws Exception {
        UserMedia.deleteDirectory(rpRoot);
        Files.createDirectories(rpRoot, new FileAttribute[0]);
        String mcmeta = "{\n  \"pack\": {\n    \"pack_format\": 48,\n    \"description\": \"Your custom Sounds/Images!\"\n  }\n}\n";
        Files.writeString(rpRoot.resolve("pack.mcmeta"), (CharSequence)mcmeta, new OpenOption[0]);
        Path assetsNs = rpRoot.resolve("assets").resolve(NAMESPACE);
        Files.createDirectories(assetsNs.resolve("sounds"), new FileAttribute[0]);
        Files.createDirectories(assetsNs.resolve("textures/skulls"), new FileAttribute[0]);
        if (Files.isDirectory(soundsDir, new LinkOption[0]) && Files.isReadable(soundsJson)) {
            Files.copy(soundsJson, assetsNs.resolve("sounds.json"), StandardCopyOption.REPLACE_EXISTING);
            try (Stream<Path> stream = Files.walk(soundsDir, new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> {
                    try {
                        Path rel = soundsDir.relativize((Path)p);
                        Path dst = assetsNs.resolve("sounds").resolve(rel);
                        Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                        Files.copy(p, dst, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Exception ioe) {
                        System.out.println("[SoTuff] UserMedia: copy sound failed " + String.valueOf(p) + " -> " + String.valueOf(ioe));
                    }
                });
            }
        } else {
            System.out.println("[SoTuff] UserMedia: sounds missing; skipping sound copy");
        }
        Path skullsDir = assetsNs.resolve("textures/skulls");
        Files.createDirectories(skullsDir, new FileAttribute[0]);
        for (Path imgPath : imageFiles) {
            try {
                InputStream in = Files.newInputStream(imgPath, new OpenOption[0]);
                try {
                    class_1011 img = class_1011.method_4309((InputStream)in);
                    class_1011 resized = UserMedia.resizeTo512(img);
                    String fileName = imgPath.getFileName().toString();
                    int dotIndex = fileName.lastIndexOf(46);
                    String base = dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
                    Path out = skullsDir.resolve(base + ".png");
                    resized.method_4314(out);
                    resized.close();
                    img.close();
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (Throwable t) {
                System.out.println("[SoTuff] UserMedia: failed to copy/resize image " + String.valueOf(imgPath) + " -> " + String.valueOf(t));
            }
        }
    }

    private static class_1011 resizeTo512(class_1011 src) {
        int W = 512;
        int H = 512;
        class_1011 dst = new class_1011(W, H, false);
        int srcW = src.method_4307();
        int srcH = src.method_4323();
        float sx = (float)srcW / (float)W;
        float sy = (float)srcH / (float)H;
        int maxSrcX = srcW - 1;
        int maxSrcY = srcH - 1;
        for (int y = 0; y < H; ++y) {
            for (int x = 0; x < W; ++x) {
                int srcX = Math.min((int)((float)x * sx), maxSrcX);
                int srcY = Math.min((int)((float)y * sy), maxSrcY);
                dst.method_61941(x, y, src.method_61940(srcX, srcY));
            }
        }
        return dst;
    }

    private static void deleteDirectory(Path dir) throws Exception {
        if (Files.exists(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(p -> {
                    try {
                        Files.delete(p);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
    }
}

