/*
 * Decompiled with CFR 0.152.
 */
package net.ekical.sotuff.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.ekical.sotuff.client.MathUtils;
import net.minecraft.class_310;

public final class SoTuffConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static volatile SoTuffConfig INSTANCE;
    private static volatile File configFile;
    public boolean triggerAfterEachAction = false;
    public double frequency01 = 0.5;
    public boolean useCustomWindow = false;
    public int customMinSec = 120;
    public int customMaxSec = 600;
    public boolean varySoundSpeed = false;
    public float soundPitchMin = 0.5f;
    public float soundPitchMax = 3.0f;
    public float soundPitchDefault = 1.0f;
    public String customMediaDir = "";
    public boolean cinematicBars = false;
    public boolean shakeEnabled = true;

    private SoTuffConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SoTuffConfig get() {
        SoTuffConfig result = INSTANCE;
        if (result != null) return result;
        Class<SoTuffConfig> clazz = SoTuffConfig.class;
        synchronized (SoTuffConfig.class) {
            result = INSTANCE;
            if (result != null) return result;
            INSTANCE = result = SoTuffConfig.load();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void save() {
        try {
            File file = SoTuffConfig.getFile();
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            SoTuffConfig c = SoTuffConfig.get();
            SoTuffConfig.normalizePitchValues(c);
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                GSON.toJson((Object)c, (Appendable)w);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SoTuffConfig load() {
        try {
            File f = SoTuffConfig.getFile();
            if (!f.isFile()) return new SoTuffConfig();
            try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);){
                SoTuffConfig cfg = (SoTuffConfig)GSON.fromJson((Reader)r, SoTuffConfig.class);
                if (cfg == null) return new SoTuffConfig();
                SoTuffConfig.normalizePitchValues(cfg);
                SoTuffConfig soTuffConfig = cfg;
                return soTuffConfig;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SoTuffConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getFile() {
        File result = configFile;
        if (result != null) return result;
        Class<SoTuffConfig> clazz = SoTuffConfig.class;
        synchronized (SoTuffConfig.class) {
            result = configFile;
            if (result != null) return result;
            File gameDir = class_310.method_1551().field_1697;
            configFile = result = new File(gameDir, "config/so_tuff.json");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private static void normalizePitchValues(SoTuffConfig cfg) {
        cfg.soundPitchMin = MathUtils.clampFloat(cfg.soundPitchMin, 0.5f, 2.0f);
        cfg.soundPitchMax = MathUtils.clampFloat(cfg.soundPitchMax, 0.5f, 2.0f);
        if (cfg.soundPitchMax < cfg.soundPitchMin) {
            float t = cfg.soundPitchMin;
            cfg.soundPitchMin = cfg.soundPitchMax;
            cfg.soundPitchMax = t;
        }
    }
}

