/*
 * Decompiled with CFR 0.152.
 */
package net.ekical.sotuff.network;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.ekical.sotuff.client.MonochromeRenderer;
import net.ekical.sotuff.client.OverlayRenderer;
import net.ekical.sotuff.config.SoTuffConfig;
import net.ekical.sotuff.config.SoTuffRuntime;
import net.ekical.sotuff.network.payload.ClientPrefsC2SPayload;
import net.ekical.sotuff.network.payload.EffectivePrefsS2CPayload;
import net.ekical.sotuff.network.payload.FreezeRequestC2SPayload;
import net.ekical.sotuff.network.payload.FreezeStartS2CPayload;
import net.ekical.sotuff.network.payload.FreezeUpdatePitchS2CPayload;
import net.ekical.sotuff.server.FreezeServerControl;
import net.ekical.sotuff.server.PrefAggregator;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public final class NetworkHandler {
    private static final Deque<QueuedFreeze> FREEZE_QUEUE = new ArrayDeque<QueuedFreeze>(8);
    private static boolean lastFreezeActive = false;
    private static long lastTriggerTime = 0L;
    private static final long TRIGGER_COOLDOWN_MS = 200L;
    private static UUID lastKilledEntityUUID = null;
    private static long lastKillTime = 0L;
    private static final List<String> DEFAULT_SOUNDS = Collections.unmodifiableList(List.of("so-tuff:phonk/ef1", "so-tuff:phonk/ef2", "so-tuff:phonk/ef3", "so-tuff:phonk/ef4", "so-tuff:phonk/ef5", "so-tuff:phonk/ef6", "so-tuff:phonk/ef7", "so-tuff:phonk/ef8", "so-tuff:phonk/ef9"));

    private NetworkHandler() {
    }

    public static void registerPayloadTypes() {
        PayloadTypeRegistry.playC2S().register(FreezeRequestC2SPayload.ID, FreezeRequestC2SPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ClientPrefsC2SPayload.ID, ClientPrefsC2SPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(FreezeStartS2CPayload.ID, FreezeStartS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(EffectivePrefsS2CPayload.ID, EffectivePrefsS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(FreezeUpdatePitchS2CPayload.ID, FreezeUpdatePitchS2CPayload.CODEC);
    }

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(ClientPrefsC2SPayload.ID, (payload, ctx) -> ctx.player().method_5682().execute(() -> {
            class_3222 p = ctx.player();
            if (p.method_64475(2) || !p.method_5682().method_3816()) {
                PrefAggregator.setControllerPrefs(payload.perAction(), payload.freq01(), payload.vary(), payload.bars(), NetworkHandler.clampPitch(payload.pitchMin()), NetworkHandler.clampPitch(payload.pitchMax()), NetworkHandler.clampPitch(payload.pitchDefault()));
                List players = p.method_51469().method_18456();
                PrefAggregator.broadcastToAll(players);
                if (FreezeServerControl.isActive()) {
                    float newPitch = NetworkHandler.calculatePitch();
                    FreezeUpdatePitchS2CPayload upd = new FreezeUpdatePitchS2CPayload(newPitch);
                    for (class_3222 sp2 : players) {
                        ServerPlayNetworking.send((class_3222)sp2, (class_8710)upd);
                    }
                }
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(FreezeRequestC2SPayload.ID, (payload, context) -> context.player().method_5682().execute(() -> NetworkHandler.startFreezeFor(context.player(), payload.durationMs())));
    }

    public static void registerClientReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(EffectivePrefsS2CPayload.ID, (payload, ctx) -> ctx.client().execute(() -> SoTuffRuntime.applyFromServer(payload.perAction(), payload.freq01(), payload.vary(), payload.bars(), payload.pitchMin(), payload.pitchMax(), payload.pitchDefault())));
        ClientPlayNetworking.registerGlobalReceiver(FreezeStartS2CPayload.ID, (payload, ctx) -> ctx.client().execute(() -> {
            OverlayRenderer.setSyncedSkullIndex(payload.skullIndex());
            MonochromeRenderer.start(payload.durationMs(), payload.skullIndex(), payload.pitch(), payload.soundId());
        }));
        ClientPlayNetworking.registerGlobalReceiver(FreezeUpdatePitchS2CPayload.ID, (payload, ctx) -> ctx.client().execute(() -> MonochromeRenderer.updatePitch(payload.pitch())));
    }

    public static void sendFreezeTrigger(int durationMs) {
        if (ClientPlayNetworking.canSend(FreezeRequestC2SPayload.ID)) {
            ClientPlayNetworking.send((class_8710)new FreezeRequestC2SPayload(durationMs));
        } else {
            OverlayRenderer.setSyncedSkullIndex(ThreadLocalRandom.current().nextInt(0, 1024));
            MonochromeRenderer.start(durationMs, 0, 1.0f, null);
        }
    }

    public static void registerServerEventTriggers() {
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, be) -> {
            if (!SoTuffRuntime.triggerAfterEachAction()) {
                return;
            }
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                NetworkHandler.startFreezeFor(sp, 4000);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            QueuedFreeze q;
            boolean active = FreezeServerControl.isActive();
            if (!active && lastFreezeActive && !FREEZE_QUEUE.isEmpty() && (q = FREEZE_QUEUE.pollFirst()) != null) {
                NetworkHandler.startGlobalFreeze(q.world, q.durationMs);
            }
            lastFreezeActive = active;
        });
        ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register((world, killer, victim) -> {
            if (!SoTuffRuntime.triggerAfterEachAction()) {
                return;
            }
            long now = System.currentTimeMillis();
            UUID victimUUID = victim.method_5667();
            if (victimUUID.equals(lastKilledEntityUUID) && now - lastKillTime < 500L) {
                return;
            }
            lastKilledEntityUUID = victimUUID;
            lastKillTime = now;
            if (killer instanceof class_3222) {
                class_3222 sp = (class_3222)killer;
                NetworkHandler.startFreezeFor(sp, 4000);
            } else if (victim instanceof class_3222) {
                class_3222 dead = (class_3222)victim;
                NetworkHandler.startFreezeFor(dead, 4000);
            }
        });
    }

    public static void startFreezeFor(class_3222 sp, int durationMs) {
        class_3218 sw = sp.method_51469();
        long now = System.currentTimeMillis();
        if (now - lastTriggerTime < 200L) {
            return;
        }
        lastTriggerTime = now;
        if (FreezeServerControl.isActive()) {
            FREEZE_QUEUE.addLast(new QueuedFreeze(sw, durationMs));
            while (FREEZE_QUEUE.size() > 64) {
                FREEZE_QUEUE.pollFirst();
            }
        } else {
            NetworkHandler.startGlobalFreeze(sw, durationMs);
        }
    }

    private static void startGlobalFreeze(class_3218 sw, int durationMs) {
        float pitch = NetworkHandler.calculatePitch();
        String soundId = NetworkHandler.pickRandomSound();
        int adjustedDurationMs = (int)((float)durationMs / pitch);
        FreezeServerControl.activate(adjustedDurationMs);
        int skull = ThreadLocalRandom.current().nextInt(0, 1024);
        FreezeStartS2CPayload msg = new FreezeStartS2CPayload(durationMs, skull, pitch, soundId);
        for (class_3222 other : sw.method_18456()) {
            ServerPlayNetworking.send((class_3222)other, (class_8710)msg);
        }
    }

    public static void sendClientPrefsFromConfig() {
        if (!ClientPlayNetworking.canSend(ClientPrefsC2SPayload.ID)) {
            return;
        }
        SoTuffConfig c = SoTuffConfig.get();
        ClientPlayNetworking.send((class_8710)new ClientPrefsC2SPayload(c.triggerAfterEachAction, c.frequency01, c.varySoundSpeed, c.cinematicBars, c.soundPitchMin, c.soundPitchMax, c.soundPitchDefault));
    }

    private static float calculatePitch() {
        if (!PrefAggregator.controllerVary()) {
            return 1.0f;
        }
        float lo = Math.max(0.5f, Math.min(2.0f, PrefAggregator.controllerPitchMin()));
        float hi = Math.max(0.5f, Math.min(2.0f, PrefAggregator.controllerPitchMax()));
        if (hi < lo) {
            float t = lo;
            lo = hi;
            hi = t;
        }
        if (hi > lo) {
            return lo + ThreadLocalRandom.current().nextFloat() * (hi - lo);
        }
        float def = Math.max(0.5f, Math.min(2.0f, PrefAggregator.controllerPitchDefault()));
        return def;
    }

    private static String pickRandomSound() {
        return DEFAULT_SOUNDS.get(ThreadLocalRandom.current().nextInt(DEFAULT_SOUNDS.size()));
    }

    private static float clampPitch(float p) {
        return Math.max(0.5f, Math.min(2.0f, p));
    }

    private static final class QueuedFreeze {
        final class_3218 world;
        final int durationMs;

        QueuedFreeze(class_3218 world, int durationMs) {
            this.world = world;
            this.durationMs = durationMs;
        }
    }
}

