/*
 * Decompiled with CFR 0.152.
 */
package net.ekical.sotuff.server;

import net.ekical.sotuff.client.MathUtils;
import net.ekical.sotuff.network.payload.EffectivePrefsS2CPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public final class PrefAggregator {
    private static Pref controller = null;

    private PrefAggregator() {
    }

    public static void setControllerPrefs(boolean perAction, double freq01, boolean vary, boolean bars, float pitchMin, float pitchMax, float pitchDefault) {
        Pref pr = new Pref();
        pr.perAction = perAction;
        pr.freq01 = MathUtils.clamp01(freq01);
        pr.vary = vary;
        pr.bars = bars;
        pr.pitchMin = pitchMin;
        pr.pitchMax = pitchMax;
        pr.pitchDefault = pitchDefault;
        controller = pr;
    }

    public static EffectivePrefsS2CPayload computeEffective() {
        if (controller == null) {
            return new EffectivePrefsS2CPayload(false, 0.5, true, true, 1.0f, 1.0f, 1.0f);
        }
        return new EffectivePrefsS2CPayload(PrefAggregator.controller.perAction, PrefAggregator.controller.freq01, PrefAggregator.controller.vary, PrefAggregator.controller.bars, PrefAggregator.controller.pitchMin, PrefAggregator.controller.pitchMax, PrefAggregator.controller.pitchDefault);
    }

    public static void broadcastToAll(Iterable<class_3222> players) {
        EffectivePrefsS2CPayload eff = PrefAggregator.computeEffective();
        for (class_3222 sp : players) {
            ServerPlayNetworking.send((class_3222)sp, (class_8710)eff);
        }
    }

    public static boolean controllerVary() {
        return controller != null && PrefAggregator.controller.vary;
    }

    public static float controllerPitchMin() {
        return controller != null ? PrefAggregator.controller.pitchMin : 1.0f;
    }

    public static float controllerPitchMax() {
        return controller != null ? PrefAggregator.controller.pitchMax : 1.0f;
    }

    public static float controllerPitchDefault() {
        return controller != null ? PrefAggregator.controller.pitchDefault : 1.0f;
    }

    private static final class Pref {
        boolean perAction;
        boolean vary;
        boolean bars;
        double freq01;
        float pitchMin;
        float pitchMax;
        float pitchDefault;

        private Pref() {
        }
    }
}

