/*
 * Decompiled with CFR 0.152.
 */
package net.ekical.sotuff.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public final class GeneratedSounds {
    private static final Random RAND = new Random();
    private static final List<class_2960> DEFAULT_KEYS = List.of(class_2960.method_60655((String)"so-tuff", (String)"phonk/ef1"), class_2960.method_60655((String)"so-tuff", (String)"phonk/ef2"), class_2960.method_60655((String)"so-tuff", (String)"phonk/ef3"), class_2960.method_60655((String)"so-tuff", (String)"phonk/ef4"), class_2960.method_60655((String)"so-tuff", (String)"phonk/ef5"), class_2960.method_60655((String)"so-tuff", (String)"phonk/ef6"), class_2960.method_60655((String)"so-tuff", (String)"phonk/ef7"), class_2960.method_60655((String)"so-tuff", (String)"phonk/ef8"), class_2960.method_60655((String)"so-tuff", (String)"phonk/ef9"));
    private static final Set<class_2960> DISCOVERED = new LinkedHashSet<class_2960>();
    private static List<class_2960> cachedWeightedPool = null;
    private static boolean triedDiscover = false;

    private GeneratedSounds() {
    }

    private static void discoverNow() {
        DISCOVERED.clear();
        cachedWeightedPool = null;
        triedDiscover = true;
        try {
            class_3300 rm = class_310.method_1551().method_1478();
            class_2960 rid = class_2960.method_60655((String)"so-tuff", (String)"sounds.json");
            List all = rm.method_14489(rid);
            if (all.isEmpty()) {
                System.out.println("[SoTuff] GeneratedSounds: no layered sounds.json found for " + String.valueOf(rid));
            }
            for (class_3298 res : all) {
                InputStream in = res.method_14482();
                try (InputStreamReader rd = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    JsonObject root = JsonParser.parseReader((Reader)rd).getAsJsonObject();
                    for (Map.Entry e : root.entrySet()) {
                        DISCOVERED.add(class_2960.method_60655((String)"so-tuff", (String)((String)e.getKey())));
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            System.out.println("[SoTuff] GeneratedSounds: discovered " + DISCOVERED.size() + " keys from layered sounds.json");
        }
        catch (Throwable t) {
            System.out.println("[SoTuff] GeneratedSounds: discover failed: " + String.valueOf(t));
        }
        DISCOVERED.addAll(DEFAULT_KEYS);
    }

    public static class_3414 getRandom() {
        if (!triedDiscover) {
            GeneratedSounds.discoverNow();
        }
        if (cachedWeightedPool == null) {
            cachedWeightedPool = GeneratedSounds.buildWeightedPool();
        }
        if (cachedWeightedPool.isEmpty()) {
            System.out.println("[SoTuff] GeneratedSounds: empty pool, using defaults");
            return class_3414.method_47908((class_2960)DEFAULT_KEYS.get(RAND.nextInt(DEFAULT_KEYS.size())));
        }
        class_2960 pickId = cachedWeightedPool.get(RAND.nextInt(cachedWeightedPool.size()));
        System.out.println("[SoTuff] pick sound = " + String.valueOf(pickId) + " (weighted pool size=" + cachedWeightedPool.size() + ")");
        return class_3414.method_47908((class_2960)pickId);
    }

    private static List<class_2960> buildWeightedPool() {
        LinkedHashSet<class_2960> pool = new LinkedHashSet<class_2960>(DISCOVERED);
        if (pool.isEmpty()) {
            for (Map.Entry e : class_7923.field_41172.method_29722()) {
                class_2960 id = ((class_5321)e.getKey()).method_29177();
                if (id == null || !"so-tuff".equals(id.method_12836())) continue;
                pool.add(id);
            }
            if (pool.isEmpty()) {
                pool.addAll(DEFAULT_KEYS);
            }
            System.out.println("[SoTuff] GeneratedSounds: built fallback pool size=" + pool.size());
        }
        ArrayList<class_2960> weighted = new ArrayList<class_2960>(pool.size() * 2);
        for (class_2960 id : pool) {
            weighted.add(id);
            if (!id.method_12832().startsWith("custom/")) continue;
            weighted.add(id);
        }
        return weighted;
    }

    public static void registerDefaults() {
        for (class_2960 id : DEFAULT_KEYS) {
            if (class_7923.field_41172.method_10250(id)) continue;
            class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)id, (Object)class_3414.method_47908((class_2960)id));
        }
    }

    public static void logSoTuffSounds() {
        System.out.println("[SoTuff] registry dump (sounds in so-tuff namespace):");
        for (class_2960 id : class_7923.field_41172.method_10235()) {
            if (!"so-tuff".equals(id.method_12836())) continue;
            System.out.println("  - " + String.valueOf(id));
        }
    }
}

