/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.simibubi.create.AllRecipeTypes;
import electrolyte.greate.Greate;
import electrolyte.greate.content.kinetics.crusher.TieredCrushingRecipe;
import electrolyte.greate.content.kinetics.fan.processing.TieredHauntingRecipe;
import electrolyte.greate.content.kinetics.fan.processing.TieredSplashingRecipe;
import electrolyte.greate.content.kinetics.millstone.TieredMillingRecipe;
import electrolyte.greate.content.kinetics.mixer.TieredCompactingRecipe;
import electrolyte.greate.content.kinetics.mixer.TieredMixingRecipe;
import electrolyte.greate.content.kinetics.press.TieredPressingRecipe;
import electrolyte.greate.content.kinetics.saw.TieredCuttingRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeBuilder;
import electrolyte.greate.registry.GreateMaterials;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;

public class GreateValues {
    public static final String[] SN = new String[]{"ULS", "LS", "MS", "HS", "ES", "IS", "LuS", "ZPMS", "US", "UHS"};
    public static final String[] SNF = new String[]{String.valueOf(ChatFormatting.DARK_GRAY) + "ULS", String.valueOf(ChatFormatting.GRAY) + "LS", String.valueOf(ChatFormatting.AQUA) + "MS", String.valueOf(ChatFormatting.GOLD) + "HS", String.valueOf(ChatFormatting.DARK_PURPLE) + "ES", String.valueOf(ChatFormatting.BLUE) + "IS", String.valueOf(ChatFormatting.LIGHT_PURPLE) + "LuS", String.valueOf(ChatFormatting.RED) + "ZPMS", String.valueOf(ChatFormatting.DARK_AQUA) + "US", String.valueOf(ChatFormatting.DARK_RED) + "UHS"};
    public static final String[] STRESS_NAMES = new String[]{"Ultra Low Stress", "Low Stress", "Medium Stress", "High Stress", "Extreme Stress", "Insane Stress", "Ludicrous Stress", "ZPM Stress", "Ultimate Stress", "Ultra High Stress", "Ultra Excessive Stress", "Ultra Immense Stress", "Ultra Extreme Stress", "Overpowered Stress", "Maximum Stress"};
    public static Material[] TM = new Material[]{GreateMaterials.AndesiteAlloy, GTMaterials.Steel, GTMaterials.Aluminium, GTMaterials.StainlessSteel, GTMaterials.Titanium, GTMaterials.TungstenSteel, GTMaterials.RhodiumPlatedPalladium, GTMaterials.NaquadahAlloy, GTMaterials.Darmstadtium, GTMaterials.Neutronium};
    public static Material[] BM = new Material[]{GTMaterials.Rubber, GTMaterials.SiliconeRubber, GTMaterials.Polyethylene, GTMaterials.Polytetrafluoroethylene, GTMaterials.Polybenzimidazole};

    public static int convertGTEUToTier(List<Content> content) {
        if (content.isEmpty()) {
            return 0;
        }
        long eut = ((EnergyStack)content.get(0).getContent()).voltage();
        for (int i = 0; i < GTValues.V.length; ++i) {
            long voltage = GTValues.V[i];
            if (eut > voltage) continue;
            return GTValues.ALL_TIERS[i];
        }
        return 14;
    }

    public static Material getMaterialFromTier(int tier) {
        if (TM.length > tier) {
            return TM[tier];
        }
        return null;
    }

    public static TieredProcessingRecipeBuilder.TieredProcessingRecipeFactory<TieredProcessingRecipe<?>> getFactory(ResourceLocation loc) {
        for (String s : Greate.CONFIG.ignoredRecipeTypes) {
            if (!loc.toString().startsWith(s)) continue;
            return null;
        }
        if (loc.toString().startsWith(GTRecipeTypes.MACERATOR_RECIPES.registryName.toString()) || loc.toString().startsWith(AllRecipeTypes.MILLING.getId().toString())) {
            return TieredMillingRecipe::new;
        }
        if (loc.toString().startsWith(AllRecipeTypes.CRUSHING.getId().toString())) {
            return TieredCrushingRecipe::new;
        }
        if (loc.toString().startsWith(GTRecipeTypes.BENDER_RECIPES.registryName.toString()) || loc.toString().startsWith(AllRecipeTypes.PRESSING.getId().toString())) {
            return TieredPressingRecipe::new;
        }
        if (loc.toString().startsWith(GTRecipeTypes.MIXER_RECIPES.registryName.toString()) || loc.toString().startsWith(AllRecipeTypes.MIXING.getId().toString())) {
            return TieredMixingRecipe::new;
        }
        if (loc.toString().startsWith(GTRecipeTypes.CUTTER_RECIPES.registryName.toString()) || loc.toString().startsWith(AllRecipeTypes.CUTTING.getId().toString())) {
            return TieredCuttingRecipe::new;
        }
        if (loc.toString().startsWith(GTRecipeTypes.ORE_WASHER_RECIPES.registryName.toString()) || loc.toString().startsWith(AllRecipeTypes.SPLASHING.getId().toString())) {
            return TieredSplashingRecipe::new;
        }
        if (loc.toString().startsWith(GTRecipeTypes.COMPRESSOR_RECIPES.registryName.toString())) {
            return TieredCompactingRecipe::new;
        }
        if (loc.toString().startsWith(AllRecipeTypes.HAUNTING.getId().toString())) {
            return TieredHauntingRecipe::new;
        }
        if (loc.toString().startsWith(AllRecipeTypes.COMPACTING.getId().toString())) {
            return TieredCompactingRecipe::new;
        }
        return null;
    }
}

