/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.compat.jei.category;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import electrolyte.greate.compat.jei.category.GreateRecipeCategory;
import electrolyte.greate.compat.jei.category.TieredBasinCategory;
import electrolyte.greate.compat.jei.category.animations.TieredAnimatedMechanicalPress;
import electrolyte.greate.content.kinetics.press.TieredMechanicalPressBlock;
import electrolyte.greate.content.processing.basin.TieredBasinRecipe;
import electrolyte.greate.registry.MechanicalPresses;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

@ParametersAreNonnullByDefault
public class TieredPackingCategory
extends TieredBasinCategory {
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    private final PackingType packingType;

    public static TieredPackingCategory standard(GreateRecipeCategory.Info<TieredBasinRecipe> info) {
        return new TieredPackingCategory(info, PackingType.COMPACTING);
    }

    public static TieredPackingCategory autoSquare(GreateRecipeCategory.Info<TieredBasinRecipe> info) {
        return new TieredPackingCategory(info, PackingType.AUTO_SQUARE);
    }

    protected TieredPackingCategory(GreateRecipeCategory.Info<TieredBasinRecipe> info, PackingType packingType) {
        super(info, packingType != PackingType.AUTO_SQUARE);
        this.packingType = packingType;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, TieredBasinRecipe recipe, IFocusGroup focuses) {
        int rows;
        if (this.packingType == PackingType.COMPACTING) {
            super.setRecipe(builder, recipe, focuses);
            return;
        }
        NonNullList ingredients = recipe.m_7527_();
        int size = ingredients.size();
        int n = rows = size == 4 ? 2 : 3;
        for (int i = 0; i < size; ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, (rows == 2 ? 27 : 18) + i % rows * 19, 51 - i / rows * 19).setBackground(TieredPackingCategory.getRenderedSlot(), -1, -1).addIngredients(ingredient);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 142, 51).setBackground(TieredPackingCategory.getRenderedSlot(), -1, -1).addItemStack(CreateRecipeCategory.getResultItem((Recipe)recipe));
    }

    @Override
    public void draw(TieredBasinRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double x, double y) {
        HeatCondition requiredHeat;
        boolean type = this.packingType == PackingType.AUTO_SQUARE;
        double yOffset = type ? 90.0 : 108.0;
        super.draw(recipe, recipeSlotsView, graphics, x, yOffset);
        if (this.packingType != PackingType.COMPACTING) {
            AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, 32);
            AllGuiTextures.JEI_SHADOW.render(graphics, 81, 68);
        }
        if ((requiredHeat = recipe.getRequiredHeat()) != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 55);
        }
        new TieredAnimatedMechanicalPress((TieredMechanicalPressBlock)MechanicalPresses.MECHANICAL_PRESSES[recipe.getRecipeTier()].get(), true).draw(graphics, this.getBackground().getWidth() / 2 + 3, 34);
    }

    protected static enum PackingType {
        COMPACTING,
        AUTO_SQUARE;

    }
}

