/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.compat.jei.category.animations;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import electrolyte.greate.content.kinetics.press.TieredMechanicalPressBlock;
import electrolyte.greate.registry.GreatePartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TieredAnimatedMechanicalPress
extends AnimatedKinetics {
    private boolean basin;
    private final TieredMechanicalPressBlock block;

    public TieredAnimatedMechanicalPress(TieredMechanicalPressBlock block, boolean basin) {
        this.block = block;
        this.basin = basin;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-15.5f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(22.5f));
        int scale = this.basin ? 23 : 24;
        this.blockElement(this.shaft((Block)this.block)).rotateBlock(0.0, 0.0, (double)TieredAnimatedMechanicalPress.getCurrentAngle()).scale((double)scale).render(guiGraphics);
        this.blockElement(this.block.m_49966_()).scale((double)scale).render(guiGraphics);
        this.blockElement(GreatePartialModels.MECHANICAL_PRESS_HEAD_MODELS[this.block.getTier()]).atLocal(0.0, (double)(-this.getAnimatedHeadOffset()), 0.0).scale((double)scale).render(guiGraphics);
        if (this.basin) {
            this.blockElement(AllBlocks.BASIN.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale((double)scale).render(guiGraphics);
        }
        matrixStack.m_85849_();
    }

    private float getAnimatedHeadOffset() {
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(this.offset * 8)) % 30.0f;
        if (cycle < 10.0f) {
            float progress = cycle / 10.0f;
            return -(progress * progress * progress);
        }
        if (cycle < 15.0f) {
            return -1.0f;
        }
        if (cycle < 20.0f) {
            return -1.0f + (1.0f - (20.0f - cycle) / 5.0f);
        }
        return 0.0f;
    }

    private BlockState shaft(Block block) {
        return (BlockState)((TieredMechanicalPressBlock)block).getShaft().m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
    }
}

