/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.belt;

import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.transport.BeltMovementHandler;
import electrolyte.greate.content.kinetics.belt.TieredBeltBlock;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredKineticBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TieredBeltBlockEntity
extends BeltBlockEntity
implements ITieredKineticBlockEntity {
    private int tier;

    public TieredBeltBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tier = ((TieredBeltBlock)state.m_60734_()).getTier();
    }

    public void tick() {
        if (this.beltLength == 0) {
            BeltBlock.initBelt((Level)this.f_58857_, (BlockPos)this.f_58858_);
        }
        super.tick();
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof TieredBeltBlock)) {
            return;
        }
        this.initializeItemHandler();
        if (!this.isController()) {
            return;
        }
        this.invalidateRenderBoundingBox();
        this.getInventory().tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.passengers == null) {
            this.passengers = new HashMap();
        }
        ArrayList toRemove = new ArrayList();
        this.passengers.forEach((entity, info) -> {
            boolean leftTheBelt;
            boolean canBeTransported = BeltMovementHandler.canBeTransported((Entity)entity);
            boolean bl = leftTheBelt = info.getTicksSinceLastCollision() > (this.m_58900_().m_61143_(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL ? 3 : 1);
            if (!canBeTransported || leftTheBelt) {
                toRemove.add(entity);
                return;
            }
            info.tick();
            BeltMovementHandler.transportEntity((BeltBlockEntity)this, (Entity)entity, (BeltMovementHandler.TransportedEntityInfo)info);
        });
        toRemove.forEach(this.passengers::remove);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Tier", this.tier);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tier = compound.m_128451_("Tier");
        this.beltLength = compound.m_128451_("Length");
    }

    public boolean applyColor(DyeColor colorIn) {
        if (colorIn == null ? this.color.isEmpty() : this.color.isPresent() && this.color.get() == colorIn) {
            return false;
        }
        if (this.f_58857_.m_5776_()) {
            return true;
        }
        for (BlockPos pos : TieredBeltBlock.getBeltChain((LevelAccessor)this.f_58857_, (BlockPos)this.getController())) {
            BeltBlockEntity bbe = BeltHelper.getSegmentBE((LevelAccessor)this.f_58857_, (BlockPos)pos);
            if (bbe == null) continue;
            bbe.color = Optional.ofNullable(colorIn);
            bbe.m_6596_();
            bbe.sendData();
        }
        return true;
    }

    public boolean hasPulley() {
        if (!(this.m_58900_().m_60734_() instanceof TieredBeltBlock)) {
            return false;
        }
        return this.m_58900_().m_61143_(BeltBlock.PART) != BeltPart.MIDDLE;
    }

    protected Direction getBeltFacing() {
        return super.getBeltFacing();
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return ITieredKineticBlockEntity.super.addToGoggleTooltip(tooltip, isPlayerSneaking, this.getTier(), this.capacity, this.stress);
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.notifyUpdate();
    }
}

