/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.belt;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlicer;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.transport.BeltInventory;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import electrolyte.greate.GreateValues;
import electrolyte.greate.content.kinetics.belt.TieredBeltBlock;
import electrolyte.greate.content.kinetics.belt.TieredBeltBlockEntity;
import electrolyte.greate.content.kinetics.belt.item.TieredBeltConnectorItem;
import electrolyte.greate.infrastructure.config.GConfigUtility;
import electrolyte.greate.mixin.MixinBeltBlockEntityAccessor;
import electrolyte.greate.registry.GreateTagPrefixes;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TieredBeltSlicer {
    public static InteractionResult useConnector(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, BeltSlicer.Feedback feedback) {
        block22: {
            BlockState blockState;
            BeltInventory inventory;
            int mergedBeltLength;
            BeltBlockEntity mergedController;
            BlockPos next;
            boolean creative;
            BlockPos beltVector;
            Material beltMaterial;
            int beltLength;
            BeltBlockEntity controllerBE;
            block23: {
                controllerBE = BeltHelper.getControllerBE((LevelAccessor)level, (BlockPos)pos);
                if (controllerBE == null) {
                    return InteractionResult.PASS;
                }
                beltLength = controllerBE.beltLength;
                beltMaterial = ((TieredBeltConnectorItem)player.m_21120_(hand).m_41720_()).getBeltMaterial();
                if (beltLength == GConfigUtility.getBeltLengthFromMaterial(beltMaterial)) {
                    return InteractionResult.FAIL;
                }
                beltVector = BlockPos.m_274446_((Position)BeltHelper.getBeltVector((BlockState)state));
                BeltPart beltPart = (BeltPart)state.m_61143_(BeltBlock.PART);
                Direction direction = (Direction)state.m_61143_(BeltBlock.HORIZONTAL_FACING);
                List beltChain = BeltBlock.getBeltChain((LevelAccessor)level, (BlockPos)controllerBE.m_58899_());
                creative = player.m_7500_();
                if (!TieredBeltSlicer.hoveringEnd(state, hitResult)) {
                    return InteractionResult.PASS;
                }
                next = beltPart == BeltPart.START ? pos.m_121996_((Vec3i)beltVector) : pos.m_121955_((Vec3i)beltVector);
                mergedController = null;
                mergedBeltLength = 0;
                BlockState nextState = level.m_8055_(next);
                if (!nextState.m_247087_()) {
                    if (!(state.m_60734_() instanceof TieredBeltBlock)) {
                        return InteractionResult.FAIL;
                    }
                    if (!TieredBeltSlicer.beltStatesCompatible(state, nextState)) {
                        return InteractionResult.FAIL;
                    }
                    mergedController = BeltHelper.getControllerBE((LevelAccessor)level, (BlockPos)next);
                    if (mergedController == null) {
                        return InteractionResult.FAIL;
                    }
                    if (mergedController.beltLength + beltLength > GConfigUtility.getBeltLengthFromMaterial(beltMaterial)) {
                        return InteractionResult.FAIL;
                    }
                    mergedBeltLength = mergedController.beltLength;
                    if (!level.f_46443_) {
                        boolean flipBelt = direction != nextState.m_61143_(BeltBlock.HORIZONTAL_FACING);
                        Optional color = controllerBE.color;
                        for (Object blockPos : BeltBlock.getBeltChain((LevelAccessor)level, (BlockPos)mergedController.m_58899_())) {
                            BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)level, (BlockPos)blockPos);
                            if (belt == null) continue;
                            belt.detachKinetics();
                            belt.invalidateItemHandler();
                            belt.beltLength = 0;
                            belt.color = color;
                            if (!flipBelt) continue;
                            level.m_7731_((BlockPos)blockPos, TieredBeltSlicer.flipBelt(level.m_8055_((BlockPos)blockPos)), 67);
                        }
                        if (flipBelt && ((MixinBeltBlockEntityAccessor)mergedController).getInventoryField() != null) {
                            List transportedItems = ((MixinBeltBlockEntityAccessor)mergedController).getInventoryField().getTransportedItems();
                            for (TransportedItemStack transportedStack : transportedItems) {
                                transportedStack.beltPosition = (float)mergedBeltLength - transportedStack.beltPosition;
                                transportedStack.prevBeltPosition = (float)mergedBeltLength - transportedStack.prevBeltPosition;
                            }
                        }
                    }
                }
                if (level.f_46443_) break block22;
                for (BlockPos blockPos : beltChain) {
                    BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)level, (BlockPos)blockPos);
                    if (belt == null) continue;
                    belt.detachKinetics();
                    belt.invalidateItemHandler();
                    belt.beltLength = 0;
                }
                inventory = ((MixinBeltBlockEntityAccessor)controllerBE).getInventoryField();
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_(BeltBlock.PART, (Comparable)BeltPart.MIDDLE)));
                if (mergedController != null) break block23;
                level.m_7731_(next, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)state.m_61124_((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(false))), (BlockPos)next), 67);
                BeltBlockEntity segmentBE = BeltHelper.getSegmentBE((LevelAccessor)level, (BlockPos)next);
                if (segmentBE != null) {
                    segmentBE.color = controllerBE.color;
                }
                level.m_5594_(null, pos, SoundEvents.f_12642_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 0.5f, 1.0f);
                if (beltPart != BeltPart.START || segmentBE == null || inventory == null) break block22;
                segmentBE.setController(next);
                for (TransportedItemStack transportedStack : inventory.getTransportedItems()) {
                    transportedStack.beltPosition += 1.0f;
                    segmentBE.getInventory().addItem(transportedStack);
                }
                break block22;
            }
            BeltInventory mergedInventory = ((MixinBeltBlockEntityAccessor)mergedController).getInventoryField();
            level.m_5594_(null, pos, SoundEvents.f_12641_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 0.5f, 1.3f);
            BeltBlockEntity segmentBE = BeltHelper.getSegmentBE((LevelAccessor)level, (BlockPos)next);
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)next, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(segmentBE != null && segmentBE.casing != BeltBlockEntity.CasingType.NONE))).m_61124_(BeltBlock.PART, (Comparable)BeltPart.MIDDLE)));
            if (!creative) {
                int tier = ((TieredBeltBlockEntity)controllerBE).getTier();
                player.m_150109_().m_150079_(ChemicalHelper.get((TagPrefix)GreateTagPrefixes.shaft, (Material)GreateValues.TM[tier]).m_255036_(2));
                player.m_150109_().m_150079_(ChemicalHelper.get((TagPrefix)GreateTagPrefixes.beltConnector, (Material)beltMaterial));
            }
            BlockPos search = controllerBE.m_58899_();
            for (int i = 0; i < 10000 && (blockState = level.m_8055_(search)).m_60734_() instanceof TieredBeltBlock; ++i) {
                if (blockState.m_61143_(BeltBlock.PART) != BeltPart.START) {
                    search = search.m_121996_((Vec3i)beltVector);
                    continue;
                }
                BeltBlockEntity newController = BeltHelper.getSegmentBE((LevelAccessor)level, (BlockPos)search);
                if (newController != controllerBE && inventory != null) {
                    newController.setController(search);
                    ((MixinBeltBlockEntityAccessor)controllerBE).setInventoryField(null);
                    for (TransportedItemStack transportedStack : inventory.getTransportedItems()) {
                        transportedStack.beltPosition += (float)mergedBeltLength;
                        newController.getInventory().addItem(transportedStack);
                    }
                }
                if (newController == mergedController || mergedInventory == null) break;
                newController.setController(search);
                ((MixinBeltBlockEntityAccessor)mergedController).setInventoryField(null);
                for (TransportedItemStack transportedStack : mergedInventory.getTransportedItems()) {
                    if (newController == controllerBE) {
                        transportedStack.beltPosition += (float)beltLength;
                    }
                    newController.getInventory().addItem(transportedStack);
                }
                break;
            }
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean hoveringEnd(BlockState state, BlockHitResult hitResult) {
        BeltPart part = (BeltPart)state.m_61143_(BeltBlock.PART);
        if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
            return false;
        }
        Vec3 beltVector = BeltHelper.getBeltVector((BlockState)state);
        Vec3 centerOf = VecHelper.getCenterOf((Vec3i)hitResult.m_82425_());
        Vec3 subtract = hitResult.m_82450_().m_82546_(centerOf);
        return subtract.m_82526_(beltVector) > 0.0 == (part == BeltPart.END);
    }

    private static boolean beltStatesCompatible(BlockState state, BlockState nextState) {
        if (state.m_60734_() != nextState.m_60734_()) {
            return false;
        }
        Direction direction = (Direction)state.m_61143_(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)state.m_61143_(BeltBlock.SLOPE);
        Direction direction2 = (Direction)nextState.m_61143_(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope2 = (BeltSlope)nextState.m_61143_(BeltBlock.SLOPE);
        switch (slope) {
            case UPWARD: {
                if (slope2 == BeltSlope.DOWNWARD) {
                    return direction == direction2.m_122424_();
                }
                return slope2 == slope && direction == direction2;
            }
            case DOWNWARD: {
                if (slope2 == BeltSlope.UPWARD) {
                    return direction == direction2.m_122424_();
                }
                return slope2 == slope && direction == direction2;
            }
        }
        return slope2 == slope && direction2.m_122434_() == direction.m_122434_();
    }

    private static BlockState flipBelt(BlockState state) {
        Direction direction = (Direction)state.m_61143_(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)state.m_61143_(BeltBlock.SLOPE);
        BeltPart part = (BeltPart)state.m_61143_(BeltBlock.PART);
        if (slope == BeltSlope.UPWARD) {
            state = (BlockState)state.m_61124_(BeltBlock.SLOPE, (Comparable)BeltSlope.DOWNWARD);
        } else if (slope == BeltSlope.DOWNWARD) {
            state = (BlockState)state.m_61124_(BeltBlock.SLOPE, (Comparable)BeltSlope.UPWARD);
        }
        if (part == BeltPart.END) {
            state = (BlockState)state.m_61124_(BeltBlock.PART, (Comparable)BeltPart.START);
        } else if (part == BeltPart.START) {
            state = (BlockState)state.m_61124_(BeltBlock.PART, (Comparable)BeltPart.END);
        }
        return (BlockState)state.m_61124_(BeltBlock.HORIZONTAL_FACING, (Comparable)direction.m_122424_());
    }
}

