/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.belt;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.processing.burner.ScrollInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import electrolyte.greate.content.kinetics.belt.IBeltRenderHelper;
import electrolyte.greate.content.kinetics.belt.TieredBeltBlock;
import electrolyte.greate.content.kinetics.belt.TieredBeltBlockEntity;
import electrolyte.greate.content.kinetics.belt.TieredBeltRenderer;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.DyeColor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TieredBeltVisual
extends KineticBlockEntityVisual<TieredBeltBlockEntity>
implements IBeltRenderHelper {
    protected final ScrollInstance[] keys;
    protected final ScrollInstance[] overlayKeys;
    protected final RotatingInstance pulleyKey;

    public TieredBeltVisual(VisualizationContext context, TieredBeltBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        BeltPart part = (BeltPart)this.blockState.m_61143_(BeltBlock.PART);
        boolean start = part == BeltPart.START;
        boolean end = part == BeltPart.END;
        DyeColor color = blockEntity.color.orElse(null);
        boolean diagonal = ((BeltSlope)this.blockState.m_61143_(BeltBlock.SLOPE)).isDiagonal();
        this.keys = new ScrollInstance[diagonal ? 1 : 2];
        this.overlayKeys = new ScrollInstance[diagonal ? 1 : 2];
        for (boolean bottom : Iterate.trueAndFalse) {
            PartialModel beltPartial = TieredBeltRenderer.getBeltPartial((TieredBeltBlock)this.blockState.m_60734_(), diagonal, start, end, bottom);
            PartialModel overlayPartial = TieredBeltRenderer.getOverlayPartial(diagonal, start, end, bottom);
            SpriteShiftEntry spriteShift = TieredBeltRenderer.getSpriteShiftEntry((TieredBeltBlock)this.blockState.m_60734_(), diagonal, bottom);
            SpriteShiftEntry overlayShift = TieredBeltRenderer.getDyeOverlayEntry((TieredBeltBlock)this.blockState.m_60734_(), color, diagonal);
            Instancer beltModel = this.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial((PartialModel)beltPartial));
            Instancer overlayModel = this.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial((PartialModel)overlayPartial));
            this.keys[bottom ? 0 : 1] = this.setup((ScrollInstance)beltModel.createInstance(), bottom, spriteShift);
            this.overlayKeys[bottom ? 0 : 1] = this.setup((ScrollInstance)overlayModel.createInstance(), bottom, overlayShift);
            if (diagonal) break;
        }
        if (blockEntity.hasPulley()) {
            this.pulleyKey = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, this.getPulleyModel()).createInstance();
            this.pulleyKey.setup((KineticBlockEntity)this.blockEntity).setPosition((Vec3i)this.getVisualPosition()).setChanged();
        } else {
            this.pulleyKey = null;
        }
    }

    public void update(float partialTick) {
        DyeColor color = ((TieredBeltBlockEntity)this.blockEntity).color.orElse(null);
        boolean diagonal = ((BeltSlope)this.blockState.m_61143_(BeltBlock.SLOPE)).isDiagonal();
        boolean bottom = true;
        for (ScrollInstance key : this.keys) {
            SpriteShiftEntry spriteShiftEntry = TieredBeltRenderer.getSpriteShiftEntry((TieredBeltBlock)this.blockState.m_60734_(), diagonal, bottom);
            this.setup(key, bottom, spriteShiftEntry);
            bottom = false;
        }
        for (ScrollInstance key : this.overlayKeys) {
            SpriteShiftEntry overlayEntry = TieredBeltRenderer.getDyeOverlayEntry((TieredBeltBlock)this.blockState.m_60734_(), color, diagonal);
            this.setup(key, bottom, overlayEntry);
        }
        if (this.pulleyKey != null) {
            this.pulleyKey.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        this.relight((FlatLit[])this.keys);
        this.relight((FlatLit[])this.overlayKeys);
        if (this.pulleyKey != null) {
            this.relight(new FlatLit[]{this.pulleyKey});
        }
    }

    protected void _delete() {
        for (ScrollInstance key : this.keys) {
            key.delete();
        }
        for (ScrollInstance key : this.overlayKeys) {
            key.delete();
        }
        if (this.pulleyKey != null) {
            this.pulleyKey.delete();
        }
    }

    private Model getPulleyModel() {
        Direction dir = this.getOrientation();
        return Models.partial((PartialModel)this.getBeltPulleyModel(this.blockState), (Object)dir.m_122434_(), (axis, poseStack) -> {
            PoseTransformStack msr = TransformStack.of((PoseStack)poseStack);
            msr.center();
            if (axis == Direction.Axis.X) {
                msr.rotateYDegrees(90.0f);
            }
            if (axis == Direction.Axis.Y) {
                msr.rotateXDegrees(90.0f);
            }
            msr.rotateXDegrees(90.0f);
            msr.uncenter();
        });
    }

    private Direction getOrientation() {
        Direction dir = ((Direction)this.blockState.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122427_();
        if (this.blockState.m_61143_(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS) {
            dir = Direction.UP;
        }
        return dir;
    }

    private ScrollInstance setup(ScrollInstance key, boolean bottom, SpriteShiftEntry spriteShift) {
        BeltSlope beltSlope = (BeltSlope)this.blockState.m_61143_(BeltBlock.SLOPE);
        Direction facing = (Direction)this.blockState.m_61143_(BeltBlock.HORIZONTAL_FACING);
        boolean diagonal = beltSlope.isDiagonal();
        boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
        boolean vertical = beltSlope == BeltSlope.VERTICAL;
        boolean upward = beltSlope == BeltSlope.UPWARD;
        boolean alongX = facing.m_122434_() == Direction.Axis.X;
        boolean alongZ = facing.m_122434_() == Direction.Axis.Z;
        boolean downward = beltSlope == BeltSlope.DOWNWARD;
        float speed = ((TieredBeltBlockEntity)this.blockEntity).getSpeed();
        if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE ^ upward ^ (alongX && !diagonal || alongZ && diagonal)) {
            speed = -speed;
        }
        if (sideways && (facing == Direction.SOUTH || facing == Direction.WEST) || vertical && facing == Direction.EAST) {
            speed = -speed;
        }
        float rotX = (!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90 : 0) + (downward ? 180 : 0) + (sideways ? 90 : 0) + (vertical && alongZ ? 180 : 0);
        float rotY = facing.m_122435_() + (float)(diagonal ^ alongX && !downward ? 180 : 0) + (float)(sideways && alongZ ? 180 : 0) + (float)(vertical && alongX ? 90 : 0);
        float rotZ = (sideways ? 90 : 0) + (vertical && alongX ? 90 : 0);
        Quaternionf q = new Quaternionf().rotationXYZ(rotX * ((float)Math.PI / 180), rotY * ((float)Math.PI / 180), rotZ * ((float)Math.PI / 180));
        key.setSpriteShift(spriteShift, 1.0f, diagonal ? 0.375f : 0.5f).position((Vec3i)this.getVisualPosition()).rotation((Quaternionfc)q).speed(0.0f, speed * 0.001984127f).offset(0.0f, bottom ? 0.5f : 0.0f).colorRgb(RotatingInstance.colorFromBE((KineticBlockEntity)((KineticBlockEntity)this.blockEntity))).setChanged();
        return key;
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        if (this.pulleyKey != null) {
            consumer.accept((Instance)this.pulleyKey);
        }
        for (ScrollInstance key : this.keys) {
            consumer.accept((Instance)key);
        }
        for (ScrollInstance key : this.overlayKeys) {
            consumer.accept((Instance)key);
        }
    }
}

