/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.belt.item;

import electrolyte.greate.content.kinetics.belt.item.TieredBeltConnectorItem;
import electrolyte.greate.content.kinetics.simpleRelays.TieredShaftBlock;
import electrolyte.greate.infrastructure.config.GConfigUtility;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class TieredBeltConnectorHandler {
    private static Random rand = new Random();

    public static void tick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player == null || level == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            BlockPos first;
            CompoundTag tag;
            ItemStack heldStack = player.m_21120_(hand);
            Item item = heldStack.m_41720_();
            if (!(item instanceof TieredBeltConnectorItem)) continue;
            TieredBeltConnectorItem tbci = (TieredBeltConnectorItem)item;
            if (!heldStack.m_41782_() || !(tag = heldStack.m_41783_()).m_128441_("FirstPulley") || !level.m_8055_(first = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("FirstPulley"))).m_61138_((Property)BlockStateProperties.f_61365_)) continue;
            Direction.Axis axis = (Direction.Axis)level.m_8055_(first).m_61143_((Property)BlockStateProperties.f_61365_);
            HitResult hitResult = Minecraft.m_91087_().f_91077_;
            if (hitResult == null || !(hitResult instanceof BlockHitResult)) {
                if (rand.nextInt(50) == 0) {
                    level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.3f, 0.9f, 0.5f), 1.0f), (double)((float)first.m_123341_() + 0.5f + TieredBeltConnectorHandler.randomOffset(0.25f)), (double)((float)first.m_123342_() + 0.5f + TieredBeltConnectorHandler.randomOffset(0.25f)), (double)((float)first.m_123343_() + 0.5f + TieredBeltConnectorHandler.randomOffset(0.25f)), 0.0, 0.0, 0.0);
                }
                return;
            }
            BlockPos selected = ((BlockHitResult)hitResult).m_82425_();
            if (level.m_8055_(selected).m_247087_()) {
                return;
            }
            if (!(level.m_8055_(selected).m_60734_() instanceof TieredShaftBlock)) {
                selected = selected.m_121945_(((BlockHitResult)hitResult).m_82434_());
            }
            if (!selected.m_123314_((Vec3i)first, (double)GConfigUtility.getBeltLengthFromMaterial(tbci.getBeltMaterial()))) {
                return;
            }
            boolean canConnect = TieredBeltConnectorItem.validateAxis((Level)level, selected) && TieredBeltConnectorItem.canConnect((Level)level, first, selected, heldStack);
            Vec3 start = Vec3.m_82528_((Vec3i)first);
            Vec3 end = Vec3.m_82528_((Vec3i)selected);
            Vec3 actualDiff = end.m_82546_(start);
            end = end.m_82492_(axis.m_6150_(actualDiff.f_82479_, 0.0, 0.0), axis.m_6150_(0.0, actualDiff.f_82480_, 0.0), axis.m_6150_(0.0, 0.0, actualDiff.f_82481_));
            Vec3 diff = end.m_82546_(start);
            double x = Math.abs(diff.f_82479_);
            double y = Math.abs(diff.f_82480_);
            double z = Math.abs(diff.f_82481_);
            float length = (float)Math.max(x, Math.max(y, z));
            Vec3 step = diff.m_82541_();
            int sames = (x == y ? 1 : 0) + (y == z ? 1 : 0) + (z == x ? 1 : 0);
            if (sames == 0) {
                LinkedList<Vec3> validDiffs = new LinkedList<Vec3>();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (axis.m_7863_(i, j, k) != 0 || axis == Direction.Axis.Y && i != 0 && k != 0 || i == 0 && j == 0 && k == 0) continue;
                            validDiffs.add(new Vec3((double)i, (double)j, (double)k));
                        }
                    }
                }
                int closestIndex = 0;
                float closest = Float.MAX_VALUE;
                for (Vec3 validDiff : validDiffs) {
                    double distanceTo = step.m_82554_(validDiff);
                    if (!(distanceTo < (double)closest)) continue;
                    closest = (float)distanceTo;
                    closestIndex = validDiffs.indexOf(validDiff);
                }
                step = (Vec3)validDiffs.get(closestIndex);
            }
            if (axis == Direction.Axis.Y && step.f_82479_ != 0.0 && step.f_82481_ != 0.0) {
                return;
            }
            step = new Vec3(Math.signum(step.f_82479_), Math.signum(step.f_82480_), Math.signum(step.f_82481_));
            for (float f = 0.0f; f < length; f += 0.0625f) {
                Vec3 position = start.m_82549_(step.m_82490_((double)f));
                if (rand.nextInt(10) != 0) continue;
                level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(canConnect ? 0.3f : 0.9f, canConnect ? 0.9f : 0.3f, 0.5f), 1.0f), position.f_82479_ + 0.5, position.f_82480_ + 0.5, position.f_82481_ + 0.5, 0.0, 0.0, 0.0);
            }
            return;
        }
    }

    private static float randomOffset(float range) {
        return (rand.nextFloat() - 0.5f) * 2.0f * range;
    }
}

