/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.belt.item;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import electrolyte.greate.GreateValues;
import electrolyte.greate.content.gtceu.material.BeltProperty;
import electrolyte.greate.content.gtceu.material.GreatePropertyKeys;
import electrolyte.greate.content.kinetics.belt.ITieredBelt;
import electrolyte.greate.content.kinetics.simpleRelays.TieredBracketedKineticBlockEntity;
import electrolyte.greate.content.kinetics.simpleRelays.TieredShaftBlock;
import electrolyte.greate.infrastructure.config.GConfigUtility;
import electrolyte.greate.registry.Belts;
import electrolyte.greate.registry.GreateTagPrefixes;
import electrolyte.greate.registry.Shafts;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TieredBeltConnectorItem
extends Item
implements ITieredBelt {
    private Material material;
    private final List<Material> validShafts;

    public TieredBeltConnectorItem(Item.Properties pProperties, Material material) {
        super(pProperties);
        this.validShafts = ((BeltProperty)material.getProperty(GreatePropertyKeys.BELT)).getValidShafts();
        this.material = material;
    }

    public String m_5524_() {
        return this.m_41467_();
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        String beltLength = String.valueOf(GConfigUtility.getBeltLengthFromMaterial(this.material));
        MutableComponent beltLengthComponent = Component.m_237115_((String)beltLength).m_130940_(ChatFormatting.BOLD).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA));
        int s1RGB = GreateValues.TM[((TieredShaftBlock)this.getValidShafts().get(0).get()).getTier()].getMaterialRGB();
        int s2RGB = GreateValues.TM[((TieredShaftBlock)this.getValidShafts().get(1).get()).getTier()].getMaterialRGB();
        String shaft1_name = ((TieredShaftBlock)this.getValidShafts().get(0).get()).getShaft().m_49954_().getString();
        String shaft2_name = ((TieredShaftBlock)this.getValidShafts().get(1).get()).getShaft().m_49954_().getString();
        MutableComponent s1nComponent = Component.m_237113_((String)shaft1_name).m_130948_(Style.f_131099_.m_178520_(s1RGB));
        MutableComponent s2nComponent = Component.m_237113_((String)shaft2_name).m_130948_(Style.f_131099_.m_178520_(s2RGB));
        MutableComponent belt_maxlength = Component.m_237115_((String)"greate.tooltip.belt_maxlength").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
        MutableComponent belt_usable = Component.m_237115_((String)"greate.tooltip.belt_usable").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
        tooltip.add((Component)belt_maxlength.m_7220_((Component)beltLengthComponent));
        tooltip.add((Component)belt_usable.m_7220_((Component)s1nComponent).m_130946_(" & ").m_7220_((Component)s2nComponent));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        if (player != null && player.m_6144_()) {
            pContext.m_43722_().m_41751_(null);
            return InteractionResult.SUCCESS;
        }
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        boolean validAxis = TieredBeltConnectorItem.validateAxis(level, pos);
        if (level.f_46443_) {
            return validAxis ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        CompoundTag tag = pContext.m_43722_().m_41784_();
        BlockPos firstPulley = null;
        if (!(!tag.m_128441_("FirstPulley") || TieredBeltConnectorItem.validateAxis(level, firstPulley = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("FirstPulley"))) && firstPulley.m_123314_((Vec3i)pos, (double)(GConfigUtility.getBeltLengthFromMaterial(((TieredBeltConnectorItem)pContext.m_43722_().m_41720_()).getBeltMaterial()) * 2)))) {
            tag.m_128473_("FirstPulley");
            pContext.m_43722_().m_41751_(tag);
        }
        if (!validAxis || player == null) {
            return InteractionResult.FAIL;
        }
        if (tag.m_128441_("FirstPulley")) {
            if (!TieredBeltConnectorItem.canConnect(level, firstPulley, pos, pContext.m_43722_())) {
                return InteractionResult.FAIL;
            }
            if (firstPulley != null && !firstPulley.equals((Object)pos)) {
                this.createBelts(level, firstPulley, pos);
                AllAdvancements.BELT.awardTo(player);
                if (!player.m_7500_()) {
                    pContext.m_43722_().m_41774_(1);
                }
            }
            if (!pContext.m_43722_().m_41619_()) {
                pContext.m_43722_().m_41751_(null);
                player.m_36335_().m_41524_((Item)this, 5);
            }
            return InteractionResult.SUCCESS;
        }
        tag.m_128365_("FirstPulley", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        pContext.m_43722_().m_41751_(tag);
        player.m_36335_().m_41524_((Item)this, 5);
        return InteractionResult.SUCCESS;
    }

    public void createBelts(Level level, BlockPos start, BlockPos end) {
        level.m_5594_(null, BlockPos.m_274446_((Position)VecHelper.getCenterOf((Vec3i)start.m_121955_((Vec3i)end)).m_82490_(0.5)), SoundEvents.f_12642_, SoundSource.BLOCKS, 0.5f, 1.0f);
        BeltSlope slope = TieredBeltConnectorItem.getSlopeBetween(start, end);
        Direction facing = TieredBeltConnectorItem.getFacingFromTo(start, end);
        BlockPos diff = end.m_121996_((Vec3i)start);
        if (diff.m_123341_() == diff.m_123343_()) {
            facing = Direction.m_122390_((Direction.AxisDirection)facing.m_122421_(), (Direction.Axis)(level.m_8055_(start).m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        List<BlockPos> beltsToCreate = TieredBeltConnectorItem.getBeltChainBetween(start, end, slope, facing);
        int tier = 0;
        boolean failed = false;
        for (BlockPos pos : beltsToCreate) {
            BlockState existingState = level.m_8055_(pos);
            if (existingState.m_60800_((BlockGetter)level, pos) == -1.0f) {
                failed = true;
                break;
            }
            BeltPart part = pos.equals((Object)start) ? BeltPart.START : (pos.equals((Object)end) ? BeltPart.END : BeltPart.MIDDLE);
            BlockState shaftState = level.m_8055_(pos);
            boolean pulley = shaftState.m_60734_() instanceof TieredShaftBlock;
            if (pulley) {
                tier = ((TieredShaftBlock)shaftState.m_60734_()).getTier();
            }
            BlockState state = Belts.BELTS[tier].getDefaultState();
            if (part == BeltPart.MIDDLE && pulley) {
                part = BeltPart.PULLEY;
            }
            if (pulley && shaftState.m_61143_((Property)AbstractShaftBlock.AXIS) == Direction.Axis.Y) {
                slope = BeltSlope.SIDEWAYS;
            }
            if (!existingState.m_247087_()) {
                level.m_46961_(pos, false);
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(BeltBlock.SLOPE, (Comparable)slope)).m_61124_(BeltBlock.PART, (Comparable)part)).m_61124_(BeltBlock.HORIZONTAL_FACING, (Comparable)facing)), (BlockPos)pos));
        }
        if (!failed) {
            return;
        }
        for (BlockPos pos : beltsToCreate) {
            BlockState state = Belts.BELTS[tier].getDefaultState();
            if (level.m_8055_(pos).m_60734_() != state.m_60734_()) continue;
            level.m_46961_(pos, false);
        }
    }

    private static Direction getFacingFromTo(BlockPos start, BlockPos end) {
        Direction.Axis beltAxis = start.m_123341_() == end.m_123341_() ? Direction.Axis.Z : Direction.Axis.X;
        BlockPos diff = end.m_121996_((Vec3i)start);
        Direction.AxisDirection dir = diff.m_123341_() == 0 && diff.m_123343_() == 0 ? (diff.m_123342_() > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE) : (beltAxis.m_7863_(diff.m_123341_(), 0, diff.m_123343_()) > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE);
        return Direction.m_122390_((Direction.AxisDirection)dir, (Direction.Axis)beltAxis);
    }

    private static BeltSlope getSlopeBetween(BlockPos start, BlockPos end) {
        BlockPos diff = end.m_121996_((Vec3i)start);
        if (diff.m_123342_() != 0) {
            if (diff.m_123343_() != 0 || diff.m_123341_() != 0) {
                return diff.m_123342_() > 0 ? BeltSlope.UPWARD : BeltSlope.DOWNWARD;
            }
            return BeltSlope.VERTICAL;
        }
        return BeltSlope.HORIZONTAL;
    }

    private static List<BlockPos> getBeltChainBetween(BlockPos start, BlockPos end, BeltSlope slope, Direction dir) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        int limit = 1000;
        BlockPos current = start;
        do {
            positions.add(current);
            if (slope == BeltSlope.VERTICAL) {
                current = current.m_6630_(dir.m_122421_() == Direction.AxisDirection.POSITIVE ? 1 : -1);
                continue;
            }
            current = current.m_121945_(dir);
            if (slope == BeltSlope.HORIZONTAL) continue;
            current = current.m_6630_(slope == BeltSlope.UPWARD ? 1 : -1);
        } while (!current.equals((Object)end) && limit-- > 0);
        positions.add(end);
        return positions;
    }

    public static boolean canConnect(Level level, BlockPos first, BlockPos second, ItemStack heldStack) {
        if (!level.m_46749_(first) || !level.m_46749_(second)) {
            return false;
        }
        Item item = heldStack.m_41720_();
        if (!(item instanceof TieredBeltConnectorItem)) {
            return false;
        }
        TieredBeltConnectorItem tbci = (TieredBeltConnectorItem)item;
        if (!second.m_123314_((Vec3i)first, (double)GConfigUtility.getBeltLengthFromMaterial(tbci.getBeltMaterial()))) {
            return false;
        }
        BlockPos diff = second.m_121996_((Vec3i)first);
        Direction.Axis shaftAxis = (Direction.Axis)level.m_8055_(first).m_61143_((Property)BlockStateProperties.f_61365_);
        int x = diff.m_123341_();
        int y = diff.m_123342_();
        int z = diff.m_123343_();
        int sames = (Math.abs(x) == Math.abs(y) ? 1 : 0) + (Math.abs(y) == Math.abs(z) ? 1 : 0) + (Math.abs(z) == Math.abs(x) ? 1 : 0);
        if (shaftAxis.m_7863_(x, y, z) != 0) {
            return false;
        }
        if (sames != 1) {
            return false;
        }
        if (shaftAxis != level.m_8055_(second).m_61143_((Property)BlockStateProperties.f_61365_)) {
            return false;
        }
        if (shaftAxis == Direction.Axis.Y && x != 0 && z != 0) {
            return false;
        }
        BlockEntity be = level.m_7702_(first);
        BlockEntity be2 = level.m_7702_(second);
        if (!(be instanceof TieredBracketedKineticBlockEntity)) {
            return false;
        }
        TieredBracketedKineticBlockEntity kbe = (TieredBracketedKineticBlockEntity)be;
        if (!(be2 instanceof TieredBracketedKineticBlockEntity)) {
            return false;
        }
        TieredBracketedKineticBlockEntity kbe2 = (TieredBracketedKineticBlockEntity)be2;
        if (level.m_8055_(first).m_60734_() != level.m_8055_(second).m_60734_()) {
            return false;
        }
        ArrayList shafts = new ArrayList();
        tbci.getValidShafts().forEach(s -> shafts.add((Block)s.get()));
        if (!shafts.contains(level.m_8055_(first).m_60734_())) {
            return false;
        }
        if (!shafts.contains(level.m_8055_(second).m_60734_())) {
            return false;
        }
        float speed = kbe.getTheoreticalSpeed();
        float speed2 = kbe2.getTheoreticalSpeed();
        if (Math.signum(speed) != Math.signum(speed2) && speed != 0.0f && speed2 != 0.0f) {
            return false;
        }
        BlockPos step = BlockPos.m_274561_((double)Math.signum(diff.m_123341_()), (double)Math.signum(diff.m_123342_()), (double)Math.signum(diff.m_123343_()));
        int limit = 1000;
        BlockPos pos = first.m_121955_((Vec3i)step);
        while (!pos.equals((Object)second) && limit-- > 0) {
            BlockState blockState = level.m_8055_(pos);
            if (blockState.m_60734_() instanceof TieredShaftBlock && blockState.m_61143_((Property)AbstractSimpleShaftBlock.AXIS) == shaftAxis ? level.m_8055_(first).m_60734_() != blockState.m_60734_() : !blockState.m_247087_()) {
                return false;
            }
            pos = pos.m_121955_((Vec3i)step);
        }
        return true;
    }

    public static boolean validateAxis(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        return level.m_8055_(pos).m_60734_() instanceof TieredShaftBlock;
    }

    @Override
    public Material getBeltMaterial() {
        return this.material;
    }

    @Override
    public void setBeltMaterial(Material material) {
        this.material = material;
    }

    public List<BlockEntry<TieredShaftBlock>> getValidShafts() {
        ArrayList<BlockEntry<TieredShaftBlock>> list = new ArrayList<BlockEntry<TieredShaftBlock>>();
        for (Material mat : this.validShafts) {
            list.add((BlockEntry<TieredShaftBlock>)((BlockEntry)Shafts.NEW_SHAFTS.get((Object)GreateTagPrefixes.shaft, (Object)mat)));
        }
        return list;
    }
}

