/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.fan;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.infrastructure.config.AllConfigs;
import electrolyte.greate.content.kinetics.fan.processing.GreateFanProcessingTypes;
import electrolyte.greate.infrastructure.config.GreateConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TieredFanProcessing {
    public static boolean canProcess(ItemEntity entity, FanProcessingType type, int machineTier) {
        CompoundTag compound;
        if (entity.getPersistentData().m_128441_("CreateData") && (compound = entity.getPersistentData().m_128469_("CreateData")).m_128441_("Processing")) {
            CompoundTag processing = compound.m_128469_("Processing");
            if (AllFanProcessingTypes.parseLegacy((String)processing.m_128461_("Type")) != type) {
                return type.canProcess(entity.m_32055_(), entity.m_9236_());
            }
            if (GreateFanProcessingTypes.parseLegacy(processing.m_128461_("Type")) != type) {
                if (type instanceof GreateFanProcessingTypes.TieredHauntingType) {
                    GreateFanProcessingTypes.TieredHauntingType th = (GreateFanProcessingTypes.TieredHauntingType)type;
                    return th.canProcess(entity.m_32055_(), entity.m_9236_(), machineTier);
                }
                if (type instanceof GreateFanProcessingTypes.TieredSplashingType) {
                    GreateFanProcessingTypes.TieredSplashingType ts = (GreateFanProcessingTypes.TieredSplashingType)type;
                    return ts.canProcess(entity.m_32055_(), entity.m_9236_(), machineTier);
                }
                return false;
            }
            if (processing.m_128451_("Time") >= 0) {
                return true;
            }
            if (processing.m_128451_("Time") == -1) {
                return false;
            }
        }
        if (type instanceof GreateFanProcessingTypes.TieredHauntingType) {
            GreateFanProcessingTypes.TieredHauntingType th = (GreateFanProcessingTypes.TieredHauntingType)type;
            return th.canProcess(entity.m_32055_(), entity.m_9236_(), machineTier);
        }
        if (type instanceof GreateFanProcessingTypes.TieredSplashingType) {
            GreateFanProcessingTypes.TieredSplashingType ts = (GreateFanProcessingTypes.TieredSplashingType)type;
            return ts.canProcess(entity.m_32055_(), entity.m_9236_(), machineTier);
        }
        return type.canProcess(entity.m_32055_(), entity.m_9236_());
    }

    public static boolean applyProcessing(float speed, ItemEntity entity, FanProcessingType type, int machineTier) {
        List<ItemStack> stacks;
        if (TieredFanProcessing.decrementProcessingTime(speed, entity, type) != 0) {
            return false;
        }
        if (type instanceof GreateFanProcessingTypes.TieredHauntingType) {
            GreateFanProcessingTypes.TieredHauntingType th = (GreateFanProcessingTypes.TieredHauntingType)type;
            stacks = th.process(entity.m_32055_(), entity.m_9236_(), machineTier);
        } else if (type instanceof GreateFanProcessingTypes.TieredSplashingType) {
            GreateFanProcessingTypes.TieredSplashingType ts = (GreateFanProcessingTypes.TieredSplashingType)type;
            stacks = ts.process(entity.m_32055_(), entity.m_9236_(), machineTier);
        } else {
            stacks = type.process(entity.m_32055_(), entity.m_9236_());
        }
        if (stacks == null) {
            return false;
        }
        if (stacks.isEmpty()) {
            entity.m_146870_();
            return false;
        }
        entity.m_32045_(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), additional);
            entityIn.m_20256_(entityIn.m_20184_());
            entity.m_9236_().m_7967_((Entity)entityIn);
        }
        return true;
    }

    public static TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(float speed, TransportedItemStack transported, Level level, FanProcessingType type, int machineTier) {
        List<ItemStack> stacks;
        TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            transported.processedBy = type;
            transported.processingTime = TieredFanProcessing.getProcessingTime(transported.stack.m_41613_(), speed);
            if (type instanceof GreateFanProcessingTypes.TieredHauntingType) {
                GreateFanProcessingTypes.TieredHauntingType tht = (GreateFanProcessingTypes.TieredHauntingType)type;
                if (!tht.canProcess(transported.stack, level, machineTier)) {
                    transported.processingTime = -1;
                }
            } else if (type instanceof GreateFanProcessingTypes.TieredSplashingType) {
                GreateFanProcessingTypes.TieredSplashingType tst = (GreateFanProcessingTypes.TieredSplashingType)type;
                if (!tst.canProcess(transported.stack, level, machineTier)) {
                    transported.processingTime = -1;
                }
            } else if (!type.canProcess(transported.stack, level)) {
                transported.processingTime = -1;
            }
            return ignore;
        }
        if (transported.processingTime == -1) {
            return ignore;
        }
        if (transported.processingTime-- > 0) {
            return ignore;
        }
        if (type instanceof GreateFanProcessingTypes.TieredHauntingType) {
            GreateFanProcessingTypes.TieredHauntingType th = (GreateFanProcessingTypes.TieredHauntingType)type;
            stacks = th.process(transported.stack, level, machineTier);
        } else if (type instanceof GreateFanProcessingTypes.TieredSplashingType) {
            GreateFanProcessingTypes.TieredSplashingType ts = (GreateFanProcessingTypes.TieredSplashingType)type;
            stacks = ts.process(transported.stack, level, machineTier);
        } else {
            stacks = type.process(transported.stack, level);
        }
        if (stacks == null) {
            return ignore;
        }
        ArrayList<TransportedItemStack> transportedItemStacks = new ArrayList<TransportedItemStack>();
        for (ItemStack additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.m_41777_();
            transportedItemStacks.add(newTransported);
        }
        return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedItemStacks);
    }

    private static int decrementProcessingTime(float speed, ItemEntity entity, FanProcessingType type) {
        CompoundTag processing;
        CompoundTag createData;
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_("CreateData")) {
            nbt.m_128365_("CreateData", (Tag)new CompoundTag());
        }
        if (!(createData = nbt.m_128469_("CreateData")).m_128441_("Processing")) {
            createData.m_128365_("Processing", (Tag)new CompoundTag());
        }
        if (!(processing = createData.m_128469_("Processing")).m_128441_("Type") || AllFanProcessingTypes.parseLegacy((String)processing.m_128461_("Type")) != type && GreateFanProcessingTypes.parseLegacy(processing.m_128461_("Type")) != type) {
            ResourceLocation key = CreateBuiltInRegistries.FAN_PROCESSING_TYPE.m_7981_((Object)type);
            if (key == null) {
                throw new IllegalArgumentException("Could not get id for FanProcessingType " + String.valueOf(type) + "!");
            }
            processing.m_128359_("Type", key.toString());
            int processingTime = TieredFanProcessing.getProcessingTime(entity.m_32055_().m_41613_(), speed);
            processing.m_128405_("Time", processingTime);
        }
        int value = processing.m_128451_("Time") - 1;
        processing.m_128405_("Time", value);
        return value;
    }

    private static int getProcessingTime(int entityCount, float speed) {
        int timeModifierForStackSize = (entityCount - 1) / 16 + 1;
        int timeModifierForSpeed = (int)Math.max(0.0, (double)speed * (Double)GreateConfigs.server().kinetics.fanSpeedMultiplier.get());
        return Math.max(1, ((Integer)AllConfigs.server().kinetics.fanProcessingTime.get() - timeModifierForSpeed) * timeModifierForStackSize + 1);
    }
}

