/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.fan.processing;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import electrolyte.greate.Greate;
import electrolyte.greate.content.kinetics.fan.processing.TieredHauntingRecipe;
import electrolyte.greate.content.kinetics.fan.processing.TieredSplashingRecipe;
import electrolyte.greate.foundation.recipe.TieredRecipeApplier;
import electrolyte.greate.registry.ModRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GreateFanProcessingTypes {
    public static final TieredHauntingType TIERED_HAUNTING = GreateFanProcessingTypes.register("haunting", new TieredHauntingType());
    public static final TieredSplashingType TIERED_SPLASHING = GreateFanProcessingTypes.register("splashing", new TieredSplashingType());
    private static final Map<String, FanProcessingType> LEGACY_NAME_MAP;

    private static <T extends FanProcessingType> T register(String id, T type) {
        return (T)((FanProcessingType)Registry.m_122965_((Registry)CreateBuiltInRegistries.FAN_PROCESSING_TYPE, (ResourceLocation)Greate.id(id), type));
    }

    @Nullable
    public static FanProcessingType ofLegacyName(String name) {
        return LEGACY_NAME_MAP.get(name);
    }

    public static FanProcessingType parseLegacy(String name) {
        FanProcessingType type = GreateFanProcessingTypes.ofLegacyName(name);
        if (type != null) {
            return type;
        }
        return FanProcessingType.parse((String)name);
    }

    public static void register() {
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"TIERED_HAUNTING", (Object)TIERED_HAUNTING);
        map.put((Object)"TIERED_SPLASHING", (Object)TIERED_SPLASHING);
        map.trim();
        LEGACY_NAME_MAP = map;
    }

    public static class TieredHauntingType
    extends AllFanProcessingTypes.HauntingType {
        private static final TieredHauntingRecipe.TieredHauntingWrapper TIERED_HAUNTING_WRAPPER = new TieredHauntingRecipe.TieredHauntingWrapper();

        public int getPriority() {
            return 350;
        }

        public boolean canProcess(ItemStack stack, Level level, int machineTier) {
            if (super.canProcess(stack, level)) {
                return true;
            }
            TIERED_HAUNTING_WRAPPER.m_6836_(0, stack);
            Optional tieredRecipe = ModRecipeTypes.HAUNTING.find(TIERED_HAUNTING_WRAPPER, level, machineTier);
            return tieredRecipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level, int machineTier) {
            List result = super.process(stack, level);
            if (result != null) {
                return result;
            }
            TIERED_HAUNTING_WRAPPER.m_6836_(0, stack);
            Optional<TieredHauntingRecipe> tieredRecipe = ModRecipeTypes.HAUNTING.find(TIERED_HAUNTING_WRAPPER, level, machineTier);
            return tieredRecipe.map(tieredHauntingRecipe -> TieredRecipeApplier.applyRecipeOn(level, stack, tieredHauntingRecipe, machineTier)).orElse(null);
        }
    }

    public static class TieredSplashingType
    extends AllFanProcessingTypes.SplashingType {
        private static final TieredSplashingRecipe.TieredSplashingWrapper TIERED_SPLASHING_WRAPPER = new TieredSplashingRecipe.TieredSplashingWrapper();

        public int getPriority() {
            return 450;
        }

        public boolean canProcess(ItemStack stack, Level level, int machineTier) {
            if (super.canProcess(stack, level)) {
                return true;
            }
            TIERED_SPLASHING_WRAPPER.m_6836_(0, stack);
            Optional tieredRecipe = ModRecipeTypes.SPLASHING.find(TIERED_SPLASHING_WRAPPER, level, machineTier);
            return tieredRecipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level, int machineTier) {
            List result = super.process(stack, level);
            if (result != null) {
                return result;
            }
            TIERED_SPLASHING_WRAPPER.m_6836_(0, stack);
            Optional<TieredSplashingRecipe> tieredRecipe = ModRecipeTypes.SPLASHING.find(TIERED_SPLASHING_WRAPPER, level, machineTier);
            return tieredRecipe.map(tieredSplashingRecipe -> TieredRecipeApplier.applyRecipeOn(level, stack, tieredSplashingRecipe, machineTier)).orElse(null);
        }
    }
}

