/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.mixer;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.fluids.potion.PotionMixingRecipes;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.infrastructure.config.AllConfigs;
import electrolyte.greate.content.kinetics.base.ICircuitHolder;
import electrolyte.greate.content.kinetics.mixer.TieredMechanicalMixerBlock;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredKineticBlockEntity;
import electrolyte.greate.content.processing.basin.TieredBasinRecipe;
import electrolyte.greate.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.items.IItemHandler;

public class TieredMechanicalMixerBlockEntity
extends MechanicalMixerBlockEntity
implements ITieredKineticBlockEntity,
ICircuitHolder {
    private int tier;
    private ScrollValueBehaviour targetCircuit;
    private static final Object SHAPELESS_OR_MIXING_RECIPES_KEY = new Object();

    public TieredMechanicalMixerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tier = ((TieredMechanicalMixerBlock)state.m_60734_()).getTier();
    }

    public void tick() {
        if (this.getSpeed() == 0.0f) {
            this.running = false;
        }
        super.tick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        super.tickAudio();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.targetCircuit = new ScrollValueBehaviour((Component)Lang.builder((String)"greate").translate("tooltip.circuit_number", new Object[0]).component(), (SmartBlockEntity)this, (ValueBoxTransform)new CircuitValueBoxTransform());
        this.targetCircuit.between(0, 32);
        behaviours.add((BlockEntityBehaviour)this.targetCircuit);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return ITieredKineticBlockEntity.super.addToGoggleTooltip(tooltip, isPlayerSneaking, this.tier, this.capacity, this.stress);
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> r) {
        return r instanceof CraftingRecipe && !(r instanceof IShapedRecipe) && (Boolean)AllConfigs.server().recipes.allowShapelessInMixer.get() != false && r.m_7527_().size() > 1 && !MechanicalPressBlockEntity.canCompress(r) && !AllRecipeTypes.shouldIgnoreInAutomation(r) || r.m_6671_() == ModRecipeTypes.MIXING.getType() || (Boolean)AllConfigs.server().recipes.allowBrewingInMixer.get() != false && r.m_6671_() == ModRecipeTypes.BREWING.getType();
    }

    protected Object getRecipeCacheKey() {
        return SHAPELESS_OR_MIXING_RECIPES_KEY;
    }

    @Override
    public int getCircuitNumber() {
        return this.targetCircuit.getValue();
    }

    protected void applyBasinRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        Optional optionalBasin = this.getBasin();
        if (!optionalBasin.isPresent()) {
            return;
        }
        BasinBlockEntity basin = (BasinBlockEntity)optionalBasin.get();
        boolean wasEmpty = basin.canContinueProcessing();
        if (!TieredBasinRecipe.apply(basin, this.currentRecipe)) {
            return;
        }
        this.getProcessedRecipeTrigger().ifPresent(arg_0 -> ((TieredMechanicalMixerBlockEntity)this).award(arg_0));
        basin.inputTank.sendDataImmediately();
        if (wasEmpty && this.matchBasinRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        basin.notifyChangeOfContents();
    }

    public int getTier() {
        return this.tier;
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        List<Object> matchingRecipes = new ArrayList();
        if (this.getBasin().map(BasinBlockEntity::isEmpty).orElse(true).booleanValue()) {
            return matchingRecipes;
        }
        List recipes = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, this::matchStaticFilters);
        matchingRecipes = recipes.stream().filter(this::matchBasinRecipe).sorted((r1, r2) -> r2.m_7527_().size() - r1.m_7527_().size()).collect(Collectors.toList());
        if (!((Boolean)AllConfigs.server().recipes.allowBrewingInMixer.get()).booleanValue()) {
            return matchingRecipes;
        }
        Optional basin = this.getBasin();
        if (!basin.isPresent()) {
            return matchingRecipes;
        }
        BasinBlockEntity basinBlockEntity = (BasinBlockEntity)basin.get();
        if (basin.isEmpty()) {
            return matchingRecipes;
        }
        IItemHandler availableItems = (IItemHandler)basinBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (availableItems == null) {
            return matchingRecipes;
        }
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            List list;
            ItemStack stack = availableItems.getStackInSlot(i);
            if (stack.m_41619_() || (list = (List)PotionMixingRecipes.BY_ITEM.get(stack.m_41720_())) == null) continue;
            for (MixingRecipe mixingRecipe : list) {
                if (!this.matchBasinRecipe((Recipe)mixingRecipe)) continue;
                matchingRecipes.add(mixingRecipe);
            }
        }
        return matchingRecipes;
    }

    protected <C extends Container> boolean matchBasinRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional basin = this.getBasin();
        return basin.filter(basinBlockEntity -> TieredBasinRecipe.match(basinBlockEntity, recipe, this.tier)).isPresent();
    }

    private class CircuitValueBoxTransform
    extends ValueBoxTransform.Sided {
        private CircuitValueBoxTransform() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)12.0, (double)15.8f);
        }

        public float getScale() {
            return 0.25f;
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return !direction.m_122434_().m_122478_();
        }
    }
}

