/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.press;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import electrolyte.greate.content.kinetics.base.ICircuitHolder;
import electrolyte.greate.content.kinetics.press.TieredMechanicalPressBlock;
import electrolyte.greate.content.kinetics.press.TieredPressingRecipe;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredKineticBlockEntity;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredProcessingRecipeHolder;
import electrolyte.greate.content.processing.basin.TieredBasinRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.foundation.data.recipe.TieredRecipeConditions;
import electrolyte.greate.foundation.recipe.TieredRecipeApplier;
import electrolyte.greate.foundation.recipe.TieredRecipeFinder;
import electrolyte.greate.registry.ModRecipeTypes;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TieredMechanicalPressBlockEntity
extends MechanicalPressBlockEntity
implements ITieredKineticBlockEntity,
ITieredProcessingRecipeHolder,
ICircuitHolder {
    private int tier;
    private ScrollValueBehaviour targetCircuit;
    private static final Object PRESSING_RECIPE_CACHE_KEY = new Object();
    private static final RecipeWrapper pressingInv = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public TieredMechanicalPressBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tier = ((TieredMechanicalPressBlock)state.m_60734_()).getTier();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.targetCircuit = new ScrollValueBehaviour((Component)Lang.builder((String)"greate").translate("tooltip.circuit_number", new Object[0]).component(), (SmartBlockEntity)this, (ValueBoxTransform)new CircuitValueBoxTransform());
        this.targetCircuit.between(0, 32);
        behaviours.add((BlockEntityBehaviour)this.targetCircuit);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return ITieredKineticBlockEntity.super.addToGoggleTooltip(tooltip, isPlayerSneaking, this.tier, this.capacity, this.stress);
    }

    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        ItemStack stack = itemEntity.m_32055_();
        Optional<Recipe<?>> recipe = this.getValidRecipe(stack);
        if (recipe.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        ItemStack createdStack = ItemStack.f_41583_;
        this.pressingBehaviour.particleItems.add(stack);
        if (this.canProcessInBulk() || stack.m_41613_() == 1) {
            TieredRecipeApplier.applyRecipeOn(itemEntity, recipe.get(), this.tier);
            createdStack = itemEntity.m_32055_().m_41777_();
        } else {
            for (ItemStack result : TieredRecipeApplier.applyRecipeOn(this.f_58857_, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1), recipe.get(), this.tier)) {
                if (createdStack.m_41619_()) {
                    createdStack = result.m_41777_();
                }
                ItemEntity createdEntityStack = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result);
                createdEntityStack.m_32060_();
                createdEntityStack.m_20256_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.05f));
                this.f_58857_.m_7967_((Entity)createdEntityStack);
            }
            if (recipe.get() instanceof TieredProcessingRecipe) {
                stack.m_41774_(((Ingredient)recipe.get().m_7527_().get(0)).m_43908_()[0].m_41613_());
            } else {
                stack.m_41774_(1);
            }
        }
        if (!createdStack.m_41619_()) {
            this.onItemPressed(createdStack);
        }
        return true;
    }

    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        Optional<Recipe<?>> recipe = this.getValidRecipe(input.stack);
        if (recipe.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.pressingBehaviour.particleItems.add(input.stack);
        List<ItemStack> outputStacks = TieredRecipeApplier.applyRecipeOn(this.f_58857_, this.canProcessInBulk() ? input.stack : ItemHandlerHelper.copyStackWithSize((ItemStack)input.stack, (int)1), recipe.get(), this.tier);
        for (ItemStack stack : outputStacks) {
            if (stack.m_41619_()) continue;
            this.onItemPressed(stack);
            break;
        }
        outputList.addAll(outputStacks);
        return true;
    }

    public Optional<? extends Recipe<?>> getValidRecipe(ItemStack stack) {
        Predicate<Recipe<?>> predicate;
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)stack, (RecipeType)AllRecipeTypes.PRESSING.getType(), PressingRecipe.class);
        Optional tieredAssemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)stack, ModRecipeTypes.PRESSING.getType(), TieredPressingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            this.currentRecipe = (Recipe)assemblyRecipe.get();
            return assemblyRecipe;
        }
        if (tieredAssemblyRecipe.isPresent() && (predicate = TieredRecipeConditions.isEqualOrAboveTier(this.tier).and(TieredRecipeConditions.circuitMatches(this.targetCircuit.getValue()))).test((Recipe)tieredAssemblyRecipe.get())) {
            this.currentRecipe = (Recipe)tieredAssemblyRecipe.get();
            return tieredAssemblyRecipe;
        }
        pressingInv.m_6836_(0, stack);
        Optional<Recipe<?>> recipe = TieredRecipeFinder.findRecipe(PRESSING_RECIPE_CACHE_KEY, this.f_58857_, pressingInv, RecipeConditions.isOfType((RecipeType[])new RecipeType[]{ModRecipeTypes.PRESSING.getType()}).and(TieredRecipeConditions.firstIngredientMatches(stack)), TieredRecipeConditions.isEqualOrAboveTier(this.tier).and(TieredRecipeConditions.circuitMatches(this.targetCircuit.getValue())).and(TieredRecipeConditions.firstIngredientCountMatches(stack)));
        if (recipe.isPresent()) {
            this.currentRecipe = recipe.get();
            return recipe;
        }
        return Optional.empty();
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe instanceof CraftingRecipe && !(recipe instanceof MechanicalCraftingRecipe) && TieredMechanicalPressBlockEntity.canCompress(recipe) && !AllRecipeTypes.shouldIgnoreInAutomation(recipe) || recipe.m_6671_() == ModRecipeTypes.COMPACTING.getType();
    }

    @Override
    public Recipe<?> getRecipe() {
        return this.currentRecipe;
    }

    @Override
    public int getCircuitNumber() {
        return this.targetCircuit.getValue();
    }

    protected void applyBasinRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        Optional optionalBasin = this.getBasin();
        if (!optionalBasin.isPresent()) {
            return;
        }
        BasinBlockEntity basin = (BasinBlockEntity)optionalBasin.get();
        boolean wasEmpty = basin.canContinueProcessing();
        if (!TieredBasinRecipe.apply(basin, this.currentRecipe)) {
            return;
        }
        this.getProcessedRecipeTrigger().ifPresent(arg_0 -> ((TieredMechanicalPressBlockEntity)this).award(arg_0));
        basin.inputTank.sendDataImmediately();
        if (wasEmpty && this.matchBasinRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        basin.notifyChangeOfContents();
    }

    protected <C extends Container> boolean matchBasinRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        if (!(recipe instanceof TieredProcessingRecipe) && !(recipe instanceof CraftingRecipe)) {
            return false;
        }
        Optional basin = this.getBasin();
        return basin.filter(basinBlockEntity -> TieredBasinRecipe.match(basinBlockEntity, recipe, this.tier)).isPresent();
    }

    public int getTier() {
        return this.tier;
    }

    private class CircuitValueBoxTransform
    extends ValueBoxTransform.Sided {
        private CircuitValueBoxTransform() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)9.0, (double)15.5);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            if (direction.m_122434_().m_122478_()) {
                return false;
            }
            return !((TieredMechanicalPressBlock)state.m_60734_()).hasShaftTowards((LevelReader)TieredMechanicalPressBlockEntity.this.f_58857_, TieredMechanicalPressBlockEntity.this.m_58899_(), state, direction);
        }
    }
}

