/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.saw;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredBlock;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredShaftBlock;
import electrolyte.greate.registry.GreateTagPrefixes;
import electrolyte.greate.registry.ModBlockEntityTypes;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TieredSawBlock
extends SawBlock
implements ITieredBlock,
ITieredShaftBlock {
    private int tier;
    private Supplier<Block> shaftBlock = () -> ChemicalHelper.getBlock((TagPrefix)GreateTagPrefixes.shaft, (Material)mat);
    private static final int PLACEMENT_HELPER_ID = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public TieredSawBlock(BlockBehaviour.Properties properties, Material mat) {
        super(properties);
    }

    public BlockEntityType<? extends SawBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntityTypes.TIERED_SAW.get();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }

    @Override
    public Block getShaft() {
        return this.shaftBlock.get();
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)PLACEMENT_HELPER_ID);
        if (!player.m_6144_() && player.m_36326_() && placementHelper.matchesItem(heldItem) && placementHelper.getOffset(player, worldIn, state, pos, hit).placeInWorld(worldIn, (BlockItem)heldItem.m_41720_(), player, handIn, hit).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.PASS;
        }
        if (state.m_61145_((Property)FACING).orElse(Direction.WEST) != Direction.UP) {
            return InteractionResult.PASS;
        }
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            if (!heldItem.m_41619_()) {
                if (FluidHelper.tryEmptyItemIntoBE((Level)worldIn, (Player)player, (InteractionHand)handIn, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                    player.m_216990_(SoundEvents.f_11778_);
                    return InteractionResult.SUCCESS;
                }
                if (FluidHelper.tryFillItemFromBE((Level)worldIn, (Player)player, (InteractionHand)handIn, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                    player.m_216990_(SoundEvents.f_11781_);
                    return InteractionResult.SUCCESS;
                }
                if (GenericItemEmptying.canItemBeEmptied((Level)worldIn, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)worldIn, (ItemStack)heldItem)) {
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_41720_().equals(Items.f_41902_) && !be.getCapability(ForgeCapabilities.FLUID_HANDLER).map(fh -> fh.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY).isEmpty()) {
                    player.m_216990_(SoundEvents.f_11769_);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            for (int i = 0; i < be.inventory.getSlots(); ++i) {
                ItemStack heldItemStack = be.inventory.getStackInSlot(i);
                if (worldIn.f_46443_ || heldItemStack.m_41619_()) continue;
                player.m_150109_().m_150079_(heldItemStack);
            }
            be.inventory.clear();
            be.notifyUpdate();
            return InteractionResult.SUCCESS;
        });
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof TieredSawBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof TieredSawBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List dirs = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)((Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_(), d -> world.m_8055_(pos.m_121945_(d)).m_247087_());
            if (dirs.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)dirs.get(0)), s -> (BlockState)((BlockState)((BlockState)s.m_61124_((Property)DirectionalKineticBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING)))).m_61124_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE, (Comparable)((Boolean)state.m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)))).m_61124_((Property)SawBlock.FLIPPED, (Comparable)((Boolean)state.m_61143_((Property)SawBlock.FLIPPED))));
        }
    }
}

