/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.saw;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import electrolyte.greate.content.kinetics.saw.TieredCuttingRecipe;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredBlock;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredKineticBlockEntity;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.foundation.data.recipe.TieredRecipeConditions;
import electrolyte.greate.mixin.MixinSawBlockEntityAccessor;
import electrolyte.greate.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TieredSawBlockEntity
extends SawBlockEntity
implements ITieredKineticBlockEntity {
    private int tier;
    private SmartFluidTankBehaviour inputTank;
    private LazyOptional<IFluidHandler> fluidCapability;

    public TieredSawBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tier = ((ITieredBlock)state.m_60734_()).getTier();
        this.inventory = new ProcessingInventory(this::start);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 16000, false);
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputTank.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)inputCap.orElse(null)});
        });
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        ITieredKineticBlockEntity.super.addToGoggleTooltip(tooltip, isPlayerSneaking, this.tier, this.capacity, this.stress);
        if (this.canProcess()) {
            IFluidHandler fluid = (IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0));
            LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
            FluidStack fluidStack = fluid.getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                Lang.builder((String)"greate").translate("gui.goggles.saw_contents", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
                CreateLang.text((String)"").add(CreateLang.fluidName((FluidStack)fluidStack).add(CreateLang.text((String)" ")).style(ChatFormatting.GRAY).add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            } else {
                tooltip.remove(0);
            }
        }
        return true;
    }

    public void invalidate() {
        super.invalidate();
        if (this.fluidCapability != null) {
            this.fluidCapability.invalidate();
        }
    }

    public List<Recipe<?>> getValidRecipes() {
        Predicate<Recipe<?>> predicate;
        TieredSawBlockEntity be = (TieredSawBlockEntity)this.f_58857_.m_7702_(this.m_58899_());
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inventory.getStackInSlot(0), (RecipeType)AllRecipeTypes.CUTTING.getType(), CuttingRecipe.class);
        Optional tieredAssemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inventory.getStackInSlot(0), ModRecipeTypes.CUTTING.getType(), TieredCuttingRecipe.class);
        FilteringBehaviour filtering = ((MixinSawBlockEntityAccessor)((Object)this)).getFilteringBehaviour();
        Object cuttingRecipesKey = ((MixinSawBlockEntityAccessor)((Object)this)).getCuttingRecipesKey();
        if (assemblyRecipe.isPresent() && filtering.test(((CuttingRecipe)assemblyRecipe.get()).m_8043_(this.f_58857_.m_9598_()))) {
            return ImmutableList.of((Object)((Recipe)assemblyRecipe.get()));
        }
        if (tieredAssemblyRecipe.isPresent() && filtering.test(((TieredCuttingRecipe)((Object)tieredAssemblyRecipe.get())).m_8043_(this.f_58857_.m_9598_())) && (predicate = TieredRecipeConditions.isEqualOrAboveTier(this.tier)).test((Recipe)tieredAssemblyRecipe.get())) {
            return ImmutableList.of((Object)((Recipe)tieredAssemblyRecipe.get()));
        }
        Predicate recipeTypes = RecipeConditions.isOfType((RecipeType[])new RecipeType[]{AllRecipeTypes.CUTTING.getType(), ModRecipeTypes.CUTTING.getType(), (Boolean)AllConfigs.server().recipes.allowStonecuttingOnSaw.get() != false ? RecipeType.f_44112_ : null});
        List startedSearch = RecipeFinder.get((Object)cuttingRecipesKey, (Level)this.f_58857_, (Predicate)recipeTypes);
        IFluidHandler availableFluid = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableFluid == null) {
            return List.of();
        }
        return startedSearch.stream().filter(TieredRecipeConditions.outputMatchesFilter(filtering)).filter(TieredRecipeConditions.firstIngredientMatches(this.inventory.getStackInSlot(0))).filter(TieredRecipeConditions.firstIngredientCountMatches(this.inventory.getStackInSlot(0))).filter(TieredRecipeConditions.firstFluidMatches(availableFluid.getFluidInTank(0))).filter(TieredRecipeConditions.isEqualOrAboveTier(this.tier)).filter(r -> !AllRecipeTypes.shouldIgnoreInAutomation((Recipe)r)).filter(r -> !ModRecipeTypes.shouldIgnoreInAutomation(r)).collect(Collectors.toList());
    }

    public void applyValidRecipe() {
        IFluidHandler availableFluid;
        ItemStack input = this.inventory.getStackInSlot(0);
        ArrayList list = new ArrayList();
        if (PackageItem.isPackage((ItemStack)input)) {
            this.inventory.clear();
            ItemStackHandler results = PackageItem.getContents((ItemStack)input);
            for (int i = 0; i < results.getSlots(); ++i) {
                ItemStack stack = results.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemHelper.addToList((ItemStack)stack, list);
            }
            for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
                this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
            }
            return;
        }
        List<Recipe<?>> recipes = this.getValidRecipes();
        int recipeIndex = ((MixinSawBlockEntityAccessor)((Object)this)).getRecipeIndex();
        if (recipes.isEmpty()) {
            return;
        }
        if (recipeIndex >= recipes.size()) {
            recipeIndex = 0;
        }
        Recipe<?> recipe = recipes.get(recipeIndex);
        int rolls = this.inventory.getStackInSlot(0).m_41613_();
        int requiredAmount = 1;
        if (recipe instanceof TieredProcessingRecipe) {
            TieredProcessingRecipe tpr = (TieredProcessingRecipe)recipe;
            requiredAmount = ((Ingredient)tpr.m_7527_().get(0)).m_43908_()[0].m_41613_();
            rolls /= requiredAmount;
        }
        if ((availableFluid = (IFluidHandler)this.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null)) == null) {
            return;
        }
        if (recipe instanceof TieredProcessingRecipe) {
            TieredProcessingRecipe tpr = (TieredProcessingRecipe)recipe;
            this.inventory.setStackInSlot(0, input.m_255036_(input.m_41613_() - rolls * requiredAmount));
        } else {
            this.inventory.clear();
        }
        for (int roll = 0; roll < rolls; ++roll) {
            List results = new LinkedList<ItemStack>();
            if (recipe instanceof ProcessingRecipe) {
                ProcessingRecipe pr = (ProcessingRecipe)recipe;
                results = pr.rollResults();
                if (!pr.getFluidIngredients().isEmpty()) {
                    availableFluid.drain(((FluidIngredient)pr.getFluidIngredients().get(0)).getRequiredAmount(), IFluidHandler.FluidAction.EXECUTE);
                }
            } else if (recipe instanceof StonecutterRecipe || recipe.m_6671_() == woodcuttingRecipeType.get()) {
                results.add(recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_());
            }
            for (ItemStack stack : results) {
                ItemHelper.addToList((ItemStack)stack, list);
            }
        }
        for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
            this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
        }
        this.award(AllAdvancements.SAW_PROCESSING);
    }

    public void start(ItemStack inserted) {
        Recipe<?> recipe;
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.isEmpty()) {
            return;
        }
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        List<Recipe<?>> recipes = this.getValidRecipes();
        boolean valid = !recipes.isEmpty();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        int recipeIndex = ((MixinSawBlockEntityAccessor)((Object)this)).getRecipeIndex();
        if (valid && ++recipeIndex >= recipes.size()) {
            ((MixinSawBlockEntityAccessor)((Object)this)).setRecipeIndex(0);
        }
        if ((recipe = recipes.get(((MixinSawBlockEntityAccessor)((Object)this)).getRecipeIndex())) instanceof ProcessingRecipe) {
            ProcessingRecipe pr = (ProcessingRecipe)recipe;
            time = pr.getProcessingDuration();
        }
        int timePer = inserted.m_41613_();
        if (recipe instanceof TieredProcessingRecipe) {
            TieredProcessingRecipe tpr = (TieredProcessingRecipe)recipe;
            timePer /= ((Ingredient)tpr.m_7527_().get(0)).m_43908_()[0].m_41613_();
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, timePer / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != Direction.DOWN) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

