/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.simpleRelays;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlock;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.placement.PoleHelper;
import electrolyte.greate.content.decoration.encasing.IGirderEncasableBlock;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredBlock;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredShaftBlock;
import electrolyte.greate.content.kinetics.steamEngine.TieredPoweredShaftBlock;
import electrolyte.greate.registry.GreateTagPrefixes;
import electrolyte.greate.registry.ModBlockEntityTypes;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TieredShaftBlock
extends ShaftBlock
implements ITieredBlock,
ITieredShaftBlock,
IGirderEncasableBlock {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    private int tier;
    private Material material;

    public TieredShaftBlock(BlockBehaviour.Properties properties, Material material) {
        super(properties);
        this.material = material;
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntityTypes.TIERED_BRACKETED_KINETIC.get();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        return this.pickShaftType(stateForPlacement, context.m_43725_(), context.m_8083_());
    }

    public BlockState pickShaftType(BlockState stateForPlacement, Level level, BlockPos offsetPos) {
        return PoweredShaftBlock.stillValid((BlockState)stateForPlacement, (LevelReader)level, (BlockPos)offsetPos) ? (BlockState)((BlockState)ChemicalHelper.getBlock((TagPrefix)GreateTagPrefixes.poweredShaft, (Material)this.material).m_49966_().m_61124_((Property)PoweredShaftBlock.AXIS, (Comparable)((Direction.Axis)stateForPlacement.m_61143_((Property)ShaftBlock.AXIS)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)stateForPlacement.m_61143_((Property)WATERLOGGED))) : stateForPlacement;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_6144_() || !pPlayer.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        InteractionResult resultEncase = this.tryEncase(pState, pLevel, pPos, heldItem, pPlayer, pHand, pHit);
        InteractionResult resultGirderEncase = this.tryGirderEncase(pState, pLevel, pPos, heldItem, pPlayer, pHand, pHit);
        if (resultEncase.m_19077_()) {
            return resultEncase;
        }
        if (resultGirderEncase.m_19077_()) {
            return resultGirderEncase;
        }
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (Block.m_49814_((Item)heldItem.m_41720_()) == pState.m_60734_()) {
            return helper.getOffset(pPlayer, pLevel, pState, pPos, pHit).placeInWorld(pLevel, (BlockItem)heldItem.m_41720_(), pPlayer, pHand, pHit);
        }
        return InteractionResult.PASS;
    }

    @Override
    public Block getShaft() {
        return this;
    }

    public Material getMaterial() {
        return this.material;
    }

    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super(state -> state.m_60734_() instanceof AbstractSimpleShaftBlock || state.m_60734_() instanceof TieredPoweredShaftBlock, state -> (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS), (Property)RotatedPillarKineticBlock.AXIS);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof AbstractSimpleShaftBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return ((Predicate<BlockState>)this::checkBlock).or(this::checkBlockPowered);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            ItemStack shaft = player.m_21205_();
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(stateForPlacement -> PoweredShaftBlock.stillValid((BlockState)stateForPlacement, (LevelReader)world, (BlockPos)offset.getBlockPos()) ? (BlockState)((BlockState)ChemicalHelper.getBlock((TagPrefix)GreateTagPrefixes.poweredShaft, (Material)ChemicalHelper.getMaterialEntry((ItemLike)shaft.m_41720_()).material()).m_49966_().m_61124_((Property)PoweredShaftBlock.AXIS, (Comparable)((Direction.Axis)stateForPlacement.m_61143_((Property)ShaftBlock.AXIS)))).m_61124_((Property)ProperWaterloggedBlock.WATERLOGGED, (Comparable)((Boolean)stateForPlacement.m_61143_((Property)ProperWaterloggedBlock.WATERLOGGED))) : stateForPlacement));
            }
            return offset;
        }

        private boolean checkBlock(BlockState state) {
            return state.m_60734_() instanceof TieredShaftBlock;
        }

        private boolean checkBlockPowered(BlockState state) {
            return state.m_60734_() instanceof TieredPoweredShaftBlock;
        }
    }
}

