/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.steamEngine;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlock;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredBlock;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredShaftBlock;
import electrolyte.greate.content.kinetics.simpleRelays.TieredShaftBlock;
import electrolyte.greate.registry.GreateTagPrefixes;
import electrolyte.greate.registry.ModBlockEntityTypes;
import java.util.function.Supplier;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TieredPoweredShaftBlock
extends PoweredShaftBlock
implements ITieredBlock,
ITieredShaftBlock {
    private int tier;
    private Supplier<Block> shaftType;
    private Material material;

    public TieredPoweredShaftBlock(BlockBehaviour.Properties properties, Material material) {
        super(properties);
        this.material = material;
        this.shaftType = () -> ChemicalHelper.getBlock((TagPrefix)GreateTagPrefixes.shaft, (Material)material);
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntityTypes.TIERED_POWERED_SHAFT.get();
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_6144_() || !pPlayer.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        IPlacementHelper helper = PlacementHelpers.get((int)TieredShaftBlock.placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(pPlayer, pLevel, pState, pPos, pHit).placeInWorld(pLevel, (BlockItem)heldItem.m_41720_(), pPlayer, pHand, pHit);
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!TieredPoweredShaftBlock.stillValid((BlockState)pState, (LevelReader)pLevel, (BlockPos)pPos)) {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)this.getShaft().m_49966_().m_61124_((Property)ShaftBlock.AXIS, (Comparable)((Direction.Axis)pState.m_61143_((Property)AXIS)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)pState.m_61143_((Property)WATERLOGGED))), 3);
        }
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return this.getShaft().m_5456_().m_7968_();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }

    @Override
    public Block getShaft() {
        return this.shaftType.get();
    }

    public Material getMaterial() {
        return this.material;
    }
}

