/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.foundation.data.recipe.machine;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GCYMBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.GTCraftingComponents;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import electrolyte.greate.Greate;
import electrolyte.greate.GreateValues;
import electrolyte.greate.content.gtceu.machines.GreateMultiblockMachines;
import electrolyte.greate.content.gtceu.material.CogwheelProperty;
import electrolyte.greate.content.gtceu.material.GreateMaterialFlags;
import electrolyte.greate.content.gtceu.material.GreatePropertyKeys;
import electrolyte.greate.foundation.data.recipe.GreateCraftingComponents;
import electrolyte.greate.registry.EncasedFans;
import electrolyte.greate.registry.GreateMaterials;
import electrolyte.greate.registry.GreateTagPrefixes;
import electrolyte.greate.registry.MechanicalMixers;
import electrolyte.greate.registry.MechanicalPresses;
import electrolyte.greate.registry.Millstones;
import electrolyte.greate.registry.Pumps;
import electrolyte.greate.registry.Saws;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class GreateCraftingTableRecipes {
    public static void register(Consumer<FinishedRecipe> provider) {
        for (int tier = 0; tier < GreateValues.TM.length; ++tier) {
            Material tierMaterial = GreateValues.TM[tier];
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)Pumps.MECHANICAL_PUMPS[tier].getId(), (ItemStack)Pumps.MECHANICAL_PUMPS[tier].asStack(), (Object[])new Object[]{" RS", "wPC", " RS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, tierMaterial), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Rubber), Character.valueOf('P'), AllBlocks.FLUID_PIPE, Character.valueOf('C'), GreateCraftingComponents.COGWHEEL.get(tier)});
            if (tier == 0) continue;
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)MechanicalPresses.MECHANICAL_PRESSES[tier].getId(), (ItemStack)MechanicalPresses.MECHANICAL_PRESSES[tier].asStack(), (Object[])new Object[]{"PSP", "CMC", "wBh", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, tierMaterial), Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(tier), Character.valueOf('C'), GTCraftingComponents.CIRCUIT.get(tier), Character.valueOf('M'), GTCraftingComponents.CASING.get(tier), Character.valueOf('B'), new MaterialEntry(TagPrefix.block, tierMaterial)});
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)MechanicalMixers.MECHANICAL_MIXERS[tier].getId(), (ItemStack)MechanicalMixers.MECHANICAL_MIXERS[tier].asStack(), (Object[])new Object[]{" S ", "CMC", "wWh", Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(tier), Character.valueOf('C'), GTCraftingComponents.CIRCUIT.get(tier), Character.valueOf('M'), GTCraftingComponents.CASING.get(tier), Character.valueOf('W'), new MaterialEntry(GreateTagPrefixes.whisk, tierMaterial)});
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)Millstones.MILLSTONES[tier].getId(), (ItemStack)Millstones.MILLSTONES[tier].asStack(), (Object[])new Object[]{"CAC", "WHW", "wSh", Character.valueOf('A'), GreateCraftingComponents.COGWHEEL.get(tier), Character.valueOf('W'), Ingredient.m_204132_((TagKey)ItemTags.f_13175_), Character.valueOf('H'), GTCraftingComponents.CASING.get(tier), Character.valueOf('C'), GTCraftingComponents.CIRCUIT.get(tier), Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(tier)});
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)EncasedFans.FANS[tier].getId(), (ItemStack)EncasedFans.FANS[tier].asStack(), (Object[])new Object[]{" S ", "CMC", "wRh", Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(tier), Character.valueOf('C'), GTCraftingComponents.CIRCUIT.get(tier), Character.valueOf('M'), GTCraftingComponents.CASING.get(tier), Character.valueOf('R'), new MaterialEntry(TagPrefix.rotor, tierMaterial)});
            if (tier == 9) continue;
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)Saws.SAWS[tier].getId(), (ItemStack)Saws.SAWS[tier].asStack(), (Object[])new Object[]{"GSG", "MCM", "OHO", Character.valueOf('G'), GTCraftingComponents.CIRCUIT.get(tier), Character.valueOf('S'), new MaterialEntry(TagPrefix.toolHeadBuzzSaw, tierMaterial), Character.valueOf('M'), GTCraftingComponents.MOTOR.get(tier), Character.valueOf('C'), GTCraftingComponents.CASING.get(tier), Character.valueOf('H'), GreateCraftingComponents.SHAFT.get(tier), Character.valueOf('O'), GTCraftingComponents.CONVEYOR.get(tier)});
        }
        VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)Saws.SAWS[0].getId(), (ItemStack)Saws.SAWS[0].asStack(), (Object[])new Object[]{"GSG", "OCO", "MHM", Character.valueOf('G'), new MaterialEntry(TagPrefix.pipeSmallFluid, GTMaterials.TinAlloy), Character.valueOf('S'), new MaterialEntry(TagPrefix.toolHeadBuzzSaw, GreateMaterials.AndesiteAlloy), Character.valueOf('M'), new MaterialEntry(TagPrefix.plate, GTMaterials.WroughtIron), Character.valueOf('C'), GTCraftingComponents.CASING.get(0), Character.valueOf('H'), GreateCraftingComponents.SHAFT.get(0), Character.valueOf('O'), new MaterialEntry(TagPrefix.plate, GreateMaterials.AndesiteAlloy)});
        VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)MechanicalPresses.MECHANICAL_PRESSES[0].getId(), (ItemStack)MechanicalPresses.MECHANICAL_PRESSES[0].asStack(), (Object[])new Object[]{"PSP", "CMC", "wBh", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GreateMaterials.AndesiteAlloy), Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(0), Character.valueOf('C'), new MaterialEntry(TagPrefix.plate, GTMaterials.WroughtIron), Character.valueOf('M'), GTCraftingComponents.CASING.get(0), Character.valueOf('B'), new MaterialEntry(TagPrefix.block, GreateValues.TM[0])});
        VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)MechanicalMixers.MECHANICAL_MIXERS[0].getId(), (ItemStack)MechanicalMixers.MECHANICAL_MIXERS[0].asStack(), (Object[])new Object[]{"PSP", "CMC", "wWh", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GreateMaterials.AndesiteAlloy), Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(0), Character.valueOf('C'), new MaterialEntry(TagPrefix.plate, GTMaterials.WroughtIron), Character.valueOf('M'), GTCraftingComponents.CASING.get(0), Character.valueOf('W'), new MaterialEntry(GreateTagPrefixes.whisk, GreateMaterials.AndesiteAlloy)});
        VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)Millstones.MILLSTONES[0].getId(), (ItemStack)Millstones.MILLSTONES[0].asStack(), (Object[])new Object[]{"CAC", "WHW", "wSh", Character.valueOf('A'), GreateCraftingComponents.COGWHEEL.get(0), Character.valueOf('C'), new MaterialEntry(TagPrefix.plate, GreateMaterials.AndesiteAlloy), Character.valueOf('H'), GTCraftingComponents.CASING.get(0), Character.valueOf('W'), Ingredient.m_204132_((TagKey)ItemTags.f_13175_), Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(0)});
        VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)EncasedFans.FANS[0].getId(), (ItemStack)EncasedFans.FANS[0].asStack(), (Object[])new Object[]{"ASA", "CMC", "wRh", Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(0), Character.valueOf('A'), new MaterialEntry(TagPrefix.plate, GreateMaterials.AndesiteAlloy), Character.valueOf('C'), new MaterialEntry(TagPrefix.plate, GTMaterials.WroughtIron), Character.valueOf('M'), GTCraftingComponents.CASING.get(0), Character.valueOf('R'), new MaterialEntry(TagPrefix.rotor, GreateMaterials.AndesiteAlloy)});
        VanillaRecipeHelper.addShapedRecipe(provider, (String)(GreateMaterials.AndesiteAlloy.getName() + "_shaft"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.shaft, (Material)GreateMaterials.AndesiteAlloy).m_255036_(4), (Object[])new Object[]{"s ", " A", Character.valueOf('A'), new MaterialEntry(GreateTagPrefixes.alloy, GTMaterials.WroughtIron)});
        if (ConfigHolder.INSTANCE.recipes.hardToolArmorRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)AllItems.COPPER_DIVING_HELMET.getId(), (ItemStack)AllItems.COPPER_DIVING_HELMET.asStack(), (Object[])new Object[]{"PPP", "PGP", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Copper), Character.valueOf('G'), Tags.Items.GLASS});
            VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)AllItems.COPPER_BACKTANK.getId(), (ItemStack)AllItems.COPPER_BACKTANK.asStack(), (Object[])new Object[]{"ASA", "CBC", "wCf", Character.valueOf('A'), new MaterialEntry(TagPrefix.plate, GreateMaterials.AndesiteAlloy), Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(1), Character.valueOf('C'), new MaterialEntry(TagPrefix.plate, GTMaterials.Copper), Character.valueOf('B'), Blocks.f_152504_});
            VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)AllItems.COPPER_DIVING_HELMET.getId(), (ItemStack)AllItems.COPPER_DIVING_HELMET.asStack(), (Object[])new Object[]{"P P", "P P", "AhA", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Copper), Character.valueOf('A'), new MaterialEntry(TagPrefix.plate, GreateMaterials.AndesiteAlloy)});
        }
        if (GTCEuAPI.isHighTier()) {
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)Saws.SAWS[9].getId(), (ItemStack)Saws.SAWS[9].asStack(), (Object[])new Object[]{"GSG", "MCM", "OHO", Character.valueOf('G'), GTCraftingComponents.CIRCUIT.get(9), Character.valueOf('S'), new MaterialEntry(TagPrefix.toolHeadBuzzSaw, GTMaterials.Neutronium), Character.valueOf('M'), GTCraftingComponents.MOTOR.get(9), Character.valueOf('C'), GTCraftingComponents.CASING.get(9), Character.valueOf('H'), GreateCraftingComponents.SHAFT.get(9), Character.valueOf('O'), GTCraftingComponents.CONVEYOR.get(9)});
        }
        VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (ResourceLocation)Greate.id("wire_coating_factory"), (ItemStack)GreateMultiblockMachines.WIRE_COATING_FACTORY.asStack(), (Object[])new Object[]{"WCW", "PSP", "WCW", Character.valueOf('W'), GCYMBlocks.CASING_WATERTIGHT, Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('P'), GTItems.ELECTRIC_PUMP_IV.asStack(), Character.valueOf('S'), AllBlocks.SPOUT.asStack()});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)AllItems.ELECTRON_TUBE.getId(), (ItemStack)AllItems.ELECTRON_TUBE.asStack(), (Object[])new Object[]{" G ", " R ", "SSS", Character.valueOf('G'), GTItems.GLASS_TUBE, Character.valueOf('R'), AllItems.POLISHED_ROSE_QUARTZ, Character.valueOf('S'), new MaterialEntry(TagPrefix.wireGtSingle, GTMaterials.Steel)});
    }

    public static void registerMaterialRecipes(Consumer<FinishedRecipe> provider, Material material) {
        if (material.hasFlag(GreateMaterialFlags.GENERATE_ALLOY)) {
            VanillaRecipeHelper.addShapedRecipe(provider, (String)(material.getName() + "_alloy"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.alloy, (Material)material), (Object[])new Object[]{"NA", "AN", "fh", Character.valueOf('N'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('A'), new ItemStack((ItemLike)Blocks.f_50334_)});
        }
        if (material.hasFlag(GreateMaterialFlags.GENERATE_WHISK)) {
            VanillaRecipeHelper.addShapedRecipe(provider, (String)(material.getName() + "_whisk"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.whisk, (Material)material), (Object[])new Object[]{"fId", "PIP", "PPP", Character.valueOf('I'), new MaterialEntry(TagPrefix.ingot, material), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material)});
        }
        if (material.hasProperty(GreatePropertyKeys.BELT)) {
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (String)(material.getName() + "_belt_connector"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.beltConnector, (Material)material), (Object[])new Object[]{"PPP", "PPP", "f h", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material)});
        }
        if (!material.hasProperty(GreatePropertyKeys.KINETIC)) {
            return;
        }
        if (!material.getName().equals(GreateMaterials.AndesiteAlloy.getName())) {
            VanillaRecipeHelper.addShapedRecipe(provider, (String)(material.getName() + "_shaft"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.shaft, (Material)material).m_255036_(4), (Object[])new Object[]{"s ", " A", Character.valueOf('A'), ChemicalHelper.get((TagPrefix)GreateTagPrefixes.alloy, (Material)material)});
        }
        if (material.hasProperty(GreatePropertyKeys.COGWHEEL)) {
            CogwheelProperty prop = (CogwheelProperty)material.getProperty(GreatePropertyKeys.COGWHEEL);
            Material previousTierMaterial = prop.getPreviousMaterial();
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (String)(material.getName() + "_cogwheel"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.cogwheel, (Material)material), (Object[])new Object[]{"SP", "f ", Character.valueOf('S'), new MaterialEntry(GreateTagPrefixes.shaft, material), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, previousTierMaterial)});
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (String)(material.getName() + "_large_cogwheel"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.largeCogwheel, (Material)material), (Object[])new Object[]{"SP", "Pf", Character.valueOf('S'), new MaterialEntry(GreateTagPrefixes.shaft, material), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, previousTierMaterial)});
            VanillaRecipeHelper.addShapedRecipe(provider, (String)(material.getName() + "_large_cogwheel_from_little"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.largeCogwheel, (Material)material), (Object[])new Object[]{"CP", "f ", Character.valueOf('C'), new MaterialEntry(GreateTagPrefixes.cogwheel, material), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, previousTierMaterial)});
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (String)(material.getName() + "_gearbox"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.gearbox, (Material)material), (Object[])new Object[]{" S ", "SCS", "wSh", Character.valueOf('S'), new MaterialEntry(GreateTagPrefixes.shaft, material), Character.valueOf('C'), AllBlocks.ANDESITE_CASING});
            VanillaRecipeHelper.addShapedRecipe(provider, (boolean)true, (String)(material.getName() + "_vertical_gearbox"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.verticalGearbox, (Material)material), (Object[])new Object[]{"S S", "wCh", "S S", Character.valueOf('S'), new MaterialEntry(GreateTagPrefixes.shaft, material), Character.valueOf('C'), AllBlocks.ANDESITE_CASING});
            VanillaRecipeHelper.addShapelessRecipe(provider, (String)(material.getName() + "_gearbox_from_conversion"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.gearbox, (Material)material), (Object[])new Object[]{ChemicalHelper.get((TagPrefix)GreateTagPrefixes.verticalGearbox, (Material)material)});
            VanillaRecipeHelper.addShapelessRecipe(provider, (String)(material.getName() + "_vertical_gearbox_from_conversion"), (ItemStack)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.verticalGearbox, (Material)material), (Object[])new Object[]{ChemicalHelper.get((TagPrefix)GreateTagPrefixes.gearbox, (Material)material)});
        }
    }

    public static void registerCreateRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllItems.WRENCH.getId().m_135815_()), (ItemStack)AllItems.WRENCH.asStack(), (Object[])new Object[]{"PP", "PC", " S", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('C'), GreateCraftingComponents.COGWHEEL.get(0), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.TOOLBOXES.get(DyeColor.BROWN).getId().m_135815_()), (ItemStack)AllBlocks.TOOLBOXES.get(DyeColor.BROWN).asStack(), (Object[])new Object[]{" C ", "PHP", "wLf", Character.valueOf('C'), GreateCraftingComponents.COGWHEEL.get(0), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('H'), Ingredient.m_204132_((TagKey)Tags.Items.CHESTS_WOODEN), Character.valueOf('L'), Items.f_42454_});
        VanillaRecipeHelper.addShapelessRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.GEARSHIFT.getId().m_135815_()), (ItemStack)AllBlocks.GEARSHIFT.asStack(), (Object[])new Object[]{AllBlocks.ANDESITE_CASING, GreateCraftingComponents.COGWHEEL.get(0), Blocks.f_50088_});
        VanillaRecipeHelper.addShapelessRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.SEQUENCED_GEARSHIFT.getId().m_135815_()), (ItemStack)AllBlocks.SEQUENCED_GEARSHIFT.asStack(), (Object[])new Object[]{AllBlocks.BRASS_CASING, GreateCraftingComponents.COGWHEEL.get(0), AllItems.ELECTRON_TUBE});
        VanillaRecipeHelper.addShapelessRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.CLUTCH.getId().m_135815_()), (ItemStack)AllBlocks.CLUTCH.asStack(), (Object[])new Object[]{AllBlocks.ANDESITE_CASING, GreateCraftingComponents.SHAFT.get(0), Blocks.f_50088_});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.FLYWHEEL.getId().m_135815_()), (ItemStack)AllBlocks.FLYWHEEL.asStack(), (Object[])new Object[]{"BBB", "BSB", "BBB", Character.valueOf('B'), new MaterialEntry(TagPrefix.plate, GTMaterials.Brass), Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(0)});
    }

    public static void registerEasyCreateRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.WATER_WHEEL.getId().m_135815_()), (ItemStack)AllBlocks.WATER_WHEEL.asStack(), (Object[])new Object[]{"BBB", "BSB", "BBB", Character.valueOf('B'), ItemTags.f_13175_, Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(0)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.LARGE_WATER_WHEEL.getId().m_135815_()), (ItemStack)AllBlocks.LARGE_WATER_WHEEL.asStack(), (Object[])new Object[]{"PPP", "PWP", "PPP", Character.valueOf('P'), ItemTags.f_13175_, Character.valueOf('W'), GreateCraftingComponents.SHAFT.get(0)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.WINDMILL_BEARING.getId().m_135815_()), (ItemStack)AllBlocks.WINDMILL_BEARING.asStack(), (Object[])new Object[]{" S ", " T ", "wHf", Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('T'), Tags.Items.STONE, Character.valueOf('H'), GreateCraftingComponents.SHAFT.get(0)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.MECHANICAL_BEARING.getId().m_135815_()), (ItemStack)AllBlocks.MECHANICAL_BEARING.asStack(), (Object[])new Object[]{" S ", " C ", "wHf", Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('C'), AllBlocks.ANDESITE_CASING, Character.valueOf('H'), GreateCraftingComponents.SHAFT.get(0)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.CHAIN_CONVEYOR.getId().m_135815_()), (ItemStack)new ItemStack((ItemLike)AllBlocks.CHAIN_CONVEYOR.m_5456_(), 2), (Object[])new Object[]{" A ", "ACA", " A ", Character.valueOf('A'), AllBlocks.ANDESITE_CASING, Character.valueOf('C'), GreateCraftingComponents.LARGE_COGWHEEL.get(0)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.MECHANICAL_CRAFTER.getId().m_135815_()), (ItemStack)new ItemStack((ItemLike)AllBlocks.MECHANICAL_CRAFTER.m_5456_(), 3), (Object[])new Object[]{" C ", "EAE", " R ", Character.valueOf('C'), AllItems.ELECTRON_TUBE, Character.valueOf('R'), Blocks.f_50091_, Character.valueOf('E'), GreateCraftingComponents.COGWHEEL.get(0), Character.valueOf('A'), AllBlocks.BRASS_CASING});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.WEIGHTED_EJECTOR.getId().m_135815_()), (ItemStack)AllBlocks.WEIGHTED_EJECTOR.asStack(), (Object[])new Object[]{" G ", " D ", " C ", Character.valueOf('G'), new MaterialEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('D'), AllBlocks.DEPOT, Character.valueOf('C'), GreateCraftingComponents.COGWHEEL.get(0)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.GANTRY_CARRIAGE.getId().m_135815_()), (ItemStack)AllBlocks.GANTRY_CARRIAGE.asStack(), (Object[])new Object[]{" S ", " O ", " C ", Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('O'), AllBlocks.ANDESITE_CASING, Character.valueOf('C'), GreateCraftingComponents.COGWHEEL.get(0)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.TURNTABLE.getId().m_135815_()), (ItemStack)AllBlocks.TURNTABLE.asStack(), (Object[])new Object[]{" S ", " H ", Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('H'), GreateCraftingComponents.SHAFT.get(0)});
    }

    public static void registerHardCreateRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.CHUTE.getId().m_135815_()), (ItemStack)AllBlocks.CHUTE.asStack(), (Object[])new Object[]{"PGP", "PCP", "wPh", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('C'), Ingredient.m_204132_((TagKey)Tags.Items.CHESTS_WOODEN)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.BASIN.getId().m_135815_()), (ItemStack)AllBlocks.BASIN.asStack(), (Object[])new Object[]{"AhA", "AAA", Character.valueOf('A'), new MaterialEntry(TagPrefix.plate, GreateMaterials.AndesiteAlloy)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllItems.BRASS_HAND.getId().m_135815_()), (ItemStack)AllItems.BRASS_HAND.asStack(), (Object[])new Object[]{" A ", "PPP", "hPf", Character.valueOf('A'), new MaterialEntry(TagPrefix.plate, GreateMaterials.AndesiteAlloy), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Brass)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.DEPLOYER.getId().m_135815_()), (ItemStack)AllBlocks.DEPLOYER.asStack(), (Object[])new Object[]{" C ", "SRS", "hAf", Character.valueOf('C'), AllItems.ELECTRON_TUBE, Character.valueOf('R'), AllItems.BRASS_HAND, Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(0), Character.valueOf('A'), AllBlocks.ANDESITE_CASING});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.DEPOT.getId().m_135815_()), (ItemStack)AllBlocks.DEPOT.asStack(), (Object[])new Object[]{" A ", "hCf", Character.valueOf('A'), new MaterialEntry(TagPrefix.plate, GreateMaterials.AndesiteAlloy), Character.valueOf('C'), AllBlocks.ANDESITE_CASING});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.SPOUT.getId().m_135815_()), (ItemStack)AllBlocks.SPOUT.asStack(), (Object[])new Object[]{" C ", "hPf", Character.valueOf('C'), GreateCraftingComponents.PUMP.get(0), Character.valueOf('P'), AllBlocks.COPPER_CASING});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.MECHANICAL_CRAFTER.getId().m_135815_()), (ItemStack)new ItemStack((ItemLike)AllBlocks.MECHANICAL_CRAFTER.m_5456_(), 3), (Object[])new Object[]{" C ", "EAE", "wRh", Character.valueOf('C'), AllItems.ELECTRON_TUBE, Character.valueOf('R'), Blocks.f_50091_, Character.valueOf('E'), GreateCraftingComponents.COGWHEEL.get(0), Character.valueOf('A'), AllBlocks.BRASS_CASING});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.WEIGHTED_EJECTOR.getId().m_135815_()), (ItemStack)AllBlocks.WEIGHTED_EJECTOR.asStack(), (Object[])new Object[]{" G ", " D ", "wCf", Character.valueOf('G'), new MaterialEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('D'), AllBlocks.DEPOT, Character.valueOf('C'), GreateCraftingComponents.COGWHEEL.get(1)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.GANTRY_CARRIAGE.getId().m_135815_()), (ItemStack)AllBlocks.GANTRY_CARRIAGE.asStack(), (Object[])new Object[]{" S ", " O ", "wCf", Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('O'), AllBlocks.ANDESITE_CASING, Character.valueOf('C'), GreateCraftingComponents.COGWHEEL.get(1)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.TURNTABLE.getId().m_135815_()), (ItemStack)AllBlocks.TURNTABLE.asStack(), (Object[])new Object[]{" S ", "wHf", Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('H'), GreateCraftingComponents.SHAFT.get(1)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.WATER_WHEEL.getId().m_135815_()), (ItemStack)AllBlocks.WATER_WHEEL.asStack(), (Object[])new Object[]{"BBB", "BSB", "BBB", Character.valueOf('B'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('S'), GreateCraftingComponents.SHAFT.get(0)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.LARGE_WATER_WHEEL.getId().m_135815_()), (ItemStack)AllBlocks.LARGE_WATER_WHEEL.asStack(), (Object[])new Object[]{"PPP", "PWP", "PPP", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('W'), GreateCraftingComponents.SHAFT.get(1)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.WINDMILL_BEARING.getId().m_135815_()), (ItemStack)AllBlocks.WINDMILL_BEARING.asStack(), (Object[])new Object[]{" S ", " T ", "wHf", Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('T'), Tags.Items.STONE, Character.valueOf('H'), GreateCraftingComponents.SHAFT.get(2)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.MECHANICAL_BEARING.getId().m_135815_()), (ItemStack)AllBlocks.MECHANICAL_BEARING.asStack(), (Object[])new Object[]{" S ", " C ", "wHf", Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('C'), AllBlocks.ANDESITE_CASING, Character.valueOf('H'), GreateCraftingComponents.SHAFT.get(1)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.ANALOG_LEVER.getId().m_135815_()), (ItemStack)AllBlocks.ANALOG_LEVER.asStack(), (Object[])new Object[]{" B ", " S ", " C ", Character.valueOf('B'), Blocks.f_50124_, Character.valueOf('S'), Tags.Items.RODS_WOODEN, Character.valueOf('C'), AllBlocks.ANDESITE_CASING});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllItems.TRANSMITTER.getId().m_135815_()), (ItemStack)AllItems.TRANSMITTER.asStack(), (Object[])new Object[]{" E ", "CCC", "wRh", Character.valueOf('E'), AllItems.ELECTRON_TUBE, Character.valueOf('R'), Items.f_42451_, Character.valueOf('C'), new MaterialEntry(TagPrefix.plate, GTMaterials.Copper)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.DISPLAY_LINK.getId().m_135815_()), (ItemStack)AllBlocks.DISPLAY_LINK.asStack(), (Object[])new Object[]{" E ", "wCh", Character.valueOf('E'), AllItems.TRANSMITTER, Character.valueOf('C'), AllBlocks.BRASS_CASING});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.FLUID_TANK.getId().m_135815_()), (ItemStack)AllBlocks.FLUID_TANK.asStack(), (Object[])new Object[]{"SPS", "PBP", "SPS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Copper), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Glass), Character.valueOf('B'), GTMachines.WOODEN_DRUM.asStack()});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.FLUID_TANK.getId().m_135815_()).m_266382_("_annealed"), (ItemStack)new ItemStack((ItemLike)AllBlocks.FLUID_TANK.m_5456_(), 2), (Object[])new Object[]{"SPS", "PBP", "SPS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.AnnealedCopper), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Glass), Character.valueOf('B'), GTMachines.WOODEN_DRUM.asStack()});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.ITEM_VAULT.getId().m_135815_()), (ItemStack)AllBlocks.ITEM_VAULT.asStack(), (Object[])new Object[]{"SPS", "PBP", "SPS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('B'), GTMachines.WOODEN_CRATE.asStack()});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.ITEM_VAULT.getId().m_135815_()), (ItemStack)new ItemStack((ItemLike)AllBlocks.ITEM_VAULT.m_5456_(), 2), (Object[])new Object[]{"SPS", "PBP", "SPS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.WroughtIron), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('B'), GTMachines.WOODEN_CRATE.asStack()});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllBlocks.CHAIN_CONVEYOR.getId().m_135815_()), (ItemStack)new ItemStack((ItemLike)AllBlocks.CHAIN_CONVEYOR.m_5456_(), 2), (Object[])new Object[]{" A ", "ACA", "wAh", Character.valueOf('A'), AllBlocks.ANDESITE_CASING, Character.valueOf('C'), GreateCraftingComponents.LARGE_COGWHEEL.get(1)});
        VanillaRecipeHelper.addShapedRecipe(provider, (ResourceLocation)Greate.id(AllItems.ELECTRON_TUBE.getId().m_135815_()), (ItemStack)AllItems.ELECTRON_TUBE.asStack(), (Object[])new Object[]{" R ", " G ", "SSS", Character.valueOf('R'), AllItems.POLISHED_ROSE_QUARTZ, Character.valueOf('G'), GTItems.GLASS_TUBE, Character.valueOf('S'), new MaterialEntry(TagPrefix.wireGtSingle, GTMaterials.Steel)});
    }
}

