/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.foundation.recipe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TieredRecipeFinder {
    private static Cache<Object, List<Pair<ItemStack, List<Recipe<?>>>>> cachedSearches = CacheBuilder.newBuilder().build();
    private static boolean shouldRefreshRecipe = false;
    public static final ResourceManagerReloadListener LISTENER = r -> {
        cachedSearches.invalidateAll();
        shouldRefreshRecipe = true;
    };

    public static Optional<Recipe<?>> findRecipe(Object cacheKey, Level level, RecipeWrapper wrapper, Predicate<Recipe<?>> typeAndIngCondition, Predicate<Recipe<?>> otherConditions) {
        Optional<Pair> pair;
        List recipes;
        if (!cachedSearches.asMap().containsKey(cacheKey)) {
            TieredRecipeFinder.createPairList(cacheKey, level, wrapper, typeAndIngCondition);
        }
        if ((recipes = (List)cachedSearches.asMap().get(cacheKey)).stream().noneMatch(r -> wrapper.m_8020_(0).m_150930_(((ItemStack)r.getFirst()).m_41720_()))) {
            TieredRecipeFinder.createPairList(cacheKey, level, wrapper, typeAndIngCondition);
        }
        if ((pair = recipes.stream().filter(r -> wrapper.m_8020_(0).m_150930_(((ItemStack)r.getFirst()).m_41720_())).findFirst()).isEmpty()) {
            return Optional.empty();
        }
        Pair recipe = pair.get();
        for (Recipe r2 : (List)recipe.getSecond()) {
            if (!Optional.of(r2).filter(otherConditions).isPresent()) continue;
            return Optional.of(r2);
        }
        return Optional.empty();
    }

    private static void createPairList(Object cacheKey, Level level, RecipeWrapper wrapper, Predicate<Recipe<?>> conditions) {
        List<Recipe<?>> recipes = TieredRecipeFinder.startSearch(level, conditions);
        ArrayList<Pair> pairList = (ArrayList<Pair>)cachedSearches.getIfPresent(cacheKey);
        if (pairList == null) {
            pairList = new ArrayList<Pair>();
            ArrayList recipeList = new ArrayList(recipes);
            pairList.add(new Pair((Object)wrapper.m_8020_(0), recipeList));
            cachedSearches.put(cacheKey, pairList);
        } else {
            ((List)cachedSearches.asMap().get(cacheKey)).add(new Pair((Object)wrapper.m_8020_(0), new ArrayList(recipes)));
        }
    }

    private static List<Recipe<?>> startSearch(Level level, Predicate<? super Recipe<?>> conditions) {
        return level.m_7465_().m_44051_().stream().filter(conditions).collect(Collectors.toList());
    }

    public static boolean shouldRefreshRecipe() {
        if (shouldRefreshRecipe) {
            shouldRefreshRecipe = false;
            return true;
        }
        return false;
    }
}

