/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.infrastructure.config;

import com.simibubi.create.api.stress.BlockStressValues;
import electrolyte.greate.infrastructure.config.GClient;
import electrolyte.greate.infrastructure.config.GServer;
import electrolyte.greate.infrastructure.config.GStress;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GreateConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    public static GClient CLIENT;
    private static GServer SERVER;

    public static GClient client() {
        return CLIENT;
    }

    public static GServer server() {
        return SERVER;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type type) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(b -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(b);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(type, config);
        return (T)config;
    }

    public static void register(ModLoadingContext context) {
        if (context.getActiveNamespace().equals("greate")) {
            SERVER = GreateConfigs.register(GServer::new, ModConfig.Type.SERVER);
            for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
                context.registerConfig(pair.getKey(), (IConfigSpec)pair.getValue().specification);
            }
            GStress stress = GreateConfigs.server().kinetics.stressValues;
            BlockStressValues.IMPACTS.registerProvider(stress::getImpact);
            BlockStressValues.CAPACITIES.registerProvider(stress::getCapacity);
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onLoad();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onReload();
        }
    }
}

