/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.infrastructure.ponder.scenes;

import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TieredFanScenes {
    public static void processing(SceneBuilder sceneBuilder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(sceneBuilder);
        scene.title("fan_processing", "Processing Items using Encased Fans");
        scene.configureBasePlate(1, 0, 5);
        scene.world().showSection(util.select().layer(0).substract(util.select().position(0, 0, 4)), Direction.UP);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(6, 1, 2, 5, 1, 2).add(util.select().position(1, 1, 2)), Direction.DOWN);
        scene.idle(25);
        BlockPos blockPos = util.grid().at(4, 1, 2);
        ElementLink blockInFront = scene.world().showIndependentSection(util.select().position(3, 1, 0), Direction.SOUTH);
        scene.world().moveSection(blockInFront, util.vector().of(1.0, 0.0, 2.0), 0);
        scene.world().setBlock(blockPos, Blocks.f_49991_.m_49966_(), false);
        scene.idle(10);
        scene.overlay().showOutlineWithText(util.select().fromTo(blockPos, blockPos.m_122025_(2)), 80).colored(PonderPalette.RED).text("When passing through lava, the Air Flow becomes Heated");
        scene.idle(80);
        ItemStack stack = new ItemStack((ItemLike)Items.f_41833_);
        ItemStack smelted = new ItemStack((ItemLike)Items.f_42417_);
        ElementLink entityLink = scene.world().createItemEntity(util.vector().centerOf(blockPos.m_122025_(2).m_6630_(2)), util.vector().of(0.0, 0.1, 0.0), stack);
        scene.idle(15);
        scene.world().modifyEntity(entityLink, e -> e.m_20334_((double)-0.2f, 0.0, 0.0));
        Vec3 itemVec = util.vector().blockSurface(util.grid().at(1, 1, 2), Direction.EAST).m_82520_(0.1, 0.0, 0.0);
        scene.overlay().showControls(itemVec, Pointing.DOWN, 20).withItem(stack);
        scene.idle(20);
        scene.effects().emitParticles(itemVec.m_82520_(0.0, (double)0.2f, 0.0), scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123755_, Vec3.f_82478_), 1.0f, 60);
        scene.overlay().showText(80).colored(PonderPalette.WHITE).pointAt(itemVec).placeNearTarget().attachKeyFrame().text("Items caught in the area will be smelted");
        scene.idle(60);
        scene.world().modifyEntities(ItemEntity.class, ie -> ie.m_32045_(smelted));
        scene.idle(40);
        scene.overlay().showControls(itemVec, Pointing.DOWN, 20).withItem(smelted);
        scene.idle(20);
        scene.world().modifyEntities(ItemEntity.class, Entity::m_146870_);
        scene.idle(20);
        scene.overlay().showText(80).colored(PonderPalette.RED).pointAt(itemVec).placeNearTarget().text("Food items thrown here would be incinerated");
        scene.idle(40);
        BlockState campfire = Blocks.f_50083_.m_49966_();
        scene.world().hideIndependentSection(blockInFront, Direction.NORTH);
        scene.idle(15);
        scene.world().setBlock(util.grid().at(3, 1, 0), campfire, false);
        scene.world().setBlock(blockPos, campfire, true);
        blockInFront = scene.world().showIndependentSection(util.select().position(3, 1, 0), Direction.NORTH);
        scene.world().moveSection(blockInFront, util.vector().of(1.0, 0.0, 2.0), 0);
        scene.idle(50);
        scene.overlay().showOutlineWithText(util.select().fromTo(blockPos, blockPos.m_122025_(2)), 60).colored(PonderPalette.BLACK).attachKeyFrame().text("Instead, a setup for Smoking using Fire should be used for them");
        scene.idle(80);
        BlockState water = Blocks.f_49990_.m_49966_();
        scene.world().hideIndependentSection(blockInFront, Direction.NORTH);
        scene.idle(15);
        scene.world().setBlock(util.grid().at(3, 1, 0), water, false);
        scene.world().setBlock(blockPos, water, true);
        blockInFront = scene.world().showIndependentSection(util.select().position(3, 1, 0), Direction.NORTH);
        scene.world().moveSection(blockInFront, util.vector().of(1.0, 0.0, 2.0), 0);
        scene.idle(20);
        scene.overlay().showOutlineWithText(util.select().fromTo(blockPos, blockPos.m_122025_(2)), 60).colored(PonderPalette.MEDIUM).attachKeyFrame().text("Air Flows passing through water create a Washing Setup");
        scene.idle(70);
        stack = new ItemStack((ItemLike)Items.f_41831_, 16);
        ItemStack washed = new ItemStack((ItemLike)Items.f_42587_, 16);
        entityLink = scene.world().createItemEntity(util.vector().centerOf(blockPos.m_122025_(2).m_6630_(2)), util.vector().of(0.0, 0.1, 0.0), stack);
        scene.idle(15);
        scene.world().modifyEntity(entityLink, e -> e.m_20334_((double)-0.2f, 0.0, 0.0));
        scene.overlay().showControls(itemVec, Pointing.DOWN, 20).withItem(stack);
        scene.idle(20);
        scene.effects().emitParticles(itemVec.m_82520_(0.0, (double)0.2f, 0.0), scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123764_, Vec3.f_82478_), 1.0f, 60);
        scene.overlay().showText(50).colored(PonderPalette.WHITE).pointAt(itemVec).placeNearTarget().text("Some interesting new processing can be done with it");
        scene.idle(60);
        scene.world().modifyEntities(ItemEntity.class, ie -> ie.m_32045_(washed));
        scene.overlay().showControls(itemVec, Pointing.DOWN, 20).withItem(washed);
        scene.idle(20);
        scene.world().modifyEntities(ItemEntity.class, Entity::m_146870_);
        scene.idle(20);
        scene.overlay().showText(100).colored(PonderPalette.RED).pointAt(util.vector().topOf(blockPos.m_122029_())).placeNearTarget().attachKeyFrame().text("The Speed of the Fan DOES affect the processing speed, in addition to its range");
        scene.world().destroyBlock(util.grid().at(1, 1, 2));
        scene.idle(110);
        ElementLink cogs = scene.world().makeSectionIndependent(util.select().fromTo(6, 1, 2, 6, 0, 3).add(util.select().fromTo(4, 0, 2, 5, 0, 2)));
        scene.world().modifyKineticSpeed(util.select().position(5, 2, 2), f -> Float.valueOf(f.floatValue() / 3.0f));
        scene.world().moveSection(cogs, util.vector().of(0.0, 1.0, 0.0), 15);
        scene.world().moveSection(blockInFront, util.vector().of(0.0, 1.0, 0.0), 15);
        scene.world().destroyBlock(blockPos.m_122029_());
        scene.world().showSection(util.select().position(blockPos.m_122029_().m_7494_()), Direction.DOWN);
        scene.world().setBlock(blockPos.m_7494_(), Blocks.f_49990_.m_49966_(), false);
        ItemStack sand = new ItemStack((ItemLike)Items.f_41830_);
        ItemStack clay = new ItemStack((ItemLike)Items.f_42461_);
        scene.idle(20);
        BlockPos depos = util.grid().at(3, 4, 2);
        ElementLink depot = scene.world().showIndependentSection(util.select().position(depos), Direction.DOWN);
        scene.world().moveSection(depot, util.vector().of(-1.0, -3.0, 0.0), 0);
        scene.world().createItemOnBeltLike(depos, Direction.NORTH, sand);
        scene.idle(10);
        Vec3 depotTop = util.vector().topOf(2, 1, 2).m_82520_(0.0, 0.25, 0.0);
        scene.effects().emitParticles(depotTop, scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123764_, Vec3.f_82478_), 0.5f, 30);
        scene.idle(30);
        scene.world().modifyBlockEntityNBT(util.select().position(depos), DepotBlockEntity.class, nbt -> nbt.m_128365_("HeldItem", (Tag)new TransportedItemStack(clay).serializeNBT()));
        scene.effects().emitParticles(depotTop, scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123764_, Vec3.f_82478_), 0.5f, 30);
        scene.overlay().showText(90).pointAt(depotTop).attachKeyFrame().text("Fan Processing can also be applied to Items on Depots and Belts");
        scene.idle(100);
        scene.world().moveSection(depot, util.vector().of(-1.0, 0.0, 0.0), 15);
        scene.idle(15);
        ElementLink largeCog = scene.world().showIndependentSection(util.select().position(1, 2, 4), Direction.UP);
        ElementLink belt = scene.world().showIndependentSection(util.select().fromTo(3, 3, 1, 1, 3, 3), Direction.DOWN);
        scene.world().moveSection(largeCog, util.vector().of(-1.0, -2.0, 0.0), 0);
        scene.world().moveSection(belt, util.vector().of(-1.0, -2.0, 0.0), 0);
        ElementLink transported = scene.world().createItemOnBelt(util.grid().at(3, 3, 3), Direction.SOUTH, sand);
        scene.idle(60);
        scene.effects().emitParticles(depotTop, scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123764_, Vec3.f_82478_), 0.5f, 25);
        scene.idle(25);
        scene.world().changeBeltItemTo(transported, new ItemStack((ItemLike)Items.f_42461_));
        scene.effects().emitParticles(depotTop, scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123764_, Vec3.f_82478_), 0.5f, 25);
        scene.idle(60);
        scene.world().setKineticSpeed(util.select().position(1, 2, 4).add(util.select().fromTo(3, 3, 1, 1, 3, 3)), 0.0f);
    }
}

