/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.mixin;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BasinBlockEntity.class})
public abstract class MixinBasinBlockEntity
extends SmartBlockEntity {
    @Shadow(remap=false)
    public SmartFluidTankBehaviour inputTank;
    @Shadow(remap=false)
    protected SmartFluidTankBehaviour outputTank;
    @Shadow(remap=false)
    private boolean contentsChanged;
    @Shadow(remap=false)
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    @Shadow(remap=false)
    protected LazyOptional<IFluidHandler> fluidCapability;

    @Shadow(remap=false)
    public abstract boolean isEmpty();

    public MixinBasinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"addBehaviours"}, at={@At(value="RETURN")}, remap=false)
    private void greate_addBehaviors(List<BlockEntityBehaviour> behaviours, CallbackInfo ci) {
        behaviours.remove(this.inputTank);
        behaviours.remove(this.outputTank);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 2, 16000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 2, 16000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTank);
    }

    @Inject(method={"addToGoggleTooltip"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void greate_addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, CallbackInfoReturnable<Boolean> cir) {
        CreateLang.translate((String)"gui.goggles.basin_contents", (Object[])new Object[0]).forGoggles(tooltip);
        IItemHandlerModifiable items = (IItemHandlerModifiable)this.itemCapability.orElse((Object)new ItemStackHandler());
        IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0));
        boolean isEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            CreateLang.text((String)"").add(Component.m_237115_((String)stackInSlot.m_41786_().getString()).m_130940_(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stackInSlot.m_41613_())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.text((String)"").add(CreateLang.fluidName((FluidStack)fluidStack).add(CreateLang.text((String)" ")).style(ChatFormatting.GRAY).add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        cir.setReturnValue((Object)true);
    }
}

